#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <string.hpp>

String &String::insert(int pos, char c)
{
    if (pos > length()) { // pos == length() is concatenate
        errno = ERANGE;
        return *this;
    }
    int n = length()+1;
    srep *p = new(n) srep(n);
    if (!p) {
        errno = ENOMEM;
        return *this;
    }
    memmove(p->body,body(),pos);
    *(p->body+pos) = c;
    memmove(p->body+pos+1, body()+pos, length()-pos);
    if (rp) {
        if (--rp->refs < 1)
        delete rp;
    }
    rp = p;
    rp->refs++;
    return *this;
}
