#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <string.hpp>

String &String::insert(int pos, const String &a)
{
    if (!a.length())
        return *this;
    if (pos > length()) { // pos == length() is concatenate
        errno = ERANGE;
        return *this;
    }
    int n = length()+a.length();
    srep *p = new(n) srep(n);
    if (!p) {
        errno = ENOMEM;
        return *this;
    }
    memmove(p->body,body(),pos);
    memmove(p->body+pos, a.body(), a.length());
    memmove(p->body+pos+a.length(), body()+pos, length()-pos);
    if (rp) {
        if (--rp->refs < 1)
        delete rp;
    }
    rp = p;
    rp->refs++;
    return *this;
}
