#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <string.hpp>

int String::index(const String &a, int pos) const
{
    if (a.length() > length()) return -1;
    int al = a.length(), lim = length() - al--;
    if (pos < 0 || pos > lim)
        return -1;
    if (!a.rp) return pos;
    const char *p = body()+pos, *q = a.body(), *r = q+1;
    for (; pos <= lim; ++pos) {
        if (*p++ != *q) continue;
        if (!strncmp(p,r,al)) return pos;
    }
    return -1;
}

int String::index(const char *s, int pos) const
{
    int sl = strlen(s);
    if (sl > length()) return -1;
    if (!*s) return pos;
    int lim = length() - sl--;
    if (pos < 0 || pos > lim)
        return -1;
    const char *p = body()+pos, *r = s+1;
    for (; pos <= lim; ++pos) {
        if (*p++ != *s) continue;
        if (!strncmp(p,r,sl)) return pos;
    }
    return -1;
}

int String::index(char c, int pos) const
{
    if (!rp) return -1;
    int lim = length() - 1;
    if (pos < 0 || pos > lim)
        return -1;
    const char *p = body()+pos;
    for (; pos <= lim; ++pos)
        if (*p++ == c) return pos;
    return -1;
}
