#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <string.hpp>

String::String() : rp(0) {}

String::String(const char *s, int count)
{
    int n = count? count: strlen(s);
    if (n >= 0) {
        rp = new(n) srep(n,s);
        if (!rp)
            errno = ENOMEM;
        else 
            rp->refs++;
    } else
        rp = 0;
}

String::String(char c)
{
    rp = new(1) srep(1,&c);
    if (!rp)
        errno = ENOMEM;
    else 
        rp->refs++;
}

String::String(const String &s)
{
    rp = s.rp;
    if (rp)
        rp->refs++;
}
