/* ------------ menu.h ------------- */

#ifndef MENU_H
#define MENU_H

/* ----------- popdown menu selection structure
       one for each selection on a popdown menu --------- */
struct PopDown {
    unsigned char *SelectionTitle; /* title of the selection */
    int ActionId;          /* the command executed        */
    int Accelerator;       /* the accelerator key         */
    int Attrib;            /* INACTIVE | CHECKED | TOGGLE */
    char *help;            /* Help mnemonic               */
};

/* ----------- popdown menu structure
       one for each popdown menu on the menu bar -------- */
typedef struct Menu {
    char *Title;           /* title on the menu bar       */
    void (*PrepMenu)(void *, struct Menu *); /* function  */
	char *StatusText;      /* text for the status bar     */
    struct PopDown Selections[23]; /* up to 23 selections */
    int Selection;         /* most recent selection       */
} MENU;

/* --------- macros to define a menu bar with
                 popdowns and selections ------------- */
#define SEPCHAR "\xc4"
#define DEFMENU(m) MENU m[]= {
#define POPDOWN(ttl,func,stat)  {ttl,func,stat,{
#define SELECTION(stxt,acc,id,attr)   {stxt,acc,id,attr,#acc},
#define SEPARATOR                     {SEPCHAR},
#define ENDPOPDOWN                    {NULL},0}},
#define ENDMENU                {NULL} };

/* -------- menu selection attributes -------- */
#define INACTIVE    1
#define CHECKED     2
#define TOGGLE      4

/* --------- the standard menus ---------- */
extern MENU MainMenu[];
extern MENU SystemMenu[];
extern MENU *ActiveMenu;

int MenuHeight(struct PopDown *);
int MenuWidth(struct PopDown *);

#endif

