/* ------------------- htree.h -------------------- */

typedef unsigned int BYTECOUNTER;

/* ---- Huffman tree structure ---- */
struct htree    {
    unsigned char ch;       /* character value             */
    BYTECOUNTER cnt;        /* character frequency         */
    int parent;             /* offset to parent node       */
    int right;              /* offset to right child node  */
    int left;               /* offset to left child node   */
};

extern struct htree *ht;
extern int root;

#ifdef INCLUDE_COMPRESS_HELPFILE

void buildtree(void);
FILE *OpenHelpFile(void);
void HelpFilePosition(long *, int *);
void *GetHelpLine(char *);
void SeekHelpLine(long, int);

#else

#define OpenHelpFile()        helpfp=fopen(DFLAT_APPLICATION ".TXT", "rt")
#define HelpFilePosition(o,b) *o=ftell(helpfp)
#define GetHelpLine(s)        fgets(s,160,helpfp)
#define SeekHelpLine(o,b)     fseek(helpfp,o,0)

#endif
