/* ----------- dflatmsg.h ------------ */

/*
 * message foundation file
 * make message changes here
 * other source files will adapt
 */

/* ------------- process communication messages --------- */
TE(START),              /* start message processing       */
TE(STOP),               /* stop message processing        */
TE(COMMAND),            /* send a command to a window     */
/* ------------- window management messages ------------- */
TE(CREATE_WINDOW),      /* create a window                */
TE(SHOW_WINDOW),        /* show a window                  */
TE(HIDE_WINDOW),        /* hide a window                  */
TE(CLOSE_WINDOW),       /* delete a window                */
TE(SETFOCUS),           /* set and clear the focus        */
TE(PAINT),              /* paint the window's data space  */
TE(BORDER),             /* paint the window's border      */
TE(TITLE),              /* display the window's title     */
TE(MOVE),               /* move the window                */
TE(SIZE),               /* change the window's size       */
TE(MAXIMIZE),           /* maximize the window            */
TE(MINIMIZE),           /* minimize the window            */
TE(RESTORE),            /* restore the window             */
TE(INSIDE_WINDOW),      /* test x/y inside a window       */
/* ------------- clock messages ------------------------- */
TE(CLOCKTICK),          /* the clock ticked               */
TE(CAPTURE_CLOCK),      /* capture clock into a window    */
TE(RELEASE_CLOCK),      /* release clock to the system    */
/* ------------- keyboard and screen messages ----------- */
TE(KEYBOARD),           /* key was pressed                */
TE(CAPTURE_KEYBOARD),   /* capture keyboard into a window */
TE(RELEASE_KEYBOARD),   /* release keyboard to system     */
TE(KEYBOARD_CURSOR),    /* position the keyboard cursor   */
TE(CURRENT_KEYBOARD_CURSOR), /*read the cursor position   */
TE(HIDE_CURSOR),        /* hide the keyboard cursor       */
TE(SHOW_CURSOR),        /* display the keyboard cursor    */
TE(SAVE_CURSOR),        /* save the cursor's configuration*/
TE(RESTORE_CURSOR),     /* restore the saved cursor       */
TE(SHIFT_CHANGED),      /* the shift status changed       */
/* ------------- mouse messages ------------------------- */
TE(MOUSE_INSTALLED),    /* test for mouse installed       */
TE(RIGHT_BUTTON),       /* right button pressed           */
TE(LEFT_BUTTON),        /* left button pressed            */
TE(DOUBLE_CLICK),       /* left button double-clicked     */
TE(MOUSE_MOVED),        /* mouse changed position         */
TE(BUTTON_RELEASED),    /* mouse button released          */
TE(CURRENT_MOUSE_CURSOR),/* get mouse position            */
TE(MOUSE_CURSOR),       /* set mouse position             */
TE(SHOW_MOUSE),         /* make mouse cursor visible      */
TE(HIDE_MOUSE),         /* hide mouse cursor              */
TE(WAITMOUSE),          /* wait until button released     */
TE(TESTMOUSE),          /* test any mouse button pressed  */
TE(CAPTURE_MOUSE),      /* capture mouse into a window    */
TE(RELEASE_MOUSE),      /* release the mouse to system    */
/* ------------- text box messages ---------------------- */
TE(ADDTEXT),            /* add text to the text box       */
TE(CLEARTEXT),          /* clear the edit box             */
TE(SETTEXT),            /* set address of text buffer     */
TE(SCROLL),             /* vertical scroll of text box    */
TE(HORIZSCROLL),        /* horizontal scroll of text box  */
/* ------------- edit box messages ---------------------- */
TE(EB_GETTEXT),         /* get text from an edit box      */
TE(EB_PUTTEXT),         /* put text into an edit box      */
/* ------------- menubar messages ----------------------- */
TE(BUILDMENU),          /* build the menu display         */
TE(SELECTION),          /* menubar selection              */
/* ------------- popdown messages ----------------------- */
TE(BUILD_SELECTIONS),   /* build the menu display         */
TE(CLOSE_POPDOWN),      /* tell parent popdown is closing */
/* ------------- list box messages ---------------------- */
TE(LB_SELECTION),       /* sent to parent on selection    */
TE(LB_CHOOSE),          /* sent when user chooses         */
TE(LB_CURRENTSELECTION),/* return the current selection   */
TE(LB_GETTEXT),         /* return the text of selection   */
TE(LB_SETSELECTION),    /* sets the listbox selection     */
/* ------------- dialog box messages -------------------- */
TE(INITIATE_DIALOG),    /* begin a dialog                 */
TE(ENTERFOCUS),         /* tell DB control got focus      */
TE(LEAVEFOCUS),         /* tell DB control lost focus     */
TE(ENDDIALOG)           /* end a dialog                   */

