/* ---------------- config.h -------------- */

#ifndef CONFIG_H
#define CONFIG_H

#define DFLAT_APPLICATION "MEMOPAD"

#ifdef BUILD_FULL_DFLAT
#define INCLUDE_SYSTEM_MENUS
#define INCLUDE_CLOCK
#define INCLUDE_MULTIDOCS
#define INCLUDE_SCROLLBARS
#define INCLUDE_SHADOWS
#define INCLUDE_DIALOG_BOXES
#define INCLUDE_CLIPBOARD
#define INCLUDE_MULTILINE
#define INCLUDE_LOGGING
#endif

struct colors {
    /* ------------ colors ------------ */
    char ApplicationFG,  ApplicationBG;
    char NormalFG,       NormalBG;
    char ButtonFG,       ButtonBG;
    char ButtonSelFG,    ButtonSelBG;
    char DialogFG,       DialogBG;
    char ErrorBoxFG,     ErrorBoxBG;
    char MessageBoxFG,   MessageBoxBG;
    char HelpBoxFG,      HelpBoxBG;
    char InFocusTitleFG, InFocusTitleBG;
    char TitleFG,        TitleBG;
    char DummyFG,        DummyBG;
    char TextBoxFG,      TextBoxBG;
    char TextBoxSelFG,   TextBoxSelBG;
    char TextBoxFrameFG, TextBoxFrameBG;
    char ListBoxFG,      ListBoxBG;
    char ListBoxSelFG,   ListBoxSelBG;
    char ListBoxFrameFG, ListBoxFrameBG;
    char EditBoxFG,      EditBoxBG;
    char EditBoxSelFG,   EditBoxSelBG;
    char EditBoxFrameFG, EditBoxFrameBG;
    char MenuBarFG,      MenuBarBG;
    char MenuBarSelFG,   MenuBarSelBG;
    char PopDownFG,      PopDownBG;
    char PopDownSelFG,   PopDownSelBG;
    char InactiveSelFG;
    char ShortCutFG;
};

/* ----------- configuration parameters ----------- */
typedef struct config {
    char version[sizeof DFLAT_APPLICATION + sizeof VERSION];
    char mono;         /* 0=color, 1=mono, 2=reverse mono    */
    int InsertMode;    /* Editor insert mode                 */
    int Tabs;          /* Editor tab stops                   */
    int WordWrap;      /* True to word wrap editor           */
    int Border;        /* True for application window border */
    int Title;         /* True for application window title  */
    int Texture;       /* True for textured appl window      */
    int ScreenLines;   /* Number of screen lines (25/43/50)  */
    struct colors clr; /* Colors                             */
} CONFIG;

extern CONFIG cfg;
extern struct colors color, bw, reverse;

int LoadConfig(void);
void SaveConfig(void);

#endif

