/* ----------- message.h ------------ */

#ifndef MESSAGES_H
#define MESSGAES_H

#define MAXMESSAGES 50
#define DELAYTICKS 1
#define FIRSTDELAY 7
#define DOUBLETICKS 5

/* --------- event message codes ----------- */
typedef enum messages {
    START,
    STOP,
	CLOCKTICK,
	CAPTURE_CLOCK,
	RELEASE_CLOCK,

	CREATE_WINDOW,
	SHOW_WINDOW,
	HIDE_WINDOW,
	CLOSE_WINDOW,
	SETFOCUS,
	PAINT,
	BORDER,
	MOVE,
	SIZE,
	MAXIMIZE,
	MINIMIZE,
	RESTORE,
	TITLE,
	INSIDE_WINDOW,

	ADDTEXT,
	CLEARTEXT,
	SETTEXT,
	SELECTION,
	SCROLL,
	HORIZSCROLL,

	MOUSE_INSTALLED,
    RIGHT_BUTTON,
    LEFT_BUTTON,
	DOUBLE_CLICK,
    MOUSE_MOVED,
    BUTTON_RELEASED,
    CURRENT_MOUSE_CURSOR,
    MOUSE_CURSOR,
    SHOW_MOUSE,
    HIDE_MOUSE,
	WAITMOUSE,
	TESTMOUSE,
	CAPTURE_MOUSE,
	RELEASE_MOUSE,

	BUILDMENU,
	BUILD_SELECTIONS,
	CLOSE_POPDOWN,

	LB_SELECTION,		/* sent to parent when user selects		 	*/
	LB_CHOOSE,			/* sent to parent when user chooses	 	 	*/
	LB_CURRENTSELECTION,/* returns the current selection 			*/
	LB_GETTEXT,			/* returns the text of a selection 			*/
	LB_SETSELECTION,	/* sets the listbox selection				*/

	EB_GETTEXT,
	EB_PUTTEXT,

	INITIATE_DIALOG,
	ENTERFOCUS,
	LEAVEFOCUS,
	ENDDIALOG,

    KEYBOARD,
	CAPTURE_KEYBOARD,
	RELEASE_KEYBOARD,
    KEYBOARD_CURSOR,
    CURRENT_KEYBOARD_CURSOR,
	HIDE_CURSOR,
	SHOW_CURSOR,
	SAVE_CURSOR,
	RESTORE_CURSOR,
	SHIFT_CHANGED,

	COMMAND
} MESSAGE;

/* --------- message prototypes ----------- */
void init_messages(void);
void PostMessage(WINDOW, MESSAGE, PARAM, PARAM);
int SendMessage(WINDOW, MESSAGE, PARAM, PARAM);
int dispatch_message(void);
int TestCriticalError(void);

#endif
