/* ------------- applicat.c ------------- */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "dflat.h"

static WINDOW mnu = NULLWND;
extern DBOX TabStops;

static void ChooseWindow(WINDOW, int);
static void SelectColors(void);
static void CloseAll(WINDOW);

int ApplicationProc(WINDOW wnd, MESSAGE msg, PARAM p1, PARAM p2)
{
	int rtn;
	static int tabstop;

	switch (msg)	{
		case CREATE_WINDOW:
			LoadConfig();
			SelectColors();
			rtn = BaseWndProc(APPLICATION, wnd, msg, p1, p2);
			if (wnd->extension != NULL)	{
				mnu = CreateWindow(MENUBAR,
									NULL,
									GetLeft(wnd)+1,
									GetTop(wnd)+1,
									1,
									WindowWidth(wnd)-2,
									NULL,
									wnd,
									NULL,
									0);
				SendMessage(mnu, BUILDMENU, (PARAM) wnd->extension, 0);
				SelectColors();
				AddAttribute(wnd, HASMENUBAR);
				SendMessage(mnu, SETFOCUS, TRUE, TRUE);
				if (cfg.InsertMode)
					SetCommandToggle(ID_INSERT);
				if (cfg.WordWrap)
					SetCommandToggle(ID_WRAP);
			}
			PostMessage(wnd, CAPTURE_CLOCK, 0, 0);
			return rtn;
		case SIZE:
			BaseWndProc(APPLICATION, wnd, msg, p1, p2);
			SendMessage(mnu, HIDE_WINDOW, 0, 0);
			SendMessage(mnu, SIZE, GetRight(wnd)-1, GetTop(wnd)+1);
			SendMessage(mnu, BUILDMENU, (PARAM) wnd->extension, 0);
			SendMessage(mnu, SHOW_WINDOW, 0, 0);
			return TRUE;
		case KEYBOARD:
			if (WindowSizing || WindowMoving)
				break;
			PostMessage(mnu, msg, p1, p2);
			return TRUE;
		case SETFOCUS:
			return FALSE;
		case PAINT:
			if (isVisible(wnd))
				ClearWindow(wnd, (RECT *)p1, APPLCHAR);
			return TRUE;
		case COMMAND:
			switch ((int)p1)	{
				case ID_EXIT:
				case ID_SYSCLOSE:
					PostMessage(wnd, CLOSE_WINDOW, 0, 0);
					break;
				case ID_COLOR:
					if (!cfg.mono)
						break;
					cfg.mono = FALSE;
					SelectColors();
					SendMessage(mnu, BUILDMENU, (PARAM) wnd->extension, 0);
					SendMessage(wnd, SHOW_WINDOW, 0, 0);
					break;
				case ID_MONO:
					if (cfg.mono)
						break;
					cfg.mono = TRUE;
					SelectColors();
					SendMessage(mnu, BUILDMENU, (PARAM) wnd->extension, 0);
					SendMessage(wnd, SHOW_WINDOW, 0, 0);
					break;
				case ID_TABS:
					tabstop = cfg.Tabs;
					switch (tabstop)	{
						case 2:
							PushRadioButton(&TabStops, ID_TAB2);
							break;
						case 4:
							PushRadioButton(&TabStops, ID_TAB4);
							break;
						case 6:
							PushRadioButton(&TabStops, ID_TAB6);
							break;
						case 8:
							PushRadioButton(&TabStops, ID_TAB8);
							break;
						default:
							break;
					}
					if (DialogBox(&TabStops, NULL))
						cfg.Tabs = tabstop;
					break;
				case ID_TAB2:
					tabstop = 2;
					break;
				case ID_TAB4:
					tabstop = 4;
					break;
				case ID_TAB6:
					tabstop = 6;
					break;
				case ID_TAB8:
					tabstop = 8;
					break;
				case ID_SAVEOPTIONS:
					SaveConfig();
				case ID_WINDOW:
					ChooseWindow(wnd, (int)p2);
					break;
				case ID_CLOSEALL:
					CloseAll(wnd);
					break;
				case ID_SYSRESTORE:
				case ID_SYSMOVE:
				case ID_SYSSIZE:
				case ID_SYSMINIMIZE:
				case ID_SYSMAXIMIZE:
					return BaseWndProc(APPLICATION, wnd, msg, p1, p2);
				default:
					if (inFocus != mnu)
						PostMessage(inFocus, msg, p1, p2);
					break;
			}
			return TRUE;
		case LEFT_BUTTON:	{
			WINDOW wnd1 = wnd;
			int mx, my;
			if (WindowSizing || WindowMoving)
				return FALSE;
			if (SendMessage(wnd, INSIDE_WINDOW, p1, p2))	{
				if (inFocus && inFocus != mnu)
					if (SendMessage(inFocus, INSIDE_WINDOW, p1, p2))
						wnd1 = inFocus;
				mx = (int) p1 - GetLeft(wnd1);
				my = (int) p2 - GetTop(wnd1);
				if (HitControlBox(wnd1, mx, my))	{
					BuildSystemMenu(wnd1);
					return TRUE;
				}
			}
			break;
		}
		case CLOCKTICK:	{
			WINDOW wnd1 = Focus.LastWindow;
			int x = GetLeft(wnd)+WindowWidth(wnd)-9;
			while (wnd1 != NULLWND && wnd1 != wnd)	{
				if (SendMessage(wnd1, INSIDE_WINDOW, x, GetTop(wnd)))
					return TRUE;
				if (SendMessage(wnd1, INSIDE_WINDOW, x+5, GetTop(wnd)))
					return TRUE;
				wnd1 = PrevWindow(wnd1);
			}
			foreground = cfg.clr.TitleFG;
			background = cfg.clr.TitleBG;
			wputs(wnd, (char *)p1, WindowWidth(wnd)-9, 0);
			return TRUE;
		}
		case CLOSE_WINDOW:
			SendMessage(NULLWND, RELEASE_CLOCK, 0, 0);
			PostMessage(NULLWND, STOP, 0, 0);
			break;
		default:
			break;
	}
	return BaseWndProc(APPLICATION, wnd, msg, p1, p2);
}

void PrepEditMenu(void *wnd, struct Menu *mnu)
{
	struct PopDown *pd = mnu->Selections;
	while (pd->SelectionTitle != NULL)	{
		if (*pd->SelectionTitle != LINE)	{
			switch (pd->ActionId)	{
				case ID_CUT:
				case ID_COPY:
				case ID_CLEAR:
				case ID_DELETETEXT:
					if (GetClass(inFocus) == EDITBOX &&
						isMultiLine(inFocus) &&
							BlockMarked(inFocus))
						pd->Attrib &= ~INACTIVE;
					else
						pd->Attrib |= INACTIVE;
					break;
				case ID_PARAGRAPH:
					if (GetClass(inFocus) == EDITBOX &&
							isMultiLine(inFocus))
						pd->Attrib &= ~INACTIVE;
					else
						pd->Attrib |= INACTIVE;
					break;
				case ID_PASTE:
					if (GetClass(inFocus) == EDITBOX &&
							isMultiLine(inFocus) &&
								!TestAttribute(inFocus, READONLY) &&
									Clipboard != NULL)
						pd->Attrib &= ~INACTIVE;
					else
						pd->Attrib |= INACTIVE;
					break;
				case ID_UNDO:
					if (GetClass(inFocus) == EDITBOX &&
							inFocus->DeletedText != NULL)
						pd->Attrib &= ~INACTIVE;
					else
						pd->Attrib |= INACTIVE;
					break;
				default:
					break;
			}
		}
		pd++;
	}
}

void PrepOptionsMenu(void *wnd, struct Menu *mnu)
{
	struct PopDown *pd = FindCmd(ID_TABS);
	sprintf(pd->SelectionTitle+7, "%d", cfg.Tabs);
}

static char *Menus[9] = {
	"~1.                      ",
	"~2.                      ",
	"~3.                      ",
	"~4.                      ",
	"~5.                      ",
	"~6.                      ",
	"~7.                      ",
	"~8.                      ",
	"~9.                      "
};

void PrepWindowMenu(void *wnd, struct Menu *mnu)
{
	struct PopDown *pd = mnu->Selections;
	struct PopDown *ca = mnu->Selections + 12;
	int MenuNo = 0;
	WINDOW wnd1 = Built.FirstWindow;
	mnu->Selection = 0;
	while (wnd1 != NULLWND && MenuNo < 9)	{
		if (GetClass(wnd1) != MENUBAR && GetParent(wnd1) == wnd)	{
			strncpy(Menus[MenuNo]+4, GetTitle(wnd1), 20);
			pd->SelectionTitle = Menus[MenuNo];
			if (wnd1 == inFocus)	{
				pd->Attrib |= CHECKED;
				mnu->Selection = MenuNo;
			}
			else
				pd->Attrib &= ~CHECKED;
			pd++;
			MenuNo++;
		}
		wnd1 = NextWindowBuilt(wnd1);
	}
	if (MenuNo)	{
		*pd++ = *ca++;
		*pd++ = *ca;
	}
	pd->SelectionTitle = NULL;
}

static void ChooseWindow(WINDOW wnd, int WindowNo)
{
	WINDOW wnd1 = GetFirstChild(wnd);
	while (wnd1 != NULLWND)	{
		if (GetClass(wnd1) != MENUBAR)
			if (WindowNo-- == 0)
				break;
		wnd1 = GetNextChild(wnd);
	}
	if (inFocus->condition == ISMAXIMIZED)
		SendMessage(inFocus, RESTORE, 0, 0);
	SendMessage(wnd1, SETFOCUS, TRUE, 0);
	if (wnd1->condition == ISMINIMIZED)
		SendMessage(wnd1, RESTORE, 0, 0);
}

static void SelectColors(void)
{
	if (ismono() || video_mode == 2)	{
		cfg.mono = TRUE;
		DeactivateCommand(ID_COLOR);
	}
	if (cfg.mono)	{
		cfg.clr = bw;
		SetCommandToggle(ID_MONO);
		ClearCommandToggle(ID_COLOR);
	}
	else	{
		cfg.clr = color;
		SetCommandToggle(ID_COLOR);
		ClearCommandToggle(ID_MONO);
	}
}

static void CloseAll(WINDOW wnd)
{
	int closing = TRUE;
	while (closing)	{
		WINDOW wnd1 = GetLastChild(wnd);
		closing = FALSE;
		while (GetClass(wnd1) != MENUBAR)	{
			if (wnd1 == inFocus)	{
				SendMessage(wnd1, CLOSE_WINDOW, 0, 0);
				closing = TRUE;
				break;
			}
			wnd1 = GetPrevChild(wnd);
		}
	}
}
