
/********* Generated by DspHq from BittWare Research Systems **********/

/********** To create executable: d3make -Q -m6 <filename>.s **********/

/******************* FILTER PARAMETERS *******************/
/*                                                       */
/*                     Type = Lo Pass                    */
/*                   Length = 35                         */
/*                   Window = Blackman                   */
/*              Corner (Hz) = 5000.0000                  */
/*              Sample Rate = 50000.0000                 */
/*                                                       */
/*********************************************************/

.global fircoef, isamp, adc1, static1, numtaps
.global begin, input, _fir, output

#include <dspregs.h>
#define FIRLENGTH 35

begin:
     r5 = 0x0000                     /* SETUP CONTROL REGISTERS */
     pcw = r5
     ioc=0x30CC0                    /* SET-UP A/D-D/A INTERFACE */
     r5e = isamp         /* r5 POINTS TO INPUT (FLOATING POINT) */
     r8e=adc1                    /* ADDRESS TO STORE INPUT DATA */
     r7e=numtaps                       /* NUMBER OF FILTER TAPS */
     r1 = *r7                  /* r1 = LENGTH OF THE FIR FILTER */
     r3e = static1             /* r3 POINTS TO STATIC VARIABLES */
     r1 = r1 - 3

input:
     if (ibe) goto input               /* WAIT FOR INPUT SAMPLE */
     r2e = fircoef                 /* r2 POINTS TO COEFFICIENTS */
     *r8=ibufe                              /* STORE INPUT DATA */

_fir:
     r4e = static1             /* r4 POINTS TO STATIC VARIABLES */
     *r5=a0=float(*r8)         /* CONVERT INPUT SAMPLE TO FLOAT */
     a1 = *r4++ * *r2++                     /* CALCULATE FILTER */
     do 0, r1
       a1 = a1 + (*r3++ = *r4++) * *r2++    
     a0 = a1 + (*r3 = *r5) * *r2
     *r8=a1=int(a0)                      /* STORE FILTER OUTPUT */

output:
     if (obf) goto output              /* WAIT TO OUTPUT RESULT */
     r3e = static1              /* r3 POINTS TO STATIC VARIABLE */
     goto input                               /* REPEAT FOREVER */
     obufe = *r8                               /* OUTPUT SAMPLE */

adc1:    int 0                             /* TEMP DATA STORAGE */
adc2:    int 0                             /* TEMP DATA STORAGE */
numtaps: int FIRLENGTH
.align 4                                    /* ALIGN FOR FLOATS */
isamp: float 0.0

                       /* FILTER COEFFICIENTS, IN REVERSE ORDER */
fircoef:
float  2.41339171584499e-0022
float -3.63815116361828e-0005
float -3.54841321262760e-0019
float  4.08280941759535e-0004
float  1.34778056162632e-0003
float  2.44176628595806e-0003
float  2.53296567345739e-0003
float  5.92525344561383e-0018
float -6.13739120789658e-0003
float -1.46633790561929e-0002
float -2.11398625436992e-0002
float -1.85432189080892e-0002
float -1.92621160758614e-0017
float  3.72739122727084e-0002
float  8.88784651858499e-0002
float  1.43094263118753e-0001
float  1.84494264387537e-0001
float  2.00000000000000e-0001
float  1.84494264387537e-0001
float  1.43094263118753e-0001
float  8.88784651858499e-0002
float  3.72739122727084e-0002
float -1.92621160758614e-0017
float -1.85432189080892e-0002
float -2.11398625436992e-0002
float -1.46633790561929e-0002
float -6.13739120789658e-0003
float  5.92525344561383e-0018
float  2.53296567345739e-0003
float  2.44176628595806e-0003
float  1.34778056162632e-0003
float  4.08280941759535e-0004
float -3.54841321262760e-0019
float -3.63815116361828e-0005
float  2.41339171584499e-0022

.rsect ".ram1"   /* LESS WAITS IF STATICS IN DIFFERENT RAM BANK */
static1:
     (FIRLENGTH-1)*float 0.0                /* STATIC VARIABLES */

