/*   MOUSE.H  --     Header file for cartoon mouse template
	 This (and the other header files like it) can be used to define
     the initial fractal template for the SIERP.C and FRACDRAW.C programs
     This template was made by tracing the rough outline of an image and
     tiling with copies of itself.
*/
#define NPOINTS 14    /* Number of points on the "parent" polygon */
#define NTRANS  18    /* Number of transformed "children" */
#define NLEVELS 2    /* Number of levels to draw */
#define COUNT 50000  /* Number of dots to paint */
#define CENTERX 320  /* Center of the screen */
#define CENTERY 240
#define SEEDX 131,140,97,6,-56,-97,-146,-148,-121,-101,-47,-3,32,29
#define SEEDY 5,55,99,133,121,70,21,-17,-17,-31,-20,-78,-93,-71

/* The tranformations which define the "children" */
#define MOVEX -89,36,-60,-4,4,61,-71,1,81,-49,-133,-130,-8,-3,-36,-24,13,15
#define MOVEY -3,13,25,-35,-63,-43,101,116,56,87,-50,-24,104,-1,-20,-27,-16,76
#define SIZEX .31,.4,.62,.07,.19,.32,.19,.4,.55,.31,.12,.17,.21,.06,.06,\
	      .08,.11,.42
#define SIZEY .18,.35,.44,.27,.27,.48,.06,.13,.33,.20,.04,.23,.12,.16,.14,\
	      .2,.23,.2
#define SPINX 3.23,6.4,.32,2.72,5.84,4.61,.75,6.25,5.34,.29,3.16,5.9,3.04,\
              4.15,4.32,.91,1.1,2.55
#define SPINY 3.6,6.5,.77,.37,3.49,4.28,.75,6.25,5.27,.1,2.85,2.65,2.53,\
              3.56,3.73,3.73,3.53,5.89

/* The following color definitions are ignored by the SIERP program
   and used only by FRACDRAW.
   PALETTE defines the 16-color VGA palette
   COLOR intializes a two-dimensional array with color values:
   each column in the array definition below corresponds to one level
   of detail, and each row corresponds to a "part", or transformation.
   Note that the array only needs to be 6 by 3 for the template defined
   above, but more rows are included in case the user inserts additional
   "parts".
*/
#define PALETTE {_BLACK, _RED, _GREEN, _CYAN, \
		 _BLUE, _MAGENTA, _BROWN, _WHITE, \
		 _GRAY, _LIGHTBLUE, _LIGHTGREEN, _LIGHTCYAN, \
		 _LIGHTRED, _LIGHTMAGENTA, _LIGHTYELLOW, _BRIGHTWHITE}

#define COLOR {{6,6},\
               {6,6},\
               {6,6},\
               {6,6},\
               {6,6},\
               {6,6},\
               {1,1},\
               {6,6}, {6,6}, {1,1}, {7,7}, {8,8}, {12,12},\
               {9,9}, {9,9}, {15,15}, {15,15}, {1,1}}
