LM10AL1RHA
VA$fi     DAmm/dd/yy     TM     Galley PN of FP

PT1
Program popdemo;

  (* Demonstrates use of POPUPS unit *)

USES crt, popups;

(* Define menubar *)

CONST MainMenu : menuRec = (
            row : 1; interval : 26; fore : White; back : Green);
      MainMenuText : string [14] = 'Demos~Run~Thru';

(* Define pull-down menus *)

      DemoMenu : popRec = (
            left : 1; top : 2; right : 14; bottom : 6; style : 1;
            normal : LightGray; hilite : LightGray;
            normback : Blue; hiback : Magenta; border : Cyan);
      DemoMenuText : string [39] =
            'Show file~Walk popup~Graphics';

      RunMenu : popRec = (
            left : 27; top : 2; right : 39; bottom : 5; style : 1;
            normal : LightGray; hilite : LightGray;
            normback : Blue; hiback : Magenta; border : Cyan);
      RunMenuText : string [19] = 'All demos~Exit menu';

      QuitMenu : popRec = (
            left : 53; top : 2; right : 68; bottom : 5; style : 1;
            normal : LightGray; hilite : LightGray;
            normback : Blue; hiback : Magenta; border : Cyan);
      QuitMenuText : string [22] = 'Quit program~Exit menu';

(* Define windows for demos *)
      FileWindow : popRec = (
            left : 2; top : 4; right : 75; bottom : 25; style : 2;
            normal : Brown; hilite : 0;
            normback : Black; hiback : 0; border : Yellow);

      Walker : popRec = (
            left : 66; top : 1; right : 80; bottom : 6; style : 2;
            normal : Red; hilite : 0;
            normback : LightGray; hiback : 0; border : Red);
      WalkerText : string [46] =
            'This pop-up~moves down~by changing~top, bottom';

      SalesChart : popRec = (
            left : 51; top : 9; right : 72; bottom : 22; style : 2;
            normal : Cyan; hilite : 0;
            normback : LightGray; hiback : 0; border : Red);

(* ------------------------ DEMO ROUTINES ------------------------- *)

PROCEDURE ShowFile;

      { List the source for this program in FileWindow }
      { Leave window open afterwards }

VAR   ThisFile : TEXT;
      Line     : string [80];

BEGIN
  popShow (FileWindow);
  Assign (ThisFile, 'POPDEMO.PAS');
  Reset (ThisFile);
  WHILE NOT eof (ThisFile) DO BEGIN
    Readln (ThisFile, line);
    Writeln (Line);
  END;
  Close (ThisFile);
END;

(* -------------------------- *)

PROCEDURE WalkPopup;

      { Walk a pop-up down the right side of the display }
      { Moves by successively incrementing top and bottom }

VAR   TopRow : INTEGER;

BEGIN
  popShow (Walker);
  FOR TopRow := 2 to 19 DO BEGIN
    popErase (Walker);
    Walker.top    := TopRow;
    Walker.bottom := TopRow + 5;
    popShow (Walker);
  END;
END;

(* -------------------------- *)

PROCEDURE TextChart;

      { Simulate a sales results chart using simple text graphics }

CONST block = #219;

  PROCEDURE DrawBar (column, height : INTEGER);
  VAR   y : INTEGER;
  BEGIN
    FOR y := 10 DOWNTO (10 - height) DO BEGIN
      Gotoxy (column, y);
      Write (block);
    END;
  END;

BEGIN
  popShow (SalesChart);
  popCenter (SalesChart, 1, 'Sales Results');
  TextColor (Green);
  Gotoxy (2, 12); Write ('Projected');
  DrawBar ( 2, 6);
  DrawBar ( 7, 7);
  DrawBar (12, 5);
  DrawBar (17, 6);
  TextColor (Red);
  Gotoxy (14, 12); Write ('Actual');
  DrawBar ( 4, 5);
  DrawBar ( 9, 6);
  DrawBar (14, 7);
  DrawBar (19, 8);
END;

(* ----------------------- CONTROL ROUTINES ----------------------- *)

FUNCTION DemoResult : CHAR;

    { Pull down and act on Demos Menu }

VAR   key, wait : CHAR;
      pick      : INTEGER;
      exiting   : BOOLEAN;

BEGIN
  pick := 1;
  exiting := FALSE;
  popShow (DemoMenu);
  popHilite (DemoMenu, 1);
  REPEAT

    { Get menu selection }
    key := Keystroke;
    popNormal (DemoMenu, pick);                  { remove hilite bar }
    CASE key OF
      'S'        : pick := 1;
      'W'        : pick := 2;
      'G'        : pick := 3;
      DownCursor : BEGIN
                     Inc (pick);
                     IF pick > 3 THEN pick := 1;   { Wrap to top row }
                   END;
      UpCursor   : BEGIN
                     Dec (pick);
                     IF pick = 0 THEN pick := 3;    { Wrap to bottom }
                   END;
      LeftCursor : exiting := TRUE;
      RiteCursor : exiting := TRUE;
      Enter      : CASE pick OF        { Selection by cursor + enter }
                     1: key := 'S';
                     2: key := 'W';
                     3: key := 'G';
                   END;
      ELSE exiting := TRUE;                    { Pass back keystroke }
    END;
    popHilite (DemoMenu, pick);                    { hilite new pick }

    { Do demo if selected }
    IF key IN ['S', 'W', 'G'] THEN BEGIN
      CASE key OF
        'S': BEGIN
               ShowFile;
               wait := ReadKey;
               popErase (FileWindow);
             END;
        'W': BEGIN
               WalkPopup;
               wait := ReadKey;
               popErase (Walker);
             END;
        'G': BEGIN
               TextChart;
               wait := ReadKey;
               popErase (SalesChart);
             END;
      END;
    END;
  UNTIL exiting;
  popErase (DemoMenu);
  DemoResult := key;
END;

(* -------------------------- *)

FUNCTION RunResult : CHAR;

      { Pull down and act on Run Menu }

VAR   key, wait : CHAR;
      pick      : INTEGER;
      exiting   : BOOLEAN;

BEGIN
  pick := 1;
  exiting := FALSE;
  popShow (RunMenu);
  popHilite (RunMenu, 1);
  REPEAT
    key := Keystroke;                                { remove hilite }
    popNormal (RunMenu, pick);
    CASE key OF
      DownCursor : IF pick = 1 THEN pick := 2 ELSE pick := 1;
      UpCursor   : IF pick = 1 THEN pick := 2 ELSE pick := 1;
      'E'        : exiting := TRUE;
      LeftCursor : exiting := TRUE;
      RiteCursor : exiting := TRUE;
      Enter      : IF pick = 1 THEN key := 'A'
                   ELSE BEGIN
                     exiting := TRUE;
                     key := 'E';
                   END;
      ELSE exiting := TRUE;                    { Pass back keystroke }
    END;
    popHilite (RunMenu, pick);                     { hilite new pick }

    IF key = 'A' THEN BEGIN                    { Do all demos on 'A' }
      ShowFile;
      TextChart;
      WalkPopup;
      Wait := ReadKey;                           { Wait for keypress }
      popErase (Walker);                       { Retreat thru popups }
      popErase (SalesChart);
      popErase (FileWindow);
    END;

  UNTIL exiting;
  popErase (RunMenu);
  RunResult := key;
END;

(* -------------------------- *)

FUNCTION QuitResult : CHAR;

      { Pull down and act on Quit Menu }

VAR   key     : CHAR;
      pick    : INTEGER;
      exiting : BOOLEAN;

BEGIN
  pick := 1;
  exiting := FALSE;
  popShow (QuitMenu);
  popHilite (QuitMenu, 1);
  REPEAT
    key := Keystroke;
    popNormal (QuitMenu, pick);
    CASE key OF
      DownCursor : IF pick = 1 THEN pick := 2 ELSE pick := 1;
      UpCursor   : IF pick = 1 THEN pick := 2 ELSE pick := 1;
      'Q'        : exiting := TRUE;
      'E'        : exiting := TRUE;
      LeftCursor : exiting := TRUE;
      RiteCursor : exiting := TRUE;
      Enter      : BEGIN
                     IF pick = 1 THEN key := 'Q' ELSE key := 'E';
                     exiting := TRUE;
                   END;
      ELSE exiting := TRUE;                    { Pass back keystroke }
    END;
    popHilite (QuitMenu, pick);
  UNTIL exiting;
  popErase (QuitMenu);
  QuitResult := key;
END;

(* -------------------------- *)

PROCEDURE DoMainMenu;

      { Manages pull-down menu selection }

TYPE MenuUp = (Demos, Run, Thru);

VAR  quitting : BOOLEAN;
     MMsel    : MenuUp;
     UserKey  : CHAR;

BEGIN
  Quitting := FALSE;
  MMsel    := Demos;
  REPEAT
    UserKey := chr (0);

    { Act on selected pulldown }
    CASE MMsel OF
      Demos : UserKey := DemoResult;
      Run   : UserKey := RunResult;
      Thru  : UserKey := QuitResult;
    END;

    { Act on returned keystroke }
    CASE UserKey OF
      'E'       : MMsel := Demos;
      'D'       : MMsel := Demos;
      'R'       : MMsel := Run;
      'T'       : MMsel := Thru;
      'Q'       : Quitting := TRUE;
      LeftCursor: IF MMsel = Demos THEN
                    MMsel := Thru
                  ELSE
                    Dec (MMsel);
      RiteCursor: IF MMsel = Thru THEN
                    MMsel := Demos
                  ELSE
                    Inc (MMsel);
      END;
  UNTIL quitting;
END;

(* ---------------------------------------------------------------- *)

BEGIN  (*** Main program ***)

  { Initialize object text pointers }
  MainMenu.choice   := @MainMenuText;
  DemoMenu.contents := @DemoMenuText;
  RunMenu.contents  := @RunMenuText;
  QuitMenu.contents := @QuitMenuText;
  Walker.contents   := @WalkerText;

  { Set up screen and go }
  ClrScr;
  Cursoff;
  showMenubar (MainMenu);
  DoMainMenu;

  { Make sure cursor is on before quitting }
  Curson;
  ClrScr;
END.
