	page	60, 132
	name	startup
	title	LOCATE Example ROM System Startup Code
	subttl	Turbo C 1.0 Version

;
;	ROM System Startup Code for Turbo C 1.0
;	Copyright (C) 1987 by Rick Naro.  All rights reserved.
;

;
;	Segment and group declarations
;

_text	segment byte	public	'CODE'
_text	ends
_etext	segment para	public	'CODEEND'
_etext	ends
_data	segment para	public	'DATA'
_data	ends
_bss	segment para	public	'BSS'
_bss	ends
_bssend	segment byte	public	'BSSEND'
_bssend	ends
_stack	segment	para	stack	'STACK'
_stack	ends

dgroup	group	_data, _bss, _bssend

assume	cs:_text, ds:dgroup, ss:_stack

;
;	This version of the startup code expects 32-bit code pointers.
;	(medium or large memory models)
;

extrn	_main : far   	; Change to near for small/compact memory model

_text	segment

public	start

start	proc	far

	cli	     			; Disable interrupts

;
;	Initialize the stack segment and pointer
;

	mov	ax, _stack  		; Get the stack segment value
	mov	ss, ax	  	  	; Put in SS
	mov	sp, offset tos		; Load the TOS in SP

;
;	Set up the segment registers for the initialization of DGROUP.
;	ES is initialized to DGROUP and DS is initialized to the copy of
;	DGROUP in ROM.
;

	mov	ax, dgroup  		; Get the segment for DGROUP
	mov	es, ax	    		; Install in ES

	mov	ax, _etext  		; Get the _etext segment
	inc	ax		    	; Adjust for the size of _etext
	mov	ds, ax		    	; Install in DS

;
;	Copy the copy of the initialized data segment _DATA from its
;	position in ROM (just after the CODE class) to the real _DATA
;	segment in RAM.  The size of the _DATA segment is computed by
;	subtracting the start of _DATA (the label idata) from the start
;	of the next segment (the label bdata).
;

	mov	si, offset DGROUP:idata	; Starting offset of _DATA
	mov	di, si			; Same offset, different segment
	mov	cx, offset DGROUP:bdata	; Get the end offset
	sub	cx, di		       	; Subtract the two for a length
	rep	movsb		       	; Copy initialized data

	push	es			; Get the value of DGROUP
	pop	ds			; Now it is in DS

;
;	C expects that the BSS segment is cleared when the program is
;	started.  Zero out the BSS segment within DGROUP by computing
;	the size using the label bdata and edata labels
;

	xor	al, al		       	; Use a zero fill pattern
	mov	di, offset DGROUP:bdata	; Get the starting offset
	mov	cx, offset DGROUP:edata	; Get the ending offset
	sub	cx, di		       	; Subtract the two for a length
	rep	stosb		       	; Zero out the BSS

;
;	Call main and hopefully never return ...
;

	sti				; Re-enable interrupts
	call	_main			; Call main()

;
;	Handle a return by restarting the entire process
;

	jmp	start			; Start all over

start	endp

_text	ends

	page
_etext	segment
public	tend
	db	16 dup (?)		; Force alignment of the label
					; tend with the next paragraph
tend	label	byte			; Mark the end of the segment
					; Do NOT change this segment
_etext	ends

_data	segment
public	idata
idata	label	byte			; Start of the _DATA segment
_data	ends

_bss	segment
public	bdata
bdata	label	byte			; Start of the _BSS (and the
					; end of the _DATA segment
_bss	ends

_bssend segment
public	edata
edata	label	byte			; Mark the end of the BSS
_bssend ends

_stack	segment
public	tos				; Make the TOS public
	dw	256 dup (?)    		; Declare the stack size
tos	label	byte			; Define the top of stack
_stack	ends

	end	start
