/*
	Copyright (C) 1987 Paradigm Systems Inc.  All rights reserved.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

#include "loc.h"
#include "externs.h"

char	*errstr = "Unable to locate global symbol \"%s\"\n" ;


void	read_symbol_table(seg_list)
SEG_DESCRIPTOR	*seg_list ;
{
	char	buf[128] ;
	int	count, found ;
	unsigned int	vseg, off;
	char	symbol[32], attrb[10] ;

	SEG_DESCRIPTOR	*p ;
	SYMBOL_LIST	*q ;

	/*
		This function reads the linker map file and extracts the
		symbol information.
	*/

	/* Seek to the beginning of the file */
	if (fseek(map_file, 0L, SEEK_SET) != 0)   {
		perror(__FILE__) ;
		exit(1) ;
	}

	/* Search thru the file for the symbol tables */
	while (1)   {
		if (fgets(buf, sizeof(buf), map_file) == NULL)
			return ;

		if (strstr(strupr(buf), "ADDRESS") != NULL)
			break ;
	}

	/* Read each of the symbol entries */
	while (1)   {
		count = fscanf(map_file, " %4x:%4x%5c %s", &vseg, &off, attrb, symbol);
		if (count != 4)
			break ;
		else    {
			p = seg_list ;
			found = FALSE ;
			while (p != NULL)   {
				if ((p->vseg != vseg) || (p->len == 0))   {
					p = p->next ;
					continue ;
				}

				q = (SYMBOL_LIST *) malloc(sizeof(*q)) ;
				strcpy(q->name, symbol) ;
				q->value = off ;
				q->type = 1 ;
				q->next = p->symbol_list ;
				p->symbol_list = q ;
				p->symbols++ ;
				found = TRUE ;
				break ;
			}

			if (found == FALSE)
				fprintf(stderr, errstr, symbol) ;
		}
	}

	return ;
}

