;*************************************************************************
; PLOTDOT.OBJ   Library module for Microsoft C  (small model programs)
;               Copyright (C) 1985 by Dan Rollins
;
; Mid-resolution graphics pixel-plot function.
; Uses look-up tables for fastest operation.
; Permission is granted to use this for any purpose whatsoever.
;
; synopsis:
;  plotdot(x,y,color)
;    int x;            horizontal (0-319) not value-checked
;    int y;            vertical (0-199) not value-checked
;    int color;        color for dot (0 to 3)


;------- preamble for placing data into Microsoft C 'S model' static data area
dgroup   group data
data     segment word public 'data'

;-------- lookup table for start of each graphics line
;-------- index is: (Y * 2)
row_tbl   label word
          addr = 0
          rept 100
           dw addr,addr+2000H    ;Y=0,1; 2,3; 4,5; etc
           addr = addr+80
          endm

;-------- lookup table for mid-res pixel positions in relevent byte
;-------- index is: (X mod 4)
mask_tbl  db 00111111b, 11001111b, 11110011b, 11111100b

;-------- lookup table for color, according to position in byte
;-------- index is (COLOR * 4) + (X mod 4)
color_tbl db 00000000b, 00000000b, 00000000b, 00000000b    ;color 0
          db 01000000b, 00010000b, 00000100b, 00000001b    ;color 1
          db 10000000b, 00100000b, 00001000b, 00000010b    ;color 2
          db 11000000b, 00110000b, 00001100b, 00000011b    ;color 3
data      ends

;------- preamble for placing code into Microsoft C 'S model' program area
pgroup   group prog
prog     segment byte public 'prog'
         assume cs:pgroup, ds:dgroup

public   plotdot
plotdot  proc    near            ;SMALL MODEL ONLY
         pop     si              ;fetch return addr /this technique is faster
         pop     bx              ;fetch X ordinate  /than stack-relative access
         pop     di              ;fetch Y ordinate
         pop     cx              ;fetch color

         mov     dx,es           ;save current ES
         mov     ax,0b800H
         mov     es,ax           ;get set to write to video buffer

         shl     di,1            ;index into row address lookup table

         mov     di,row_tbl[di]  ;DI points to start of selected row

         mov     ax,bx           ;copy the X ordinate
         shr     ax,1
         shr     ax,1            ;divided by 4 is byte offset from start of row

         add     di,ax           ;DI points to byte to modify
         mov     al,es:[di]      ;fetch current screen byte

         and     bx,3            ;get pixel-offset in byte (0,1,2, or 3)
         and     al,mask_tbl[bx] ;mask a "hole" into the current byte

;------- index into the color table
         and     cx,3             ;make sure it's a valid color
         shl     cx,1             ; COLOR * 2
         shl     cx,1             ; COLOR * 4
         add     bx,cx            ; index is (COLOR * 4) + (X mod 4)
         or      al,color_tbl[bx] ;fill the "hole" with selected color

         mov     es:[di],al       ;place modified byte back into screen
         mov     es,dx            ;restore caller's ES
         jmp     si               ;artificial (quick) NEAR return to caller
plotdot  endp
prog     ends
         end
