// == form.cpp === member functions for form class ==================
//                 Copyright 1991 Wes Peterson

#include "eb_edit.h"

scr_form::scr_form(int say_color, int get_color, int curr_color)
{
    say_attr = say_color;
    get_attr = get_color;
    curr_get_attr = curr_color;
}

void scr_form::say(char *t)
{ 
    text_item *ti = new text_item(track_row, track_col, t);
    text.add_node((ll_node *)ti);
    track_col = track_col + strlen(t);
}

void scr_form::get(char *var, char *pct, char *msk, char *flg)
{
    ded *di = new ded(track_row, track_col, var, pct, msk, flg);
	fields.add_node(di);
}

void scr_form::get(long *var, char *pct, char *msk, char *flg)
{
   	ded *di = new ded(track_row, track_col, var, pct, msk, flg);
	fields.add_node(di);
}

void scr_form::get(field& f)
{
	ded *di = new ded(track_row, track_col, &f, NULL, NULL, NULL);
	fields.add_node(di);
}

void scr_form::set_width(int w)
{
    ded *d = (ded *)fields.get_curr_node();
    d->set_width(w);
}

void scr_form::read()   
{
    textattr(say_attr);
    clrscr();
    display_says();
    display_gets();
    edit_gets();
}

void scr_form::display_says(void)
{
	text_item 	*ti = (text_item *)text.get_first_node();
    while(ti)	{
    	ti->display();
        ti = (text_item *)text.get_next_node();
        }
}

void scr_form::display_gets(void)
{
    ded *di = (ded *)fields.get_first_node();
    while(di)	{
    	di->display(get_attr);
        di = (ded *)fields.get_next_node();
        }
}

void scr_form::edit_gets(void)
{
    ded *di = (ded *)fields.get_first_node();

    int result;
    int go_on = 1;

    while(go_on)	{
    	result =di->edit(get_attr, curr_get_attr);
        switch(result)	{
        	case KPGUP:
                tbl->skip(UP);
                display_gets();
                break;
            case KPGDN:
                tbl->skip(DOWN);
                display_gets();
                break;
        	case FEDITADV:
            case FEDITLEAVE:
            case FEDITADVR:
            case FEDITADVD:
        		di = (ded *)fields.get_next_node();
                if(!di)
                    di = (ded *)fields.get_first_node();
                break;
            case FEDITADVL:
            case FEDITADVU:
            	di = (ded *)fields.get_prev_node();
                if(!di)
                    di = (ded *)fields.get_last_node();
                break;
            case FEDITDONE:
            	tbl->write();
                break;
            case FEDITCAN:
            	go_on = 0;
            }
        }
}

