// == table.cpp == Member functions for table objects ===============
//                 Copyright 1991 Wes Peterson

#include "eb_edit.h"

table::table(int db_handle, char *table_name)
{
	db = db_handle;
    name = strdup(table_name);
}

void table::open(void)
{
	id = DbOpenTable(db, name);
    DbGetIndexInfo(id, 0, &ndx_info);
}

int table::write(void)
{
    store();
    DbUpdate(id);
    return 0;
}

void table::fetch(void)
{
	field *fld = (field *)fields.get_first_node();
    while(fld)	{
    	fld->fetch();
        fld = (field *)fields.get_next_node();
        }
}

void table::store(void)
{
	field *fld = (field *)fields.get_first_node();
    while(fld)	{
    	fld->store();
        fld = (field *)fields.get_next_node();
        }
}

int table::top(void)
{
    DbFirst(id, ndx_info.ndxid);
    fetch();
	return(0);
}

int table::bottom(void)
{
	DbLast(id, ndx_info.ndxid);
    fetch();
	return 0;
}

int table::skip(int dir)
{
    int     status;
    long    hold_rec;

    if( (dir != 1) && (dir != -1) )
    	return(0);

    DbFetchNum(id, 0, hold_rec);    // save our place
    if(dir == 1)
        status = DbNext(id, ndx_info.ndxid);
    if(dir == -1)
        status = DbPrev(id, ndx_info.ndxid);

    // see if we're at eot/bot
    if( status == -1) {
        // go back to where we were
        DbGoto(id, hold_rec);
        }
    fetch();
    return status;
}

