// ==  ded.cpp === member functions for data-editor objects =========
//                 Copyright 1991 Wes Peterson

#include <dos.h>
#include "eb_edit.h"

// This constructor creates a ded object for character strings

ded::ded(int r, int c, char *dta, char *pct, char *msk, char *flg)
{
    data = (void *) dta;
    dtype = DTYPSTR;
    row = r;
    col = c;
    fld_width = 0;
    picture = pct;
    mask = msk;
    flags = flg;
}


// This constructor creates a ded object for long integers

ded::ded(int r, int c, long *dta, char *pct, char *msk, char *flg)
{
	data = (void *) dta;
    dtype = DTYPLNG;
    row = r;
    col = c;
    fld_width = 0;
    picture = pct;
    mask = msk;
    flags = flg;
}


// This constructor creates a ded object for field objects

ded::ded(int r, int c, field *f, char *pct, char *msk, char *flg)
{
    data = f->data;
    dtype = f->fldarg.fldtype;
    row = r;
    col = c;
    fld_width = 0;
    picture = f->fldarg.fldpict;
    mask = f->fldarg.fldmask;
    flags = f->fldarg.fldflag;
}

void ded::draw_field(int attr)
{
    textattr(attr);
    int room_left = ed->fldw;
	char *disp = &(ed->buffer[ed->begx]);
    gotoxy(col, row);
    while(*disp && room_left)	{
        putch((char) *disp++);
        room_left--;
        }
	gotoxy(col + ed->curpos, row);
}

void ded::display(int attr)
{
    textattr(attr);
    ed = FmtEditDataInit(dtype, picture, mask, flags, data);
	if(fld_width)
    	ed->fldw = fld_width;
    draw_field(attr);
    FmtEditClose(ed, data); 
}

int ded::edit(int g_attr, int cg_attr)
{
	int key, status, go_on = 1;

    ed = FmtEditDataInit(dtype, picture, mask, flags, data);
    if(fld_width)
        ed->fldw = fld_width;
    draw_field(cg_attr);

    while(go_on)    {
        key = GetKey();
			if( (key == KPGUP) || (key == KPGDN) )	{
            	status = key;
                goto DONE_EDITING;
                }
            	
        status = FmtEditKeystroke(ed, key);

        switch(status)	{
        	case 	FEDITBEEP:
        		beep(); break;
            case 	FEDITDONE:
			case	FEDITCAN:
        	case	FEDITADV:
            case	FEDITADVL:
            case	FEDITADVR:
            case	FEDITADVU:
            case	FEDITADVD:
            	go_on = 0; break;
            default:
            	break;
            }
		draw_field(cg_attr);
    	}
	DONE_EDITING:
    	draw_field(g_attr);
    	FmtEditClose(ed, data);
    	return(status);
}

int GetKey(void)
{
	int	key;

	key = getch();
	if(!key)
		key = getch() + 0x100;
	return(key);
}

void beep(void)
{
	sound(800);
    delay(200);
    nosound();
}
