//== eb_edit.h ===  Class definitions for Emerald Bay data editing objects
//                  Copyright 1991 Wes Peterson

#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <eb.h>
#include <ebbcd.h>
#include <keydef.h>
#include "llist.h"

#define UP    -1
#define DOWN   1

int     GetKey(void);
void    beep(void);

class	field;
class   ded;


//== table class === controls Emerald Bay data tables ===============

class table	{
    friend 		field;
    LinkedList  fields;             // list of field objects
    int 		db;
    char 		*name;
    int 		id;
	NDXARG 		ndx_info;
public:
	table(int db_handle, char *table_name);
    ~table(void) { free(name);}
    void open(void);
    void close(void) { DbCloseTable(id);}
    int write(void);
    int top(void);
    int bottom(void);
    int skip(int dir = 1);
    void fetch(void);
    void store(void);
};


// == field class === handles the fields in database records ========

class field : public ll_node {
    friend 	ded;
	table	*tbl;
    void	*data;
    FLDARG	fldarg;
public:
	field(table& tbl, char *field_name);
    ~field(void) { delete data;}
    void fetch(void) { DbFetch(tbl->id, fldarg.fldid, (char *) data); }
    void store(void) { DbStore(tbl->id, fldarg.fldid, (char *) data); }
};


// == text_item class === displays text on data entry screens =======

class text_item : ll_node {
    int row, col;           // text display position
    char *text;             // text that will be displayed
public:
    text_item(int r, int c, char *t)    {
        row = r;
        col = c;
        text = strdup(t);
        } ;
    ~text_item(void)    { free(text); };
    void display(void)  { gotoxy(col, row); fputs(text, stdout); };
    void draw_field(int attr);
};


//== scr_form class === Screen data entry form ======================

class scr_form  {
    table       *tbl;       // table object "registered" with this form
    LinkedList  text;       // where we store text_item objects
    LinkedList  fields;     //   "   "    "   ded (data-editor) objects
    int         track_row;  // screen row to use for next ded or text_item
    int         track_col;  // screen column
    int         say_attr;   // color to use for text_item display
    int         get_attr;   // color of fields (deds)
    int         curr_get_attr;  // color of highlighted (current) field
public:
    scr_form(int say_color, int get_color, int curr_color);
    void register_table(table *t) {tbl = t;}
    void at(int row, int col) {track_row = row; track_col = col;};
    void say(char *t);
    void get(char *var, char *pct, char *msk, char *flg);
    void get(long *var, char *pct, char *msk, char *flg);
    void get(field& f);
    void set_width(int w);
    void display_says(void);
    void display_gets(void);
    void edit_gets(void);
    void read(void);
};


// == ded class === a ded is a field (or variable) data-editor ======
 
class ded : public ll_node   {
    int         row;
    int         col;
    int         fld_width;
    EDITOBJECT  *ed;
    int         dtype;
    void        *data;
    char        *picture;
    char        *mask;
    char        *flags;
public:
    ded(int r, int c, char *dta, char *pct, char *msk, char *flg);
    ded(int r, int c, long *dta, char *pct, char *msk, char *flg);
    ded(int r, int c, field *f,  char *pct, char *msk, char *flg);

    void    display(int attr);
    void    draw_field(int attr);
    int     edit(int g_attr, int cg_attr);
    void    set_width(int w) {fld_width = w;};
} ;

