/*****************************************************************
*  FindIDs.C
*  written by Kathy Cea, Platinum Software Int'l
*
*  Finds and lists all users who have an application-specific
*  id (any property ending in "ID") stored in the bindery
*
*  Calling Syntax:
*       FindIDs
*
*   Compiled in Turbo C 2.0 with NetWare C function calls
*****************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <nit.h>
#include <niterror.h>

long objectId;
BYTE propertyValue[128];
BYTE moreSegs = 255,
     propertyFlags;
int segNum = 1;
BYTE temp[3];
BYTE holdobjId[9];
char *endptr;
WORD objectType;
char objectName[48];
char propertyName[16];
char applName[14];
long seqNumber;
BYTE propertyFlags,
     propertySecurity,
     propertyHasValue,
     moreProperties;
int retcode;
int i,j;
int foundone = 0;

main()
{
    printf("\tUser\t\t\tApplication\n");
    printf("\t-----------------------------------------\n");

/* Get all users of group EVERYONE
   Object ID of users are passed back in the propertyValue field
   Up to 32 Object Ids can be returned on each pass.  Continue
   calling ReadPropertyValue until moreSegs is No (0) */

    while (moreSegs) {
        retcode = ReadPropertyValue("EVERYONE", OT_USER_GROUP,
                            "GROUP_MEMBERS", segNum,
                            propertyValue, &moreSegs, &propertyFlags);
        segNum++; /* increment the segment number to read next */

    /* parse the propertyValue for 4-byte Object IDs,
       then convert each ID to a long integer */
        i = 0;
        temp[2] = '\0';
        holdobjId[0] = '\0';
        while (i < 128) {
            for (j=0; j < 4; j++) {
                /* Build a hex string for each Object ID */
                sprintf(temp, "%02x", propertyValue[i]);
                temp[2] = '\0';
                strcat(holdobjId, temp);
                i++;
            } /* for (j=0; j < 4; j++) */

            objectId = strtoul(holdobjId, &endptr, 16);

            /* Pass user's Object ID and receive User Name */
            retcode = GetBinderyObjectName(objectId, objectName, &objectType);
            if (retcode == SUCCESSFUL)  {
            /* Start scanning for application-id properties
               (anything ending in "ID") */
                moreProperties = 255;
                seqNumber = -1;
                while ((moreProperties) && (retcode == SUCCESSFUL)){
                    retcode = ScanProperty(objectName,OT_USER,"*ID",&seqNumber,
                               propertyName,&propertyFlags,&propertySecurity,
                               &propertyHasValue,&moreProperties);
                /* if the property is found, list user's name and appl name */
                    if (retcode == SUCCESSFUL) {
                        /* strip the "ID" from the application name before printing */
                        strncpy(applName,propertyName,strlen(propertyName) - 2);
                        applName[strlen(propertyName) - 2] = '\0';
                        printf("\t%-20s\t%-16s\n",objectName,applName);
                        foundone = 1;
                    }
                }/* while ((moreProperties)&& */
            } /* if (retcode == SUCCESSFUL) */
            holdobjId[0] = '\0';
        }  /* while (i < 128) */
    } /* while (moreSegs) */
    if (!foundone)
        printf("\t** No application IDs found in the bindery **\n");
} /* main() */

