**************************************************************************
*   Name........: PASSCHEK.PRG                                           *
*   Purpose.....: Check if password is correct. If not does a CANCEL     *
*   Date........: 11/03/92	                                         *
*   By..........: Frederico Terenas    E-mail: cs_a264@Kingston.ac.uk    *
**************************************************************************

* Constraints:
* Your password name should not end with spaces.

PROCEDURE PASSCHEK                   && Check password

PRIVATE ALL
RESTORE FROM CHAVE ADDITIVE          && loads password file into mem

ENC_FACTOR = 1200                    && factor

IF PASSWORD[1] <> 0                  && is password set ?

    SET COLOR OF FIELDS TO R/R       && turn fg colour equal to bg color

    @  13,54 TO 15,77
    @ 14,56 SAY "Password:"
    Pass = SPACE(10)
    @ 14,66 GET Pass PICTURE "XXXXXXXXXX"
    READ

    SET COLOR OF FIELDS TO W+/R           && restore colors

    Len2 = LEN(RTRIM(Pass))

    IF Length1 <> Len2                      
        OK = .F.
    ELSE
        Counter = 1
        DO WHILE (Counter <= Length1) .AND. OK
           IF ASC(SUBSTR(Pass,Counter,1)) + ENC_FACTOR <> (Password[Counter])
               OK = .F.
           ELSE
               Counter = Counter + 1
           ENDIF
        ENDDO
    ENDIF

    SET CURSOR OFF
    IF OK
        @ 20,30 TO 22,50 COLOR G/W+
        @ 21,32 SAY "Authorised Access"
        A = INKEY(2)
        RELEASE ALL                        && restore memory
    ELSE
        @ 20,32 TO 22,48 COLOR GR+/R
        @ 21,34 SAY "Acess Denied"
        Espere = INKEY(2)
        SET CURSOR ON
        CANCEL                            
    ENDIF

    SET CURSOR ON

ENDIF

RETURN                  && from PASSCHEK
