#define c64 1

opdclass  o_immed  =  { 8,  NO,  NO,  NO,  0};
opdclass  o_zpage  =  { 8,  NO,  NO,  NO,  0};
opdclass  o_mem    =  { 16, NO, YES,  NO,  0};
opdclass  o_rel    =  { 8, YES,  NO, YES,  0};

insclass  i_nomem  =  { 1, 0,  &o_none, &o_none, 0, 0};
insclass  i_branch =  { 2, 1,   &o_rel, &o_none, 8, 0};
insclass  i_immed  =  { 2, 1, &o_immed, &o_none, 8, 0};
insclass  i_zpage  =  { 2, 1, &o_zpage, &o_none, 8, 0};
insclass  i_abs    =  { 3, 1,   &o_mem, &o_none, 8, 0};

opdef optab[] = {
	{ "adci",	&i_immed,	0x69,	geninstr},
	{ "adcz",	&i_zpage,	0x65,	geninstr},
	{ "adczx",	&i_zpage,	0x75,	geninstr},
	{ "adca",	&i_abs,	0x6d,	geninstr},
	{ "adcax",	&i_abs,	0x7d,	geninstr},
	{ "adcay",	&i_abs,	0x79,	geninstr},
	{ "adcix",	&i_abs,	0x61,	geninstr},
	{ "adciy",	&i_abs,	0x71,	geninstr},
	{ "andi",	&i_immed,	0x29,	geninstr},
	{ "andz",	&i_zpage,	0x25,	geninstr},
	{ "andzx",	&i_zpage,	0x35,	geninstr},
	{ "anda",	&i_abs,	0x2d,	geninstr},
	{ "andax",	&i_abs,	0x3d,	geninstr},
	{ "anday",	&i_abs,	0x39,	geninstr},
	{ "andix",	&i_abs,	0x21,	geninstr},
	{ "andiy",	&i_abs,	0x31,	geninstr},
	{ "aslac",	&i_nomem,	0x0a,	geninstr},
	{ "aslz",	&i_zpage,	0x06,	geninstr},
	{ "aslzx",	&i_zpage,	0x16,	geninstr},
	{ "asla",	&i_abs,	0x0e,	geninstr},
	{ "aslax",	&i_abs,	0x1e,	geninstr},
	{ "bcc",	&i_branch,	0x90,	geninstr},
	{ "bcs",	&i_branch,	0xb0,	geninstr},
	{ "beq",	&i_branch,	0xf0,	geninstr},
	{ "bitz",	&i_zpage,	0x24,	geninstr},
	{ "bita",	&i_abs,	0x2c,	geninstr},
	{ "bmi",	&i_branch,	0x30,	geninstr},
	{ "bne",	&i_branch,	0xd0,	geninstr},
	{ "bpl",	&i_branch,	0x10,	geninstr},
	{ "brk",	&i_nomem,	0x00,	geninstr},
	{ "bvc",	&i_branch,	0x50,	geninstr},
	{ "bvs",	&i_branch,	0x70,	geninstr},
	{ "clc",	&i_nomem,	0x18,	geninstr},
	{ "cld",	&i_nomem,	0xd8,	geninstr},
	{ "cli",	&i_nomem,	0x58,	geninstr},
	{ "clv",	&i_nomem,	0xb8,	geninstr},
	{ "cmpi",	&i_immed,	0xc9,	geninstr},
	{ "cmpz",	&i_zpage,	0xc5,	geninstr},
	{ "cmpzx",	&i_zpage,	0xd5,	geninstr},
	{ "cmpa",	&i_abs,	0xcd,	geninstr},
	{ "cmpax",	&i_abs,	0xdd,	geninstr},
	{ "cmpay",	&i_abs,	0xd9,	geninstr},
	{ "cmpix",	&i_abs,	0xc1,	geninstr},
	{ "cmpiy",	&i_abs,	0xd1,	geninstr},
	{ "cpxi",	&i_immed,	0xe0,	geninstr},
	{ "cpxz",	&i_zpage,	0xe4,	geninstr},
	{ "cpxa",	&i_abs,	0xec,	geninstr},
	{ "cpyi",	&i_immed,	0xc0,	geninstr},
	{ "cpyz",	&i_zpage,	0xc4,	geninstr},
	{ "cpya",	&i_abs,	0xcc,	geninstr},
	{ "decz",	&i_zpage,	0xc6,	geninstr},
	{ "deczx",	&i_zpage,	0xd6,	geninstr},
	{ "deca",	&i_abs,	0xce,	geninstr},
	{ "decax",	&i_abs,	0xde,	geninstr},
	{ "dex",	&i_nomem,	0xca,	geninstr},
	{ "dey",	&i_nomem,	0x88,	geninstr},
	{ "eori",	&i_immed,	0x49,	geninstr},
	{ "eorz",	&i_zpage,	0x45,	geninstr},
	{ "eorzx",	&i_zpage,	0x55,	geninstr},
	{ "eora",	&i_abs,	0x4d,	geninstr},
	{ "eorax",	&i_abs,	0x5d,	geninstr},
	{ "eoray",	&i_abs,	0x59,	geninstr},
	{ "eorix",	&i_abs,	0x41,	geninstr},
	{ "eoriy",	&i_abs,	0x51,	geninstr},
	{ "incz",	&i_zpage,	0xe6,	geninstr},
	{ "inczx",	&i_zpage,	0xf6,	geninstr},
	{ "inca",	&i_abs,	0xee,	geninstr},
	{ "incax",	&i_abs,	0xfe,	geninstr},
	{ "inx",	&i_nomem,	0xe8,	geninstr},
	{ "iny",	&i_nomem,	0xc8,	geninstr},
	{ "jmp",	&i_abs,	0x4c,	geninstr},
	{ "jmpi",	&i_abs,	0x6c,	geninstr},
	{ "jsr",	&i_abs,	0x20,	geninstr},
	{ "ldai",	&i_immed,	0xa9,	geninstr},
	{ "ldaz",	&i_zpage,	0xa5,	geninstr},
	{ "ldazx",	&i_zpage,	0xb5,	geninstr},
	{ "ldaa",	&i_abs,	0xad,	geninstr},
	{ "ldaax",	&i_abs,	0xbd,	geninstr},
	{ "ldaay",	&i_abs,	0xb9,	geninstr},
	{ "ldaix",	&i_abs,	0xa1,	geninstr},
	{ "ldaiy",	&i_abs,	0xb1,	geninstr},
	{ "ldxi",	&i_immed,	0xa2,	geninstr},
	{ "ldxz",	&i_zpage,	0xa6,	geninstr},
	{ "ldxzy",	&i_zpage,	0xb6,	geninstr},
	{ "ldxa",	&i_abs,	0xae,	geninstr},
	{ "ldxay",	&i_abs,	0xbe,	geninstr},
	{ "ldyi",	&i_immed,	0xa0,	geninstr},
	{ "ldyz",	&i_zpage,	0xa4,	geninstr},
	{ "ldyzx",	&i_zpage,	0xb4,	geninstr},
	{ "ldya",	&i_abs,	0xac,	geninstr},
	{ "ldyax",	&i_abs,	0xbc,	geninstr},
	{ "lsrac",	&i_nomem,	0x4a,	geninstr},
	{ "lsrz",	&i_zpage,	0x46,	geninstr},
	{ "lsrzx",	&i_zpage,	0x56,	geninstr},
	{ "lsra",	&i_abs,	0x4e,	geninstr},
	{ "lsrax",	&i_abs,	0x5e,	geninstr},
	{ "nop",	&i_nomem,	0xea,	geninstr},
	{ "orai",	&i_immed,	0x09,	geninstr},
	{ "oraz",	&i_zpage,	0x05,	geninstr},
	{ "orazx",	&i_zpage,	0x15,	geninstr},
	{ "oraa",	&i_abs,	0x0d,	geninstr},
	{ "oraax",	&i_abs,	0x1d,	geninstr},
	{ "oraay",	&i_abs,	0x19,	geninstr},
	{ "oraix",	&i_abs,	0x01,	geninstr},
	{ "oraiy",	&i_abs,	0x11,	geninstr},
	{ "pha",	&i_nomem,	0x48,	geninstr},
	{ "php",	&i_nomem,	0x08,	geninstr},
	{ "pla",	&i_nomem,	0x68,	geninstr},
	{ "plp",	&i_nomem,	0x28,	geninstr},
	{ "rolac",	&i_nomem,	0x2a,	geninstr},
	{ "rolz",	&i_zpage,	0x26,	geninstr},
	{ "rolzx",	&i_zpage,	0x36,	geninstr},
	{ "rola",	&i_abs,	0x2e,	geninstr},
	{ "rolax",	&i_abs,	0x3e,	geninstr},
	{ "rorac",	&i_nomem,	0x6a,	geninstr},
	{ "rorz",	&i_zpage,	0x66,	geninstr},
	{ "rorzx",	&i_zpage,	0x76,	geninstr},
	{ "rora",	&i_abs,	0x6e,	geninstr},
	{ "rorax",	&i_abs,	0x7e,	geninstr},
	{ "rti",	&i_nomem,	0x40,	geninstr},
	{ "rst",	&i_nomem,	0x60,	geninstr},
	{ "sbci",	&i_immed,	0xe9,	geninstr},
	{ "sbcz",	&i_zpage,	0xe5,	geninstr},
	{ "sbczx",	&i_zpage,	0xf5,	geninstr},
	{ "sbca",	&i_abs,	0xed,	geninstr},
	{ "sbcax",	&i_abs,	0xfd,	geninstr},
	{ "sbcay",	&i_abs,	0xf9,	geninstr},
	{ "sbcix",	&i_abs,	0xe1,	geninstr},
	{ "sbciy",	&i_abs,	0xf1,	geninstr},
	{ "sec",	&i_nomem,	0x38,	geninstr},
	{ "sed",	&i_nomem,	0xf8,	geninstr},
	{ "sei",	&i_nomem,	0x78,	geninstr},
	{ "staz",	&i_zpage,	0x85,	geninstr},
	{ "stazx",	&i_zpage,	0x95,	geninstr},
	{ "staa",	&i_abs,	0x8d,	geninstr},
	{ "staax",	&i_abs,	0x9d,	geninstr},
	{ "staay",	&i_abs,	0x99,	geninstr},
	{ "staix",	&i_abs,	0x81,	geninstr},
	{ "staiy",	&i_abs,	0x91,	geninstr},
	{ "stxz",	&i_zpage,	0x86,	geninstr},
	{ "stxzy",	&i_zpage,	0x96,	geninstr},
	{ "stxa",	&i_abs,	0x8e,	geninstr},
	{ "styz",	&i_zpage,	0x84,	geninstr},
	{ "styzx",	&i_zpage,	0x94,	geninstr},
	{ "stya",	&i_abs,	0x8c,	geninstr},
	{ "tax",	&i_nomem,	0xaa,	geninstr},
	{ "tay",	&i_nomem,	0xa8,	geninstr},
	{ "tsx",	&i_nomem,	0xba,	geninstr},
	{ "txa",	&i_nomem,	0x8a,	geninstr},
	{ "txs",	&i_nomem,	0x9a,	geninstr},
	{ "tya",	&i_nomem,	0x98,	geninstr}
};

#define oplen sizeof(optab)/sizeof(opdef)

symbol predef[] = {
	{ "acptr",      0xffa5, &o_mem, (segmnt *) 0 },
	{ "chkin",      0xffc6, &o_mem, (segmnt *) 0 },
	{ "chkout",     0xffc9, &o_mem, (segmnt *) 0 },
	{ "chrin",      0xffcf, &o_mem, (segmnt *) 0 },
	{ "chrout",     0xffd2, &o_mem, (segmnt *) 0 },
	{ "ciout",      0xffa8, &o_mem, (segmnt *) 0 },
	{ "cint",       0xff81, &o_mem, (segmnt *) 0 },
	{ "clall",      0xffe7, &o_mem, (segmnt *) 0 },
	{ "close",      0xffc3, &o_mem, (segmnt *) 0 },
	{ "clrchn",     0xffcc, &o_mem, (segmnt *) 0 },
	{ "getin",      0xffe4, &o_mem, (segmnt *) 0 },
	{ "iobase",     0xfff3, &o_mem, (segmnt *) 0 },
	{ "ioinit",     0xff84, &o_mem, (segmnt *) 0 },
	{ "listen",     0xffb1, &o_mem, (segmnt *) 0 },
	{ "load",       0xffd5, &o_mem, (segmnt *) 0 },
	{ "membot",     0xff9c, &o_mem, (segmnt *) 0 },
	{ "memtop",     0xff99, &o_mem, (segmnt *) 0 },
	{ "open",       0xffc0, &o_mem, (segmnt *) 0 },
	{ "plot",       0xfff0, &o_mem, (segmnt *) 0 },
	{ "ramtas",     0xff87, &o_mem, (segmnt *) 0 },
	{ "rdtim",      0xffde, &o_mem, (segmnt *) 0 },
	{ "readst",     0xffb7, &o_mem, (segmnt *) 0 },
	{ "restor",     0xff8a, &o_mem, (segmnt *) 0 },
	{ "save",       0xffd8, &o_mem, (segmnt *) 0 },
	{ "scnkey",     0xff9f, &o_mem, (segmnt *) 0 },
	{ "screen",     0xffed, &o_mem, (segmnt *) 0 },
	{ "second",     0xff93, &o_mem, (segmnt *) 0 },
	{ "setlfs",     0xffba, &o_mem, (segmnt *) 0 },
	{ "setmsg",     0xff90, &o_mem, (segmnt *) 0 },
	{ "setnam",     0xffbd, &o_mem, (segmnt *) 0 },
	{ "settim",     0xffdb, &o_mem, (segmnt *) 0 },
	{ "settmo",     0xffa2, &o_mem, (segmnt *) 0 },
	{ "stop",       0xffe1, &o_mem, (segmnt *) 0 },
	{ "talk",       0xffb4, &o_mem, (segmnt *) 0 },
	{ "tksa",       0xff96, &o_mem, (segmnt *) 0 },
	{ "udtim",      0xffea, &o_mem, (segmnt *) 0 },
	{ "unlsn",      0xffae, &o_mem, (segmnt *) 0 },
	{ "untlk",      0xffab, &o_mem, (segmnt *) 0 },
	{ "vector",     0xff8d, &o_mem, (segmnt *) 0 },
	{ "",           0x0,    &o_none, (segmnt *) 0 }
};
