/*_ stdio.h   Fri Nov 24 1989	Modified by: Walter Bright */
/* Standard I/O header file	*/

#ifndef __STDIO_H
#define __STDIO_H

#if __cplusplus
extern "C" {
#endif

#ifdef __STDC__
#define __CDECL
#define __STDCALL
#else
#define __CDECL _cdecl
#define __STDCALL _stdcall
#endif

#if __OS2__ && __I86__ >= 3
#define __CLIB	__STDCALL
#else
#define __CLIB	__CDECL
#endif

#if M_UNIX || M_XENIX || __NT__
#define _NFILE	60		/* # of files we can have open at once	*/
#else
#define _NFILE	32		/* # of files we can have open at once	*/
#endif
#define EOF (-1)

#define SEEK_SET	0	/* seek from start of file	*/
#define SEEK_CUR	1	/* relative to current position */
#define SEEK_END	2	/* relative to end of file	*/

#ifndef NULL
#if __COMPACT__ || __LARGE__ || __VCM__
#define NULL 0L
#else
#define NULL 0
#endif
#endif

/* I/O buffer size	*/
#if M_UNIX || M_XENIX
#define BUFSIZ		4096
extern char * __CDECL _bufendtab[];
#elif __I86__ >= 3
#define BUFSIZ		0x4000
#else
#define BUFSIZ		1024
#endif

#if __I86__ <= 2 && (__SMALL__ || __MEDIUM__)
#define BIGBUF		(20 * 1024)
#endif

typedef unsigned size_t;

/**** structure for high level file I/O ********/

typedef struct _iobuf
{
#if M_UNIX || M_XENIX
	int	_cnt;		/* number of characters left in buffer	*/
	char	*_ptr;		/* pointer to next character position	*/
	char	*_base; 	/* pointer to start of buffer		*/
	char	_flag;		/* various info about this channel	*/
	char	_file;		/* file "handle"			*/
#define _bufsize(f) (_bufendtab[(f)->_file] - (f)->_base)
#elif __OS2__ && __I86__ >= 3
	char	*_ptr;
	int	_cnt;
	char	*_base;
	int	_flag;
	int	_file;
	int	_charbuf;
	int	_bufsiz;
	int	__tmpnum;
#define _bufsize(f) ((f)->_bufsiz)
#elif __NT__
	char	*_ptr;
	int	_cnt;
	char	*_base;
	int	_flag;
	int	_file;
	int	_charbuf;
	int	_bufsiz;
	int	__tmpnum;
#define _bufsize(f) ((f)->_bufsiz)
#else
	char	*_ptr;		/* pointer to next character position	*/
	int	_cnt;		/* number of characters left in buffer	*/
	char	*_base;		/* pointer to start of buffer		*/
	int	_flag;		/* various info about this channel	*/
	int	_file;		/* file "handle"			*/
	unsigned _bufsiz;	/* size of buffer being used		*/
#ifdef	BIGBUF
	int	_seg;		/* segment of buffer if _IOBIGBUF	*/
#endif
#define _bufsize(f) ((f)->_bufsiz)
#endif
} FILE;

extern	FILE __CDECL _iob[_NFILE];

#define _IOREAD		1	/* file is opened for read		*/
#define _IOWRT		2	/* file is opened for write		*/
#define _IONBF		4	/* file I/O is not buffered		*/
#define _IOMYBUF	8	/* buffer allocated by setvbuf()	*/
#define _IOEOF		0x10	/* end of file has occurred		*/
#define _IOERR		0x20	/* error has occurred			*/
#define _IOLBF		0x40	/* file is line buffered		*/
#define _IORW		0x80	/* file is opened for reading and writing */
#define _IOFBF		0	/* file is fully buffered		*/
#define _IOAPP		0x200 /* has the file been opened for append */
#if M_UNIX || M_XENIX
#define _IOTRAN		0	/* I/O is never translated under UNIX	*/
#else
#define _IOTRAN		0x100	/* I/O is translated (not binary)	*/
#ifdef	BIGBUF
#define _IOBIGBUF	0x400	/* the buffer is outside the data segment */
#endif
#endif

#define stdin	(&_iob[0])
#define stdout	(&_iob[1])
#define stderr	(&_iob[2])

#if M_UNIX || M_XENIX
#define FOPEN_MAX	60
#define FILENAME_MAX	255
#else
#ifndef __STDC__
#ifndef __NT__
#define stdaux	(&_iob[3])
#define stdprn	(&_iob[4])
#endif
#endif
#define FOPEN_MAX	20
#define FILENAME_MAX	(3+64+8+1+3)
#endif

#define L_tmpnam	7
#define TMP_MAX		32767

typedef long fpos_t;

char *	__CLIB tmpnam(char *);
FILE *	__CLIB fopen(const char *,const char *);
FILE *	__CLIB freopen(const char *,const char *,FILE *);
int	__CLIB fseek(FILE *,long,int);
long	__CLIB ftell(FILE *);
char *	__CLIB fgets(char *,int,FILE *);
int	__CLIB fgetc(FILE *);
int	__CLIB fflush(FILE *);
int	__CLIB fclose(FILE *);
int	__CLIB fputs(const char *,FILE *);
int	__CLIB getc(FILE *);
int	__CLIB getchar(void);
char *	__CLIB gets(char *);
int	__CLIB fputc(int,FILE *);
int	__CLIB putc(int,FILE *);
int	__CLIB putchar(int);
int	__CLIB puts(const char *);
int	__CLIB ungetc(int,FILE *);
size_t	__CLIB fread(void *,size_t,size_t,FILE *);
size_t	__CLIB fwrite(const void *,size_t,size_t,FILE *);
int	__CDECL printf(const char *,...);
int	__CDECL fprintf(FILE *,const char *,...);
int	__CLIB  vfprintf(FILE *,const char *,char __ss *);
int	__CLIB  vprintf(const char *,char __ss *);
int	__CDECL sprintf(char *,const char *,...);
int	__CLIB  vsprintf(char *,const char *,char __ss *);
int	__CDECL scanf(const char *,...);
int	__CDECL fscanf(FILE *,const char *,...);
int	__CDECL sscanf(const char *,const char *,...);
void	__CLIB setbuf(FILE *,char *);
int	__CLIB setvbuf(FILE *,char *,int,size_t);
int	__CLIB remove(const char *);
int	__CLIB rename(const char *,const char *);
void	__CLIB rewind(FILE *);
void	__CLIB clearerr(FILE *);
int	__CLIB feof(FILE *);
int	__CLIB ferror(FILE *);
void	__CLIB perror(const char *);
int	__CLIB fgetpos(FILE *,fpos_t *);
int	__CLIB fsetpos(FILE *,const fpos_t *);
FILE *	__CLIB tmpfile(void);

#if __cplusplus
inline int __CLIB getchar()		{ return getc(stdin);		}
inline int __CLIB putchar(int c)	{ return putc(c,stdout);	}
inline int __CLIB getc(FILE *fp)	{ return fgetc(fp);		}
inline int __CLIB putc(int c,FILE *fp)	{ return fputc(c,fp);		}
inline int __CLIB ferror(FILE *fp)	{ return fp->_flag&_IOERR;	}
inline int __CLIB feof(FILE *fp)	{ return fp->_flag&_IOEOF;	}
inline void __CLIB clearerr(FILE *fp)	{ fp->_flag &= ~(_IOERR|_IOEOF); }
inline void __CLIB rewind(FILE *fp)	{ fseek(fp,0L,SEEK_SET); fp->_flag&=~_IOERR; }
#else
#define getchar()	getc(stdin)
#define putchar(c)	putc((c),stdout)
#define getc(fp)	fgetc(fp)
#define putc(c,fp)	fputc((c),(fp))
#define ferror(fp)	((fp)->_flag&_IOERR)
#define feof(fp)	((fp)->_flag&_IOEOF)
#define clearerr(fp)	((void)((fp)->_flag&=~(_IOERR|_IOEOF)))
#define rewind(fp)	(((fp)->_cnt =0),(void)(fseek(fp,0L,SEEK_SET),((fp)->_flag&=~_IOERR)))
#endif

#ifndef __STDC__	/* non-ANSI functions	*/
#define fileno(fp)	((fp)->_file)
#define unlink(name) remove(name)

#if M_UNIX || M_XENIX
int	__CDECL pclose(FILE *fp);
FILE *	__CDECL popen(const char *command,const char *t);
#endif

FILE *	__CLIB fdopen(int, const char *);
int	__CLIB fcloseall(void);
long	__CLIB filesize(const char *);
int	__CLIB flushall(void);
int	__CLIB getch(void);
int	__CLIB getche(void);
char *	__CLIB tempnam (const char *dir, const char *pfx);
#endif

#if __cplusplus
}
#endif

#endif /* __STDIO_H */
