#ifndef __VIRIMG_H
#define __VIRIMG_H


#define XDISK 1
#define XXMS 2

/* The following are various external parameters for the Virtual Arrays
	all have defaults which are shown as the first in the list */
/* Do you want to keep Extended memory safe : 1=Yes 0=No */
extern char ___safety;
/* What is the file used for keeping extended memory safe : c:\!safety!.xms
extern char *___safe_filename;
/* Do you want informative messages from the array manager : 1=Yes 0=No */
extern char ___msgs;
/* What is the filename for the disk caching manger swap file : virarray.swp*/
extern char *___xfilename;
/* What is the size of the file buffer for the disk manager : 32768*/
extern int ___xfile_buf;
/* Where are the CPP arrays to be cached : XXMS = Extended memory
										   XDISK = Disk */
extern char ___xarrays;
/* How many blocks are to be held in coventional memory for CPP arrays : 4*/
extern int __mem_buf;
/* What is the block size for the CPP manager : 32768 */
extern long __block_size;
/* How many block does the CPP manager want : 16 */
extern int __blocks;
/* If there is not enough Xtended memory should the manger cache to disk
		instead : 1=Yes 0=No */
extern char ___auto_disk;


#ifdef __cplusplus
extern "C" {
#endif
void initialise_virtual_arrays(int real_img,long array_size,unsigned int no_imgs, int dorx);
void deallocate();
void *large_array(int no,long ind);
void *pointer_add(void *tes,long no);
void *img(int no);
void create_xms_array (long x, long y, int size, long **offset, int **block);

/*Timer to measure the time taken for sections of code */
void start_timer();
void stop_timer();

#ifdef __cplusplus
}
#endif

#endif