/* -------------------------------------------------------------------- */
/* String++ Version 3.00                                       04/10/93 */
/*                                                                      */
/* Enhanced string class for Turbo C++/Borland C++.                     */
/* Copyright 1991-1993 by Carl W. Moreland                              */
/*                                                                      */
/* filestr.cpp                                                          */
/* -------------------------------------------------------------------- */

#include "filestr.h"

FileString::FileString(const char* PathName)
{
  String tmp = PathName;
  Process(tmp);
}

FileString::FileString(const String& PathName)
{
  Process(PathName);
}

void FileString::Process(const String& PathName)
{
  int n;

  n = PathName.FindLast("\\");

  Path     = PathName.SubStr(0, n+1);
  FileName = PathName.SubStr(n+1, PathName.Len()-n-1);

  n = FileName.FindLast(".");

  if(n != -1)
  {
    Name = FileName.SubStr(0, n);
    Ext  = FileName.SubStr(n+1, FileName.Len()-n-1);
  }
  else
    Name = FileName;

  if(Path[1] == ':')
  {
    Drive = Path.SubStr(0,2);
    Path.Delete(0,2);
  }
}

void FileString::operator=(const char* PathName)
{
  String tmp = PathName;
  Process(tmp);
}

void FileString::operator=(const string& PathName)
{
  Process(PathName);
}
