//--------------------------------------------------------------------------
//
//      EXAMPLE2.CPP: example program 2 for DOS coroutine library.
//      Copyright (c) J.English 1993.
//      Author's address: je@unix.brighton.ac.uk
//
//      Permission is granted to use copy and distribute the
//      information contained in this file provided that this
//      copyright notice is retained intact and that any software
//      or other document incorporating this file or parts thereof
//      makes the source code for the library of which this file
//      is a part freely available.
//
//--------------------------------------------------------------------------

#include <iostream.h>
#include <bios.h>
#include "coroutine.h"

#define ESC     0x1B        // code for the ESC key

//--------------------------------------------------------------------------
//
//      Class Example2.
//
//      This is a coroutine which displays a series of messages.  It
//      illustrates how the main program can terminate the coroutines
//      it creates in an orderly manner.
//
class Example2 : public Coroutine
{
  public:
    Example2 (int n)        { num = n; }

  protected:
    virtual void main ();   // code to be executed by coroutine

  private:
    int num;                // coroutine identification number
};

static int quit = 0;        // flag to request coroutine termination

//--------------------------------------------------------------------------
//
//      Example2::main.
//
//      This is the code executed by each instance of class Example2.
//      It displays a startup message, executes a loop (pausing each
//      time) until the main program sets the "quit" flag, and then
//      displays a termination message before exiting.
//
void Example2::main ()
{
    cout << "\nCoroutine E" << num << " started\n";

    while (!quit)
    {   cout << num << " ";
        pause ();
    }

    cout << "\nCoroutine E" << num << " finished\n";
}

//--------------------------------------------------------------------------
//
//      The main program.
//
//      This creates three instances of class Example2, starts them
//      running and then waits until ESC is pressed.  It then sets
//      the "quit" flag to signal the coroutines to terminate before
//      exiting.  Note that the loop which waits for ESC to be pressed
//      calls "pause" each time to allow the coroutines to execute, and
//      that it uses bioskey(1) (test if a key has been pressed) rather
//      than just bioskey(0) which would wait for a keypress and would
//      not allow the couroutines to run between keypresses.
//
void main ()
{
    Example2 e1 (1), e2 (2), e3 (3);

    //--- start the coroutines running
    if (!e1.run ())
        cout << "Couldn't start e1\n";
    if (!e2.run ())
        cout << "Couldn't start e2\n";
    if (!e3.run ())
        cout << "Couldn't start e3\n";

    //--- wait for ESC to be pressed
    while (bioskey (1) == 0 || (bioskey (0) & 0xFF) != ESC)
        Example2::pause ();

    //--- terminate the coroutines
    quit = 1;

}   //--- destructors called here: wait for coroutines to finish, then exit

