; File......: DBTHANDL.ASM
; Author....: Ted Means
; Date......: $Date:   15 Oct 1992 23:55:54  $
; Revision..: $Revision:   1.0  $
; Log file..: $Logfile:   C:/nanfor/src/dbthandl.asv  $
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   C:/nanfor/src/dbthandl.asv  $
;  
;     Rev 1.0   15 Oct 1992 23:55:54   GLENN
;  Initial revision.
;  

; $DOC$
; $FUNCNAME$
;     FT_DBTHand()
; $CATEGORY$
;     Database
; $ONELINER$
;     Obtain the handle associated with an open .DBT file.
; $SYNTAX$
;     FT_DBTHand() -> nHandle
; $ARGUMENTS$
;     None
; $RETURNS$
;    The file handle, or zero if no .DBT is open in the specified
;    work area.
; $DESCRIPTION$
;    For your own twisted reasons you may need make direct use of the
;    file handle associated with a memo field file.  This function gives you
;    that capability, but use it with care and don't blame me if you
;    botch something up.
;
;    By default this function works on the current work area, but can be
;    made to work on any work area through the use of the standard Clipper
;    alias operator.
;
;    Be aware that this function makes use of Clipper's internal work
;    area information which is subject to change in future versions of
;    Clipper.  If this makes you uncomfortable then don't use this function,
;    you spineless jellyfish.
;
;    This function is written to adhere to Turbo Assembler's IDEAL mode.
;    To use another assembler, rearrange the SEGMENT and PROC directives
;    and make any other necessary changes to the source code.
;
; $EXAMPLES$
;      QOut( FT_DBTHand() )
;
;      // Try a non-current work area
;
;      nHandle := THISFILE->( FT_DBTHand() )
;
;      // This will return zero if no database is open in work area 133
;
;      select 133
;      QOut( FT_DBTHand() )
;
; $END$

IDEAL                                        ; Invoke TASM IDEAL mode

Public   FT_DBTHand

Extrn    __WorkAreas:DWord                   ; INTERNAL!!!
Extrn    __RetNI:Far

Segment  _NanFor   Word      Public    "CODE"
         Assume    CS:_NanFor

Proc     FT_DBTHand          Far

         LES       BX,[__WorkAreas]          ; Load pointer to work areas
         Mov       AX,[Word Ptr ES:BX]       ; Check to see if work area
         Or        AX,[Word Ptr ES:BX + 2]   ; is in use
         JZ        @@Done                    ; If not, return zero
         LES       BX,[DWord Ptr ES:BX]      ; Load work area pointer
         Mov       AX,[Word Ptr ES:BX + 6Eh] ; Load handle

@@Done:  Push      AX                        ; Put return value on stack
         Call      __RetNI                   ; Return it
         Add       SP,2                      ; Realign stack
         Ret
Endp     FT_DBTHand
Ends     _NanFor
End

