/*
 * File......: CTRL.C
 * Author....: Ted Means
 * Date......: $Date:   15 Aug 1991 23:08:10  $
 * Revision..: $Revision:   1.2  $
 * Log file..: $Logfile:   E:/nanfor/src/ctrl.c_v  $
 * 
 * This function is an original work by Ted Means and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:   E:/nanfor/src/ctrl.c_v  $
 * 
 *    Rev 1.2   15 Aug 1991 23:08:10   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 * 
 *    Rev 1.1   14 Jun 1991 19:53:40   GLENN
 * Minor edit to file header
 * 
 *    Rev 1.0   01 Apr 1991 01:02:44   GLENN
 * Nanforum Toolkit
 * 
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FT_CTRL()
 *  $CATEGORY$
 *     Keyboard/Mouse
 *  $ONELINER$
 *     Determine status of the Ctrl key
 *  $SYNTAX$
 *     FT_CTRL() -> lValue
 *  $ARGUMENTS$
 *     None
 *  $RETURNS$
 *     .T. if Ctrl key is pressed, .F. if otherwise.
 *  $DESCRIPTION$
 *     This function is useful for times you need to know whether or not
 *     the Ctrl key is pressed, such as during a MemoEdit().
 *  $EXAMPLES$
 *     IF FT_CTRL()
 *        @24, 0 say "Ctrl"
 *     ELSE
 *        @24, 0 say "    "
 *     ENDIF
 *  $SEEALSO$
 *     FT_CAPLOCK() FT_NUMLOCK() FT_PRTSCR() FT_SHIFT() FT_ALT()
 *  $END$
 */

#include <extend.h>

CLIPPER FT_CTRL(void)
{
   _retl( (int) ((*(char *) 0x00000417) & 0x4) );
   return;
}
