













                          OPERATIONS MANUAL

                          CITADEL-86 V3.03

                             by Hue, Jr.

                       C-86 Test System Sysop

                               88Mar01















































     TABLE OF CONTENTS


     I.   Introduction
     II.  Help Files
          II.  1. Location
          II.  2. File Types
          II.  3. Optional Customization
          II.  4. Required Customization
          II.  5. Optional Help Files
          II.  6. Adding Help Files
          II.  7. Delivered

     III. Sysop Privileged Functions
          III. 1. Introduction
          III. 2. Access
          III. 3. Access Restrictions
          III. 4. Sysop Capabilities
          III. 5. Undocumented Sysop Menu Commands

     IV.  User Levels
          IV.  1. Introduction
          IV.  2. Normal Uses
          IV.  3. Aide
          IV.  4. Sysops

     V.   Rooms
          V. I.  1. Room Archival
          V. I.  2. Backbones
          V. I.  3. Directory Status
          V. I.  4. Innominate Status
          V. I.  5. Lure Users
          V. I.  6. Moderator
          V. I.  7. Name Change
          V. I.  8. Only Invitational
          V. I.  9. Privacy Status
          V. I. 10. Temporary Status
          V. I. 11. Shared Status
          V. I. 12. Upload/Download Status
          V. I. 13. Withdraw Invitations
          V. I. 14. Network Downloadable
          V. II. Other Commands
          V. III. Exceptions























     VI. Files - Upload/Download Capabilities
         VI. 1. Origin
         VI. 2. Creation
         VI. 3. User Commands
                a. Contents Listing
                b. File Transfers
                c. <file spec>
             4. Advanced Directory Options

     VII.  <O>ther Commands
         VII. 1. General Purpose
         VII. 2. Other Commands
                 a. Deletion
                 b. Outside Commands

     VIII. Miscellaneous
          VIII. 1. Wha...?
          VIII. 2. Chatty Questions
          VIII. 3. Chat Capture
          VIII. 4. ESCaping
          VIII. 5. Sysop Autodial
          VIII. 6. Denizens of the Status Bar
          VIII. 7. Modem Disabling

    IX. Questions & Answers









































     I.  INTRODUCTION


























































                                    -1-






     II.  HELP FILES
 
     II. 1. Location
        The supporting help files of Citadel-86, which are simple text files,
     should be located in the #HELPAREA drive and directory.  As explained in
     the Installation Manual, you should copy these files to that directory
     before operating your system, unless you do not plan to provide help to
     the users of the system.

     II. 2. File types
        There are three types of Help files, identifiable by their extensions.

        .BLB: These files contain miscellaneous messages and warnings for use
               in certain set locations of Citadel-86.

        .MNU: These files contain menus that are normally printed out when the
              user touches '?' while using Citadel-86.  Usually, these are just
              lists of options.

        .HLP: These are general help files that are accessible through the
              .Help <filename> command.  Generally, these files contain terse
              instructions on the use of the system, including references to
              other files that may be of help to the user.

     II. 3. Optional Customization
        The Help files as delivered are of a generic nature, and any of them
     may be modified using a text editor at the Sysop's option.  The .BLB
     files are generally English descriptions of operations, and can be
     modified for greater readability/useability with little danger of any
     problems.

        On the other hand, the .MNU files should not be modified impulsively,
     since they consist mostly of menu lists.

        The .HLP files are the best candidates for customization, since they
     are English descriptions, and, for the most part, are not "hard-coded"
     into Citadel-86; rather, they are usually referenced by the user after 
     s/he finds a reference to them.

        All help files are formatted just like messages when they are
     displayed to the user; therefore, you should be sure to follow the normal
     Citadel formatting rules when rewriting Help files, except that you
     needn't place a lone space on a blank line to enforce that blank line (a
     difficult thing to do with many editors).

     II. 4. Required Customization
        There are three files that you should customize for your installation
     as soon as you feel you are prepared to.  They are

        HOURS.HLP: This file should contain the hours that your system is
     available to users.








                                    -2-






        POLICY.HLP: This file should contain your general policy statement
     regarding your system and its purpose.  The rules of your system could
     also possibly appear here.

        NOCHAT.BLB: When you have Chat mode turned off on your system, this
     file is printed to the users when they attempt to use the Chat command.


        UNLOG.BLB: This file must be customized by Sysops running closed 
     systems only.  When a user without a password attempts to log into
     such a system, the system will print this file to the would-be user
     if it exists.  If the file doesn't exist, then a hard-coded message
     instructing the user to proceed to Mail> and leave a message for
     Sysop.


     II. 5. Optional Help Files
        There are three Help files that do not need to be present during
     Citadel-86's operation, but if they are will cause Citadel-86 to alter
     its behavior slightly when a user is on the system.

        The first file is BANNER.BLB.  If this file is present in the #HELPAREA
     directory when a user gains carrier, this file will be sent to the user. 
     This allows large beginning banners to be used (remember that an unlogged
     user always has a screen width of 40, so write your file accordingly). 
     If the BANNER.BLB file is not present, then the #nodeTitle parameter of
     CTDLCNFG.SYS will be sent to the user in its place.

        The second file is NOTICE.BLB.  If this file is present in #HELPAREA,
     Citadel-86 will send it to the user upon a successful login.

        The third file is LONOTICE.BLB.  If this file is present in #HELPAREA,
     Citadel-86 will send it to the user when the user executes any of the
     Terminate commands before logging them out.

     II. 6. Adding Help Files
        Through the use of the .Help command, users may access any file that
     you place in the #HELPAREA that has a .HLP extension.  Therefore, if you
     wish to extensively customize and extend the Citadel-86 Help system, you
     should encounter few problems.

        When a user enters ".Help ?", however, the file HELPOPT.HLP will be
     printed to them.  Therefore, you should take care to keep that file up
     to date if you begin adding Help files.















                                    -3-






     II. 7. Delivered
        These are the Help files currently contained in RUNTIME.ARC, which
     therefore you should have.  While it is always attempted to keep these
     files up to date, we cannot guarantee that they are in keeping with the
     release version of Citadel-86 that is in RUNTIME.ARC.

     .BLB files
     BANNER.BLB   | Placeholder, printed to user on carrier detect.
     ENTRY.BLB    | Printed to novice users entering a message.
     NEWROOM.BLB  | Printed to novice users creating a new room.
     NOCHAT.BLB   | Printed to users using the Chat command when inactive.
     PASSWORD.BLB | Printed to novice users during new login process.
     READDATE.BLB | Printed on entry of ".Read New ?" or Old or Reverse or ...
     UNLOG.BLB    | Placeholder, for closed systems only (see X.4).
     WCDOWN.BLB   | Printed to novice users when using .RW or .RX command.
     WCUPLOAD.BLB | Printed to novice users when using .EF or .EXF or .EWF
                  | command.
     YMUPLOAD.BLB | Printed to novice users when using .EYF command.

     .MNU files
     AIDE.MNU     | Printed when an Aide enters .Aide ?.
     AIDEFLR.MNU  | Printed when an Aide enters ;Aide ?.
     CONFG.MNU    | Printed when a user enters .Enter Configuration ?.
     CTDLOPT.MNU  | Printed when a Sysop enters ? at the Privileged fn: prompt.
     EDIT.MNU     | Printed when a user enters ? at the entry cmd: prompt.
     ENTOPT.MNU   | Printed when a user enters .Enter ?.
     FLOOR.MNU    | Printed when a user enters ;?.
     MAINOPT.MNU  | Printed when a user enters ? or .? at a room prompt.
     NETEDIT.MNU  | Printed when the Sysop enters ? at the Net Edit: prompt.
     NETOPT.MNU   | Printed when the Sysop enters ? at the Net Cmd: prompt.
     READOPT.MNU  | Printed when a user enters .Read ?.
     ROOMA.MNU    | Printed when a remote Aide enters ? at the room edit:
                  | prompt.
     ROOMS.MNU    | Printed when a Sysop enters ? at the room edit: prompt.
     SYSOPT.MNU   | Printed when a Sysop enters ? at the Other commands:
                  | prompt.

     .HLP files
     AIDE.HLP     | Aide help file.
     AIDEFLR.HLP  | Aide help file for floor commands.
     DOHELP.HLP   | Printed when user enters the Help command.
     ENTER.HLP    | Help for the Enter commands.
     EXTENDED.HLP | Explains usage of the "." commands.
     FILES.HLP    | Upload/Download help.
     FLOORS.HLP   | Floor help for the normal user.
     FORGET.HLP   | Help on the ZForget room command.
     GOTO.HLP     | Help on the Goto command.
     HELD.HLP     | Help on Holding messages.
     HELPOPT.HLP  | A directory of Help files.
     HIDDEN.HLP   | Help on Hidden rooms.
     HOURS.HLP    | Place holder, should contain your hours.
     LOGINOUT.HLP | Help on Logging in and out of the system.
     MAIL.HLP     | Help on Citadel-86's Mail system.
     NET.HLP      | Help on C86Net.  This can be killed if you are not
                  | networking.




                                    -4-






     POLICY.HLP   | Place holder, should contain your policy.
     READ.HLP     | Help on using the Read commands.
     SKIP.HLP     | Help on using the Skip command.
     SUMMARY.HLP  | Complete summary of the "." and ";" commands.
     YMODEM.HLP   | Help on YMODEM.


     III. SYSOP PRIVILEGED FUNCTIONS
 
     III. 1. Introduction
        In any system, there must be someone in charge if the system is to be
     successful, and that person must have special abilities.  In Citadel-86,
     anyone who has access to the system console may execute many of the Sysop
     capabilities, and the root of all these evils (for necessary as Sysop as
     powers are, they often lead to evil) is the Privileged Fn: menu (aka
     the Sysop Menu).

     III. 2. Access
        The Sysop Menu is accessed by typing a ^L (Control-L) at any room
     prompt.

     III. 3. Access Restrictions
        Access to the Sysop Menu is dependent on the location of the user at
     the time of attempted use.

        If the user is at the System Console, then the user does not even have
     to log in to use the Privileged Functions, once the System is in Console
     mode.  While this may seem somewhat precarious to the prospective Sysop,
     keep in mind that most installations do not normally run in public
     locations.

        If the user is a remote user, then access is very restrictive.  First,
     the system must be using the #sysPassword feature (see Section II.5.C of
     INSTALL3.DOC) of Citadel-86.  Second, the user in question must be an
     Aide of the system.  Finally, the user must possess the password
     specified in the #sysPassword file, because the system will query the
     Aide for the password when the ^L is pressed.

     III. 4. Sysop Capabilities
        Due to the prejudices of the implementor, Citadel-86's Sysop
     capabilities are neither variegated, overly powerful, or pretty; the
     users of the system come before the Sysop.

        Be that as it may, the Sysop Menu is exactly what it sounds like: a
     menu of choices which the Sysop may select from.  After each command
     is executed, the Sysop is queried for another.













                                    -5-






        This is the current official Sysop Menu.

     (CTDLOPT.MNU)

       <A>bort to main menu
       <B>aud rate selection
       <C>hat enable/suppress switch
       <D>ebug switch
       <E>cho to screen switch
       <F>ile grab
       <I>nformation
       <K>ill account
       <M>odem mode
       <N>etworking commands
       <O>ther commands
       <P>rivilege switch (aide)
       <R>einitialize modem
       <S>et date
      e<X>it to MS-DOS

        And here it is in detail.

     III. 4.a <A>bort
        This command exits from the Sysop Menu, leaving you at the current
     room prompt in CONSOLE mode.  If this command is equivalent to the
     <M>odem mode command (X.4.i) if the user is a remote caller.

     III. 4.b <B>aud rate selection
        This antiquated, obsolescent command allows you to set the baud rate
     of the serial port to the value that you indicate.  This command has some
     occasional usefulness in certain debug situations, so it still exists.

     III. 4.c <C>hat enable/disable
        This command acts as a toggle for Chat enabled/disabled.  When Chat is
     enabled, the System will display a 'C' somewhere on your Status bar, and
     users using the <C>hat command will be able to page you.  When the toggle
     is off, users using <C>hat will be greeted by your NOCHAT.BLB file (see
     Section X, HELP FILES).  Aides using the .Aide Chat command can, however,
     override this toggle.  A Sysop who really, truly wants privacy can use
     the +nochat option on the command line to shut Aides out (see Section
     II.9.a of INSTALL3.DOC).

     III. 4.d <D>ebug switch
        This toggle command alternately turns debug code off and on.  Under
     normal circumstances, this toggle should always be off.  There is no
     telling what it will do from version to version, and in general will be of
     little, if any, help in isolating problems with your installation; it is
     more of a programming aide.

     III. 4.e <E>cho to screen
        This toggle controls whether any output goes to the screen when the
     system is in MODEM mode.  This option is, of course, inoperative while
     the system is in CONSOLE mode.






                                    -6-






     III. 4.f <F>ile grab
        This command allows the Sysop to "grab" text files that are anywhere
     on his disk system into his Held Message buffer.  In essence, this gives
     the Sysop an equivalent ability to a normal user's composing a message
     offline and then uploading it.  The Sysop may compose a message using
     his or her favorite editor, and then <F>ile grab it into the Held
     Message Buffer.

        To be more precise, the <F>ile grab command only appends the text file
     (or as much as it can digest) to the Held Message Buffer, thus allowing
     construction of messages from several sources.  Furthermore, none of the
     other contents of the Held Message are disturbed.  Therefore, you can
     begin writing a message using Citadel-86, hold the message, <F>ile grab
     something, and continue onwards.

     III. 4.g <I>nformation
        This command provides information on the current version of Citadel-86
     that you are running.  The information is provided in the following format:


             Citadel-86 VM.mm
             Net Version N.n
             Commands version O.ooo
             Ctdlcnfg.sys version Q

        "Citadel-86 VM.mm" is the same version that is printed on Carrier Detect
     to users.  The "M" digit indicates the Major Change that Citadel-86 is at
     ("1" was simply a version that worked under MS-DOS, "2" was the addition
     of C86Net, "3" the addition of Floors).  The "mm" digits indicates changes
     made to Citadel-86 that provides normal users with substantial new
     capabilities.  Typically, "mm" does not change for new Sysop capabilities,
     cosmetic changes, or the like; it's really nothing more than a gross
     indicator of the version.

        "Net Version N.n" indicates the network capability of Citadel-86.  "N"
     indicates any Major changes to the network (the first version of C86Net
     did not have a number [boy, was it bad!], the second version was "0", and
     the current is "1").  Due to the expandable nature of C86Net, "N" will
     probably never change again.  "n" indicates Facility additions.  The
     association of "n" to Facility addition is documented in the INCREM.* files
     (which will be described shortly), and detailed in NETWORK3.DOC.

        "Commands version O.ooo" tells the real story behind what version you
     are running.  "O" is the Enhancement version, and is incremented whenever
     Citadel-86 is enhanced with a new command or appearance.  "ooo" is the Fix
     version, and is incremented whenever a bug is fixed or another internal
     change takes place.  "O.ooo" values are, again, documented in the INCREM.*
     files.

        "Ctdlcnfg.sys version Q" tells what version of CTDLCNFG.SYS the system
     is at.  Typically, this value is only incremented for Major Releases.








                                    -7-






        So what are these INCREM.* files?  These files, available on Test
     System (ask the Sysop for access to them), and possibly other systems,
     document the changes made to Citadel-86, albeit very tersely.  The format
     of the documentation is:

     <version change>        <date>          <description>

        <version change> usually refers to the Commands version, although it
     can refer to any of the version information in the <I>nformation command.
     <date> is when the version change was written/released.  Description is
     the terse description of what occurred to force the change in version;
     when it is "???", it means that the Sysop was programming in his sleep
     again and forgot what he did (here we take a deep breath ...).

        The INCREM.* files constitute the most reliable information on
     upgrades to Citadel-86, short of asking Test System's Sysop himself.
     Since he is a very grumpy person (born that way, you see), and is not
     adverse to biting off the heads of anyone who comes near, it is better
     to peruse these files once you have access to them.

     III. 4.h <K>ill Account
        The time-honored function, Kill account, is accessed by typing K at
     the Sysop Menu.  Please don't kill the account of the person currently
     logged in.

     III. 4.i <M>odem mode
        This command returns the system to MODEM mode.  If you have logged in
     at the CONSOLE, it is NOT a good idea to use this command until you have 
     logged out.

     III. 4.j <N>etworking commands
        This option takes you to a submenu that is only available on systems
     that are using the Network facilities (see II.5.d of INSTALL3.DOC and all
     of NETWORK3.DOC).  Since NETWORK3.DOC should explain this menu in detail
     (although perhaps not with the level of organization desired), we shan't
     go any farther here.

     III. 4.k <O>ther commands
        This option will deliver you to another submenu that is covered in
     Section X, OTHER COMMANDS MENU.

     III. 4.l <P>rivileged switch
        The creation of those drudges, Aides, takes place through this
     command.  Anyone who is forced to become an Aide should also be forced
     to read AIDE.HLP (conveniently written in pidgin Swahili), which details
     most of the Aide capabilities.  As noted, Aides given the system password
     will gain access to this menu.

     III. 4.m <R>einitialize modem
        This option allows you to reinitialize the modem.

     III. 4.n <S>et date
        This function lets you set the date of the system.






                                    -8-






     III. 4.o e<X>it to MS-DOS
        Finally, this command should be used to take Citadel-86 down
     gracefully. The current user is logged out if present, and the system 
     will then attempt to deactivate itself.

     III. 5 Undocumented Sysop Menu Commands
        There are always one or more undocumented commands floating around in
     the Sysop Menu.  These are, without exception, debug commands for use by
     the programmer(s) of Citadel-86, and are not guaranteed to exist from one
     version to another of Citadel-86.  To expand even more upon this
     frightening thought, the safety and integrity of your systems are not
     guaranteed if you start screwing around with these options.

        So don't.


     IV. USER LEVELS
 
     IV. 1 Intro to User Levels
        Citadel-86 (and related systems) are often popular with users because
     they do not have the superfluous user levels that many other types of BBS
     software have.  We believe that this lets the user feel a little more free
     with the system; the lack of direct control makes them willing to partici-
     pate in the system earlier.

        However, this does not mean that Citadel-86 completely lacks in user
     levels.  Citadel-86 uses the same 3-level hierarchy that came with the
     original CP/M Citadel.  At the bottom is the normal users, with the usual
     privileges of reading and writing.  Next comes the Aides, who are users
     with certain caretaker powers.  Finally, the Sysops and remote sysops,
     who can do a little more.

     IV. 2 Normal Users
        Normal users are created, as you might guess, by simply logging in.
     They may read, write, and upload to all rooms that they have access to.

     IV. 3 Aides
        Aides are created using the <P>rivilege switch on the Sysop Menu (see
     Section Y.4.l).  Aides are users who act as caretakers for the Sysop.
     Their abilities and methods are summarized in AIDE.HLP and AIDEFLR.HLP
     as well as here.  They have access to the private Aide> room.

     IV. 3.a Message Deletion
        Aides may delete any message in the system with the exception of
     messages in Mail>.  Messages which are deleted will be moved to the Aide
     room, and will be preceded by a message from Citadel noting the name of
     the Aide who performed the deletion.

        Messages in Mail> which are deleted by Aides (Aides only have access
     to their own Mail> room) remain in Mail> and show up in the Aide> room.

        A message is deleted by <P>ausing the target message during printout,
     and restarting message output by pressing 'D'.    The message will repeat,
     and then the system will ask if you wish to Delete the message, Move the
     message, or Abort the operation.  Selecting D will cause the message to
     be deleted.



                                    -9-






     IV. 3.b Moving Messages
        Aides may move any message from its current room to another room.  The
     moved message will also appear in the Aide> room, along with a message
     regarding who moved the message.  Messages in Mail> may not be moved
     successfully.

        A message is moved just like a message is deleted, by selecting 'M'
     when the system asks if you wish to Delete, Move, or Abort the operation.
     The Aide is then asked which room to move the message to.  If one or more
     messages have been moved since the system was brought up, an empty
     Carriage Return will put the message in the last room a message was moved
     to.  The Aide does not need to type the entire name of the room to move
     the message to; a partial name is sufficient, so long as it is unique
     within the system.

        Moving a message to an auto-net room does not cause that message to
     become a net message. Moving a message to an archived room does not cause
     that message to be archived.  Moving a message to an anonymous room does
     not cause that message to become anonymous.


     IV. 3.c Room Elimination
        Aides may delete any room in the system, with the exception of the
     Mail>, Aide>, and #baseRoom rooms.  A message recording this fact will be
     placed in the Aide> room.

        A room is killed by an Aide by being present in that room and execut-
     ing the .Aide Kill command.

     IV. 3.d Empty Room Deletion
        Aides may execute a command that deletes empty, temporary rooms from
     the system.  A message will be left in the Aide> room listing the rooms
     deleted by the command.

        The .Aide Delete command is used for this purpose.

     IV. 3.e Room Editing
        Aides may edit the rooms of a system, with the exception of the Mail>,
     Aide>, and #baseRoom rooms.  See Section Y ROOMS for more on these
     actions.  To edit a room, either <A>ide or .Aide Edit room will allow you
     to edit the room.  However, Aides may not set the full range of attributes
     associated with a room; Section Y should cover this in full.

     IV. 3.f Message Insertion
        An Aide may insert the last message deleted into a room.  The .Aide
     Insert message command allows this.

     IV. 3.g Floor Creation
        Aides may create floors at will.  New floors are placed in the first
     empty floor slot, and there is no arbitrary limit on the number of floors
     in a system.  Floor names may only be 19 characters in length, and each
     must be unique within the system of floor names.  Floors may not be
     created while in the Aide>, Mail>, or #baseRoom rooms, because the room
     that a floor is created in will automatically become a room on that floor.

        ;Aide Create-floor creates a floor.



                                    -10-






     IV. 3.h Room Moving
        Aides may move rooms from one floor to another, with the exception of
     the Aide>, Mail>, and #baseRoom rooms.  The Aide should be in a room that
     is on the floor that the rooms should be moved to.  Once the command is
     completed, a message will be placed in the Aide> room detailing what rooms
     have been moved where.

        The command is ;Aide Move-rooms.  The system will prompt for the names
     of rooms to be moved to the current floor.  Room names must be specified
     in full.

     IV. 3.i Floor renaming
        The ;Aide Rename-floor allows an Aide to rename a Floor.  The name must
     be unique amongst the floors.

     IV. 3.j Floor Killing
        Aides may delete Floors.  When this command is executed, the current
     floor is assumed to be the target; the #baseFloor floor may not be killed.
     The Aide will be asked if the rooms on the floor should be killed outright,
     or placed on the #baseFloor.

        The command is ;Aide Kill-floor.

     IV. 3.k Aide Command Summary

      .Aide Delete empty rooms
      .Aide Edit current room
      .Aide Insert pulled message
      .Aide Kill current room

      ;Aide Create floor
      ;Aide Delete empty floors
      ;Aide Kill floor
      ;Aide Move rooms to floor
      ;Aide Rename floor

     IV. 3.l Possible extra privileges
        Depending on the configuration of the system, Aides may have additional
     privileges that the users do not.

        First, Aides may be the only users able to create new rooms.

        Second, Aides may be the only users able to use the Mail> room.

     IV. 4 Sysops
        There are potentially two different Sysops.

        First, and always, there is the person at the system console.  Certain
     Sysop abilities can be executed without being logged in, notably the
     Sysop Menu functions (Section Y: SYSOP PRIVILEGED FUNCTIONS); the rest,
     what few are there, require that the Sysop be logged in.








                                    -11-






        Second, when the #sysPassword parameter is in use, an Aide in
     possession of the system password may use it to become a remote Sysop.
     A Remote Sysop has most of the capabilities of an Aide at the System
     Console, including access to the entire Sysop Menu, and complete control
     of room editing (see Section Y: ROOMS).

        The only other options available to a Sysop that are not available to
     Aides, outside of the Sysop Menu, follow.

     IV. 4.a Message Journaling
        Sysops may select individual messages to be placed in normal MS-DOS
     text files for future reference; this is called Journaling. This command
     is executed by <P>ausing the target message during output, and restarting
     it with a 'J'.  The system will then ask for the name of a file to place
     the text of the message in.  If the Journaling command has been used
     before, then an empty Carriage Return will cause the message to be
     appended to the last file specified.

     IV. 4.b Directory Journaling
        Sysops may Journal the directories of directory rooms.  The process is
     the same as Message Journaling.
                                             

     V. ROOMS

     V. I Room Attributes
        Rooms are the basic foundation of the Citadel-86 system, acting as the
     main organizer and container of the messages of the system; the collection
     of rooms of a Citadel-86 essentially constitutes the character of the
     system.

        Rooms on a Citadel-86 can have a number of attributes associated with
     them, each working independently, and most do not interfere with each
     other's usefulness.  With the exception of the first three rooms, there
     should not be any restriction on what rooms can have what attributes.  So
     let's discuss what a room can do, besides contain messages.

        In order to set any of these attributes, the room must be edited by
     an Aide.  If the Aide is accessing the system remotely and has not used
     the Remote Sysop Password, then the Aide's powers are restricted, while
     an Aide at the system console or a Remote Sysop's powers are not
     restricted.  In the following discussion, the option letter used to
     activate or deactivate an attribute is given along with the explanation
     of the feature.

     V. I. 1 Room Archival
        <A>rchive status, a Sysop-only option, allows the Sysop to save all the
     messages that are entered into a room, whether locally or via the network,
     to a normal MS-DOS text file (formatted for a 80 column user).  When this
     option is activated, the Sysop is asked for a filename that will contain
     the saved messages.  This file may reside anywhere on the system.  An
     initial archive of the room will take place, and thereafter all messages
     entered into this room will be saved to the file upon entry.






                                    -12-






        Messages that are deleted from the room will NOT be deleted from the
     archive file, and, similarly, messages that were entered in another room
     and subsequently moved to the archive room will not be saved to the
     archive file, except on initial archive.

     V. I. 1.a Room Archival: Advanced Usage
        Typically, the name (and/or location) of the archive file should be
     changed by editing the room.  However, the impatient or secretive Sysop
     can change the name of the archive file in another way.  The names of the
     files used for room archival are kept in the text file CTDLARCH.SYS, which
     resides in the #ROOMAREA directory.  CTDLARCH.SYS is generated and
     maintained by CTDL.EXE, and should not be disturbed while CTDL.EXE is in
     operation (i.e., through <O>utside commands).  When CTDL.EXE is down,
     however, the Sysop may edit CTDLARCH.SYS to his liking.  Adding entries
     will be ineffective; changing entries works.  The format is

        <room slot number> <file name>

     The room slot number should not be changed.  The filename, of course, may
     be changed.

        Do not delete entries from this file, either.

     V. I. 2 Backbones
        Please see NETWORK3.DOC for the use of the <B>ackbone status option.
     This is a Sysop only option.

     V. I. 3 Directory status
        Please see Section Y.y for details on the upload/download capabilities
     of Citadel-86 that are made available through the <D>irectory status
     option of room editing, a Sysop only option.

     V. I. 4 Innominate status
        The <I>nnominate option allows any aide to designate a room to be an
     Anonymous room.  A room which has been designated Innominate behaves
     differently from a normal room in the following ways:

       o All messages entered in it locally are saved with the author's name
     being "****".  Editing a room back to normal ("authored") status does NOT
     restore those messages' authors.

       o Echo to screen is suppressed during message entry in Innominate rooms.

     V. I. 5 Lure users
        Any aide may use the <L>ure users option to, in effect, invite any
     user into any room except the Aide room.  The user(s) specified are given
     access to the room being edited.  If they already had access, no change
     is made to their status.

     V. I. 6 Moderator
        Any room may have one moderator attached to it.  A moderator is
     effectively an Aide for that single room, able to edit the room and delete
     messages.  The user specified does not need any special privileges.  Any
     Aide may change the moderator setting for a room via the <M>oderator
     command.




                                    -13-





     V. I. 7 Name Change
        Any Aide may change the name of a room via the <N>ame change command
     while editing a room.  There are three constraints on the name of a room.

       o It must be 19 characters or less long.  A zero length name IS viable,
     but be aware that if the room ever becomes empty, there is no way to
     access that room.

       o It must be unique within the system.

       o It may have no more than one space in a row.

     V. I. 8 Only Invitational
        A room can be set to one of three status settings insofar that users
     are allowed access to it.  A room may be Public, in which case all users
     have access to the room.  If a room is Private, then all users that know
     the name of the room may gain access to the room simply by typing ".Goto
     FULLROOMNAME". (See Section X.I.9 for the Public/Private settings.)
     Or a room may be Invitational.  Users can only gain access to such a room
     by being invited (i.e., <L>ured -- see Section X.I.5).  Even if they know
     what the name of the room is, they cannot successfully .Goto it.

        A room can be either Public, Private, or Invitational, but not any
     combination.  It would perhaps be more logical to combine the <O>nly
     Invitational command (this one), with the following command, <P>rivacy
     status.

     V. I. 9 Privacy Status
        Any Aide may set the <P>rivacy status of a room.  Section X.I.8
     provides an adequate explanation of privacy and rooms.

     V. I. 10 Temporary Status
        Any Aide may set the <T>emporary status of a room.  Any room may be
     either Temporary or Permanent.  A Temporary room is a room that may be
     deleted by any of three events when it becomes empty (i.e., no messages
     in the room):

       o An Aide executes a .Aide Delete empty rooms command;

       o The number of rooms in use in the system reaches #MAXROOMS and another
     room is created;

       o The system is reconfigured (see Section ??? [installation manual] on
     the CONFG program).

        A Permanent room may only be deleted by a specific .Aide Kill Room
     command.

        All Directory rooms are Permanent.  Otherwise, if Permanent status is
     desired for any room, it must be explicitly set by use of the <T>emporary
     status command.









                                    -14-






     V. I. 11 Shared status
        The Sysop may use the <S>hared status command to affect the current
     room's Network status, including which systems to network with and which
     should not be networked with.  Please consult NETWORK3.DOC for more
     details.

     V. I. 12 Upload/Download status
        The Sysop may use the <U>/D status command to change the upload/down-
     load status of a directory room.  See Section Y.y for more details on 
     this command.

     V. I. 13 Withdraw Invitations
        On occasion, users need to be evicted from a room.  The <W>ithdraw
     Invitations command allows any Aide to evict users from a room.  This
     command is certainly not useful for Public rooms, and not entirely
     effective for private rooms, but can be very useful for Invitational
     rooms.

     V. I. 14 Network Downloadable
        The Sysop may use the <Z> command to designate whether or not a
     directory room may be accessed via the network for download purposes.
     See Section Y.y for more details on this command.

     V. II Other room editing commands
        There are two other commands that an Aide may use while editing rooms.
     The first is <V>alues, which gives the current positive attributes of the
     room.  The second is e<X>it editing, for exiting from the editing process.
     When substantive changes have been made to a room, a message is left in
     the Aide> room detailing the changes made.

     V. III Three exceptions
        Three rooms cannot be modified through editing (or any other process),
     and these rooms are

       o #baseRoom>.  This room is always a Public, Permanent room.

       o Mail>.  This room is a very special room, but essentially boils down
     to Public, Permanent, with some Shared capabilities.

       o Aide>.  This room is a Permanent, Invitational room, with Invitations
     automatically issued to Aides.

     VI. UPLOAD/DOWNLOAD CAPABILITIES

     VI. I Origin
        According to what rumors we have gathered from Seattle, the origin of
     Citadel, the original Citadel installations did not have any upload/down-
     load facilities; they were pure message systems.  Reportedly, "directory
     rooms" were kludged in at a later time as an afterthought.










                                    -15-






        They must be one of the more successful kludges in history.  Directory
     rooms, which serve as "windows" to the host operating system's file system
     in Citadel-86, have proven to be extremely useful constructs, allowing
     access to specified parts of MS-DOS's file system while not disrupting
     Citadel's structure with such excess baggage as "file sections".  The room
     structure allows easy division of files into their subject areas, and this
     integration into the room structure offers the additional, and very
     useful plus, of allowing conversation relevant to those files to coexist
     within easy reach of the user.  Compare this to, say, Fido or RBBS, which
     force you to go from a file section to a message section in order to
     discuss a file, and the advantages of Citadel (at least to this author)
     become obvious.


     VI. 2 Creation
        A directory room is created by editing an existing room to directory
     status.  This is an operation that only a Sysop can do, using the .Aide
     Edit command.  Once at the room edit prompt, the Sysop should select the
     <D>irectory option.

        Citadel-86 will ask if you wish to activate a directory for this room,
     and you should of course answer yes.  It will then ask for the name of a
     directory to associate with this directory room.  You should answer with
     the name of a normal MS-DOS directory.  You may specify a drive, and the
     directory may be a subdirectory of the current directory, or it may be
     an absolute specification; there is no limit.  If you simply hit a
     Carriage Return, Citadel-86 will assume that you mean the current
     directory on the current drive.

        If you specify a directory that does not exist, Citadel-86 will ask
     you if it should be created, and if you answer affirmatively, it will
     be created.  Otherwise, you will be asked again.

        Finally, the system will ask if the room will accept uploads and allow
     downloads (these options can be accessed while editing rooms separately
     by selecting the <U>/D option).  This gives you some control over the
     behavior of the directory room.  When either of these options are "off",
     only a sysop can upload or download or read the directory, depending on
     the option.

        A file room is identified by the character at the end of the room name.
     Normal rooms have a ">".  Normal directory rooms have a "]", while
     directory rooms which are also shared with other systems (which has no
     meaning insofar as the directory goes) have a ":".

     VI. 3 User commands
        The user is provided with two sets of commands for accessing the
     directory of a room.

     VI. 3.i Content listing
        When a listing of the files in a room is requested, only the visible
     files are listed.  Hidden files and subdirectories in the directory are
     not listed.






                                    -16-






        There are two commands for displaying a listing of the files accessible
     in a room.  The first command is

         .Read Directory <file-spec>

        If <file-spec> is empty, then all files are listed; otherwise, only 
     those files matching <file-spec> are listed.  For a full explanation of
     <file-spec>, see X.3.c.  Files are listed for the user as <name>
     <block size>, where block size is the size of the file in 128 byte blocks,
     which, not coincidentally, is the size of blocks used by XMODEM for file
     download.

        The second command is

         .Read Extended-directory <file-spec>

        which allows the user to see file descriptions "attached" to files.
        Files are listed in this format

     <name>  <size> | <description> <file date>

        which is formatted to the user's display.  Each file starts on a new
     line, thus providing a readable format.

        The descriptions for the files in a room are kept in a normal text file
     named FILEDIR.TXT, which must reside in that directory.  If the sysop
     wishes to create file descriptions for a set of files, the format of
     FILEDIR.TXT is simple, and it is

             <name><one or more spaces><description on one line>
             . . .

        FILEDIR.TXT must be in alphabetical order (case-insensitive) in order
     to function correctly.  The description may be no more than 7K long, and
     must reside on the same line as the name.

        The FILEDIR.TXT for any given directory room is updated by Citadel-86
     whenever a file is uploaded to that directory room, thus minimizing the
     maintenance chores of a Sysop with numerous directory rooms.

        Finally, if there is a file missing from FILEDIR.TXT (or if
     FILEDIR.TXT itself is missing), there is NOTHING to worry about.  There
     will simply be no file description displayed for the affected files.
     Further, excess entries in a FILEDIR.TXT does no harm to the listing
     (however, if you are fastidious you should research the Citadel-86 utility
     CULLDIR.EXE).

        The only weakpoint in FILEDIR.TXT is the fact that the entries must be
     in alphabetical order.  If they are not, file descriptions will not
     display at all.

     VI. 3. ii File transfers
        The second set of commands for accessing the directory of a room are
     those concerned with uploads and downloads.





                                    -17-






     VI. 3. ii. a Upload Protocols
        There are two protocols supported for the upload of files, XMODEM and
     YMODEM.  While this subject is covered in the FILES.HLP help file, we'll
     go over it here, too.

        The command format for uploading a file via XMODEM is

             .Enter File     or .Enter Xmodem File   or .Enter WC file

        The command format for uploading a file via YMODEM is

             .Enter Ymodem File

        After typing in any of these commands, Citadel-86 will prompt the user
     for the name of the new file.  If a file already exists by that name in
     the directory, the upload is aborted at this point; if the file name is
     not acceptable for any other reason (for instance, the name is special to
     DOS, such as CON:, or the user has attempted to specify a drive name),
     the upload is aborted.

        Once the filename is accepted, Citadel-86 will prompt for a description
     of the file.  If the subsequent upload is a success, the directory's
     FILEDIR.TXT is updated with the name and description of the new file.
     Citadel-86 will then ask if the user is ready to start the upload.  If the
     user responds negatively, the upload is aborted; otherwise, the chosen
     protocol starts in receive mode.

        YMODEM's BATCH mode is NOT supported for uploads by Citadel-86, for the
     reason that it would be very easy for a malicious user to abuse the system
     through the upload of numerous files.

     VI. 3. ii. b Download Protocols
        Three protocols are supported for downloads, XMODEM, YMODEM, and 
     straight text transfers, which is the default transfer protocol if neither
     XMODEM or YMODEM is specified (unlike the upload command, where XMODEM is
     the default).

        Command format is

             .Read [protocol] <Binaryfile|Textfile> [Formatted]

        XMODEM can be specified through both <X>modem and <W>C protocol (the
     latter may change, however, if WXMODEM is ever implemented).

        YMODEM is specified, of course, using <Y>modem.  When downloading
     files via YMODEM, only BATCH mode is available, even if only a single
     file is to be downloaded.

        The Binaryfile and Textfile specifications are synonyms, being a
     holdover from the CP/M days of Citadel.  However, the Formatted option
     can only be used with the Textfile option.  If a file is requested using
     the Formatted option, the file(s) requested (which Citadel-86 assumes to
     be normal MSDOS text files) will be formatted to the user's screen.
     Otherwise, the file is simply sent on a byte-by-byte basis to the user.





                                    -18-






        When an acceptable download command is entered, Citadel-86 will prompt
     for a filename from the user, which can be a <file-spec> (see X.3.iii).
     If more than one file matches <file-spec>, then all those files will be
     sent using the specified protocol.  In the case of XMODEM, this will
     probably be less than successful.

     VI. 3. iii <file-spec>
        A <file-spec> for Citadel-86 can range from being a single file (like
     "HELLO.TXT") to an ambiguous file specification in MSDOS format ("*.TXT"),
     to a list of files mixing both single file specifications and ambiguous
     file specifications.  For example,

             .Read Extended-directory *.DOC HELP.ME C*.HLP

     would display all the files that match any of those specifications.  Each
     part of the specification should be separated from the next by one or more
     spaces.

     VI. 4 Advanced Directory Options
        The listing of directory rooms and their associated MS-DOS
     specifications is kept in a normal MS-DOS text file named CTDLDIR.SYS,
     which resides in the #ROOMAREA directory.  While Citadel-86 automatically
     maintains this file at all times, not requiring any Sysop interference,
     the inquisitive Sysop can manipulate this file.

        The contents of this file is in this format

        <room #> <directory specification>

        The room # field should never be touched.  However, the second field
     can be changed when Citadel-86 is not up, thus changing the directory
     associated with the room specified by the room number.

        Really, though, there's not much reason to change this file manually.

     VII. OTHER COMMANDS MENU
 
     VII. 1 General Purpose
        The purpose of the Other Commands submenu of the Privileged Functions
     Sysop menu is to allow the Sysop access to commands that may be unique to
     the installation of Citadel in operation.

     VII. 2 Citadel-86 Other Commands
        Citadel-86 supports only two commands from this sub-menu -- a haphazard
     effort, indeed.

     VII. 2. a Deletion
        The <D>elete File option allows the sysop to delete any file in the
     MS-DOS file system.  Only a single file at a time may be deleted;
     ambiguous file names are not supported.









                                    -19-






     VII. 2. b Outside Commands
        The <O>utside Commands option allows the sysop to run programs from
     within Citadel-86 (but not concurrently).  Since it is sometimes
     inconvenient to take down Citadel-86 (e.g., from remote) in order to
     execute some utility or program, this option is, indeed, useful.

        When this option is selected, Citadel-86 will write a temporary
     CTDLTABL.SYS file (see INSTALL3.DOC, Section II.3.a) to disk, and then
     prompt you for a command line.  You may then attempt to run any program
     that you wish from the command line, simply as if you were running from
     the MS-DOS command level.

        The DOS shell is accessible at this point by simply typing a carriage
     return.  However, if you plan to use the DOS shell, you should observe
     two rules: always return to the current drive and directory (that is, the
     one that you find yourself in when you call the DOS shell) before typing
     the DOS EXIT command; and, second, avoid bringing up Citadel-86 again
     while you are in the shell.  While it's not fatal, and not necessarily
     damaging to do so, it can cause a lot of confusion if you do so.  (As if
     you weren't confused enough.)

     VII. 2. b. i Restrictions
        There are two actions that you should avoid taking while using the DOS
     shell from within Citadel-86.

        First, do not delete any of the Citadel-86 data files.  These are the
     *.SYS files, such as CTDLMSG.SYS, CTDLLOG.SYS, CTDLROOM.SYS, etc.
     However, you may delete or change the CALLLOG.SYS file (this was not true
     in earlier versions of Citadel-86).

        Second, do not run any of the Citadel-86 utilities which change the
     nature of the Citadel-86 data files.  These utilities include DATACHNG,
     RECOVER1, EXPAND, RECOVER2, etc.  You may run without fear those utilities
     which only show various things, like CLOG, CLRAY, etc.  In general, if you
     are not sure, either take your Citadel-86 down or experiment on a small
     test system.

     VIII. MISCELLANEOUS SUBJECTS
 
     VIII. 1 Wha....?
        Like anything that grows through accretion rather than planning,
     Citadel-86 has accumulated a clutch of features that don't really fit
     into any category.  So, rather than trying to create some categories
     that don't really fit into the great plan of Someone Out There, we
     decided to write a chapter with a central theme of mishmash that would
     contain all those features that don't really fit anywhere in particular.
     So, with no further shampoo ...

     VIII. 2 Chatty Questions
        When you drop into <C>hat mode to talk to a user, you will be faced
     with three questions before you're actually allowed to communicate with
     your victim.  These are the questions and the effects that your answers
     may cause:






                                    -20-






      Echo to Modem: This controls whether something received from the modem
     port should be echoed back to it.  You should usually answer Yes to this
     question when chatting with a user; if you use Chat Mode to call out
     manually, you should probably answer No, since otherwise you and the
     system that you call could get into a real nasty loop otherwise.

      Echo Keyboard: This controls whether what you type is echoed to the
     Console.  Answer Yes if you are chatting with a user; answer No if you
     are calling a system that will do echoing for you.

      Echo CR as CR/LF: This controls whether a CR should be translated into a
     CR/LF.  Yes is probably the correct answer when chatting with a user.
     When calling out using Chat, the answer may depend on the system that
     you are calling.

        Finally, you should know that when you call a system using the
     Network's <D>ialout command, the system drops you into Chat mode after
     dialing out.  You are not queried on the questions, however, in order to
     streamline operation; instead, all of the answers are No.

     VIII. 3 Chat Capture
        You, Chief High Sysop, have the ability to capture chats to disk if
     you choose to do so.  When you capture a chat, a warning will be printed
     to both you and the chattee saying that the chat is being captured; when
     you choose to stop capturing chat, another warning will be printed
     indicating that the session is no longer being captured.  In this way,
     you cannot successfully be accused of capturing chat sessions without
     warning.

        You turn on chat session during a chat by typing ^R (Control-R).  The
     system will then attempt to open a file named CHAT.TXT, and if it exists,
     the chat session should be appended to the end of that file.  If the file
     does not exist, it is created, and the resulting chat placed within.

        Typing a second ^R will result in the file being closed and the chat
     capture being turned off.  If you leave the chat session, the capture is
     automatically turned off at that point, and if you wish to continue
     capturing the chat (say, if you had to pop out for a moment and then
     returned), you must turn the capture back on again.

        By a chat session, we mean both a normal <C>hat, initiated by either
     you or a caller, and the chat sessions which are initiated by the <D>ial
     System command of the Network Menu, on which there should be more details
     in NETWORK3.DOC.

     VIII. 4 ESCaping Details of Chat Mode
        On rare, rare occasion it is necessary to send an ESC while in Chat
     mode.  Yet, Citadel-86 specifically tells you that an ESC let's you out
     of Chat!  How around this problem?

        By using the '\' key first.  When you do so, the system will pass the
     next key you press through without any interpretation, including the ESC
     key.  (If you need to send a '\', send two of them.)






                                    -21-






        And one more detail: when <C>hat is used, an ESC from either the
     caller or from the Sysop will cause the Chat session to end.  When
     <D>ialout is used, only the ESC from the system console will cause the
     system to end the Chat session.

     VIII. 5 Sysops Autodialing Themselves
        If your system becomes at all popular amongst the locals, you will
     rapidly find yourself in the position where you cannot get onto your
     machine whenever you like without committing foul and evil acts such as
     pulling the plugs out of modems and that sort of thing.  Since that tends
     to lead to bad reputations and negative karma, Citadel-86 gives the Sysop
     the ability to auto-dial him(or her)self; that is, you can tell the
     system, while someone else is on, that you are next in line to use the
     system. (aka "pulling rank".)

        To do so, simply type ^T (Control-T) while the person using the system
     is on.  The next time that the system looks at the keyboard (which is
     during <P>auses of output and other moments of the system waiting for
     input from the user) it will note that the ^T has been pressed and
     (usually) print out an acknowledgement to the system console only (the
     user will not be aware that you are anywhere near ground zero).  The
     status bar, which we'll discuss sometime along the way here, if you
     are using it, will also show that your ^T has been pushed.

        When the foul user logs out of the system, the system should
     immediately start beeping at you, once every ten seconds.  If you then
     hit anything on the keyboard, you get control of the system.  After
     2 minutes of beeping, the system will return its attention to the modem.

        If you type ^T twice while the user is on, this feature will be
     cancelled.

        If you type ^T when no one is on the system, the system will go into
     CONSOLE mode.


     VIII. 6 Denizens of the Status Bar
        Citadel-86 has a status bar.  This status bar gives you a vague idea
     of what's going on with the system, using various special messages during
     system initialization, and then a hint now and then about who's on.  The
     location of the status bar depends on the machine that Citadel-86 is
     running on.  If it is a PC Clone, it occupies the second line from the
     top of the screen.  If it is a Zenith Z-100, it occupies the 25th line of
     the screen.















                                    -22-






        The status bar should always have

        " Citadel-86 Vx.xx: "

     showing.  What shows up after that depends on the state of the system.
     Special messages appear right after it, but they only show up when the
     system is coming up.  Here's a generic representation of the status bar
     when the system is in normal mode:

     "Citadel-86 Vx.xx:<name of user><time of carrier>[<Chat sig>][<^T sig>]"

        "Chat sig" is a capital "C", and only shows up when you have Chat mode
     on.  ^T sig is a "^T", and only shows up when you are next in line to use
     the system.

     VIII. 7 Modem disabling
        You may have noticed that when you took control of the system by
     pressing ESC, the DTR light on your modem went out.  Or you may not have
     noticed.  But it did, or should have.  This leads to that age-old
     philosophical question, "When does this happen?"  Well, DTR comes down
     (or, more generally, the modem is disabled) when the Sysop takes control
     of the system and there is no carrier.  If there is carrier, then
     connection is maintained, even when coming out of the Chat mode initiated
     by the <D>ialout.
                                                              
          
     IX. QUESTIONS & ANSWERS


     ---
      Q. I'm completely lost, even after going through all of the below; what
     do I do next?

      A. Call your local (hopefully!) friendly C-86 Sysop.  For the most part,
     they're helpful, friendly people who are more than happy to help a new
     system get its feet under itself.

     ---
      Q. How do I create a "directory" room?

      A. Edit the room.

     ---
      Q. The system complains that it can't find CTDLBAD.SYS.

      A. There are two possibilities.  Either the file isn't there, or you
     currently do not have sufficient free RAM available.  Apparently, 192K
     RAM is no longer sufficient to run Citadel, so if you're running RAM
     disks or resident utilities that take up room, you may have to take one
     (or more) out to successfully bring Citadel up.









                                    -23-






     ---
      Q. When I try to bring the system up, it will come up momentarily but
     will then immediately give a crash message.  What happened?

      A. The first step is to look at the files on disk.  If there is a file
     called CRASH, it was created by, so look at it (this is a good General
     first step for most problems, too).  Within, there will be a fairly
     cryptic message which is more for debugging purposes, but can be useful
     to the new sysop, too.  If it indicates some sort of displeasure with the
     CALLLOG.SYS file, this is usually a good pointer to the possibility that
     you haven't configured MSDOS correctly in the FILES= area.  Check to make
     sure that your CONFIG.SYS file has the required FILES=20 line in it, and,
     if you had to put it in for Citadel, make sure that you have rebooted
     your system after adding it to the file.

      If there are still problems, then another observation is that an
     abnormally high BUFFERS= setting in CONFIG.SYS on systems that don't have
     a great deal of extra free RAM available will sometimes "steal" from the
     FILES= setting.  So, it's worth trying setting your BUFFERS= a little
     lower.

     ---
      Q. I try to use the <O>utside command in the <O>ther commands section of
     the Sysop Menu, but Citadel just says "Bad Return value".  What's wrong?

      A. In all probability, you don't have enough free RAM.  Use CHKDSK or
     some other utility to find out how much free RAM you have.


        Please submit other pertinent questions to Hue, Jr. at C-86 Test
     System for inclusion in this manual.




























                                    -24-



