--************************************************************************
--
--  SERVER.ADA
--
--  A copyright-reserved, free use program.
--  (c)John H. McCoy, 1993, Sam Houston St. Univ., TX 77341-2206
--************************************************************************

-- bamp with -m 38000 -s 27500 -G

with Types; use Types;
with NetBios; use NetBios;
with Drivers; use Drivers;
with ServerTasks;
with text_io; use text_io;
with system;

procedure Server is

NCB            : NetBiosCmdBlks;
ServerName     : string16 := (others => ' ');
DriverName     : string8  := (others => ' ');
DriverHandle   : integer;
DriverStrategy : system.address;
DriverInterrupt: system.address;
DriverSubUnits : byte;

NET            : ServerTasks.NetAccess := new ServerTasks.Nets;
HUB            : ServerTasks.SchedulerAccess := new ServerTasks.Schedulers;

MaxSessions    : constant := 32;
SessionTable   : array (1..MaxSessions ) of ServerTasks.SessionsAccess;
CD             : ServerTasks.CDAccess;
CBLock         : IoCB_Lock;

rh             : rhs;
pkt            : pkts;
buf            : rhXs := (DeviceIoctlOutput,
                         (Status        => DeviceDone,
                          reserved      => (others =>0),
                          MediaDesc     => 0,
                          CBPtr         => SA_to_DW(CBLock'address),
                          TransferCount => word_to_W(2),
                          Start         => word_to_W(0),
                          VolIdPtr      => SA_to_DW(0) ));

begin

ServerName(1..14)  := "SHSU-CD-SERVER";
DriverName(1..5)  := "CD001";

ServerTasks.Console.Init(MaxSessions => MaxSessions);

OpenDevice ( DeviceName => DriverName,
             Handle     => DriverHandle);

GetDeviceEntryAddresses (Handle           => DriverHandle,
                         DeviceStrategy   => DriverStrategy,
                         DeviceInterrupt  => DriverInterrupt,
                         SubUnits         => DriverSubUnits );

for i in 0..DriverSubUnits-1 loop

   -- lock drive door
   rh := ( Length  => 26,
           SubUnit => i,
           rhX     => buf);

   pkt := Rhs_to_Pkts(rh);
   pkt(3..pkts'last-1) := pkt(4..pkts'last);

   CallDriver (rh              => pkt(1)'address,
               DeviceStrategy  => DriverStrategy,
               DeviceInterrupt => DriverInterrupt);
   pkt(4..pkts'last) := pkt(3..pkts'last-1);
   pkt(3)    := 0;
   rh        := Pkts_to_Rhs(pkt);
end loop;

   CD := new  ServerTasks.CDRoms;
   CD.Init(DeviceStrategy   => DriverStrategy,
           DeviceInterrupt  => DriverInterrupt);

NET.Start(ServerName);

for i in 1..MaxSessions loop
    SessionTable(i) := new ServerTasks.Sessions;
    SessionTable(i).Start(Net,ServerName,CD,DriverSubUnits,HUB);
end loop;

new_line;
put("Server "); put(ServerName);put_line(" started.");
put(integer'image(MaxSessions));put_line(" sessions queues.");
put("Using CD driver "); put_line(DriverName);

exception
  when DEV_Error            => Put_line("Error Opening CD Driver");
  when DEV_NameError        => Put_line("CD Driver Name Error");
  when DEV_IOCtlError       => Put_line("CD Driver IOCtl Error");
  when NBX_NetBiosNotLoaded => Put_line("Net BIOS not loaded.");
  when NBX_NameAlreadyclaimed => Put_line("Name already in use.");
  when NBX_GeneralError     => Put("Error attempting to start ");
                               Put_line(ServerName);
  when others               => Put_line("Error starting server");

end Server;