/*---------------------------------------------------------------------------*
 |			   TEGL Windows ToolKit II			     |
 |		  Copyright (C) 1990, TEGL Systems Corporation		     |
 |			    All Rights Reserved.			     |
 *---------------------------------------------------------------------------*/
/* teglcond.h					      */
/* conditional defines and compatability defines      */

/* only define one of these for the compiler */
#define TURBOC
/* #define QUICKC */

#ifdef TURBOC
#ifdef QUICKC
#error Can only define one compiler.
#endif
#endif

#ifndef TURBOC
#ifndef QUICKC
#error No compiler defined.
#endif
#endif

/* #define TRACE */
#ifdef TRACE
#define trace(fmt,itm)	 printf(fmt,itm); getch()
#else
#define trace(fmt,itm)
#endif


/* define to build the demonstrator version of the library */

#define TEGLDEMO


/* define if the virtual memory manager is NOT to be used  */

/* #define NOVIRT */

/* define if the graphics libraries from TURBO C or QUICK C are */
/* not to be used. */

/* #define NOGR */

/* common defines */

#define MK_FP(seg,ofs)	((void far *) \
			   (((unsigned long)(seg) << 16) | (unsigned)(ofs)))

#ifdef QUICKC

#define random( max ) ((rand() % (int)((max) - (0))) + (0) + 1)
#define poke(a,b,c)  (*((int far*) MK_FP((a),(b))) = (int) (c))

#define sound( n )
#define nosound()
#define delay( n )
/* TURBO C's and QUICK C's dos.h are largely compatible */
/* just a few name changes are required.  */

#define time  dostime_t
#define gettime  _dos_gettime
#define ti_sec	 second

#define dfree  diskfree_t
#define df_avail  avail_clusters
#define df_total  total_clusters
#define df_bsec   bytes_per_sector
#define df_sclus  sectors_per_cluster
#define findnext  _dos_findnext

#define WILDCARDS 0x01
#define EXTENSION 0x02
#define FILENAME  0x04
#define DIRECTORY 0x08
#define DRIVE	  0x10

#define MAXPATH   80
#define MAXDRIVE  3
#define MAXDIR	  66
#define MAXFILE   9
#define MAXEXT	  5

#define FA_RDONLY	0x01		/* Read only attribute */
#define FA_HIDDEN	0x02		/* Hidden file */
#define FA_SYSTEM	0x04		/* System file */
#define FA_LABEL	0x08		/* Volume label */
#define FA_DIREC	0x10		/* Directory */
#define FA_ARCH 	0x20		/* Archive */

#endif

#ifndef FALSE
#define FALSE 0
#define TRUE  1
#endif


#ifdef QUICKC
#ifndef NOGR
#define MSGRAPH
#endif
#endif

/* make sure demo defines are correct */

#ifdef TEGLDEMO

#ifndef NOVIRT
#define NOVIRT
#endif

#ifdef TURBOC
#ifdef NOGR
#undef NOGR
#endif
#endif

#endif
/* extendc.c */

extern char *fexpand (char *ipath);

extern void dos_getpath(unsigned char drive, char far *pathname);

extern int appendwildcards(char *FilePath);


/*  fastgrph.c */

#define A_ "\xc1"
#define B_ "\xc2"
#define C_ "\xc3"
#define D_ "\xc4"
#define E_ "\xc5"
#define F_ "\xc6"
#define G_ "\xc7"
#define H_ "\xc8"
#define I_ "\xc9"
#define J_ "\xca"
#define K_ "\xcb"
#define L_ "\xcc"
#define M_ "\xcd"
#define N_ "\xce"
#define O_ "\xcf"
#define P_ "\xd0"
#define Q_ "\xd1"
#define R_ "\xd2"
#define S_ "\xd3"
#define T_ "\xd4"
#define U_ "\xd5"
#define V_ "\xd6"
#define W_ "\xd7"
#define X_ "\xd8"
#define Y_ "\xd9"
#define Z_ "\xda"


typedef void (far *vmode)(void);

typedef unsigned masktype[2][16];

typedef void (*fontptr)();

typedef struct vidid {
	 unsigned char  video0type;
	 unsigned char  display0type;

	 unsigned char  video1type;
	 unsigned char  display1type;
} vidid;

#define FGNORM	0x00
#define FGAND	0x08
#define FGOR	0x10
#define FGXOR	0x18
#define FGNOT	0x80

#define TG_MDA		   0x01
#define TG_CGA		   0x02
#define TG_EGA		   0x03
#define TG_MCGA 	   0x04
#define TG_VGA		   0x05
#define TG_HGC		   0x80
#define TG_HGCPLUS	   0x81
#define TG_INCOLOR	   0x82

#define TG_MDADISPLAY	   0x01
#define TG_CGADISPLAY	   0x02
#define TG_EGACOLORDISPLAY 0x03
#define TG_PS2MONODISPLAY  0x04
#define TG_PS2COLORDISPLAY 0x05

extern unsigned jagged;
extern unsigned rmwbits;
extern unsigned activepage;
extern unsigned mousecolor;
extern unsigned mousehotspot_xofs;
extern unsigned mousehotspot_yofs;
extern unsigned teglfillmask;

extern char videochoicescga640x200x2;
extern char videochoicesega640x350x16;
extern char videochoicesvga640x480x16;
extern char videochoicesherc720x348x2;
extern unsigned char propagatedpixel[16];
extern char proportionalfont;
extern int initdrivercode;

typedef unsigned far (*teglgrfunc01)(unsigned,unsigned);
typedef unsigned far (*teglgrfunc02)(unsigned,unsigned,void*);
typedef unsigned long far (*teglgrfunc03)(unsigned,unsigned,unsigned,unsigned);

typedef void far (*teglgrproc01)(unsigned,unsigned,unsigned,unsigned,unsigned);
typedef void far (*teglgrproc02)(unsigned,unsigned,unsigned);
typedef void far (*teglgrproc03)(unsigned,unsigned,void*,unsigned);
typedef void far (*teglgrproc04)(unsigned,unsigned,unsigned,unsigned,void*);
typedef void far (*teglgrproc05)(unsigned,unsigned,unsigned,unsigned,void*,void*);
typedef void far (*teglgrproc06)(unsigned,unsigned,void*,void*);
typedef void far (*teglgrproc07)(unsigned,unsigned,unsigned,unsigned);
typedef void far (*teglgrproc08)(void);
typedef void far (*teglgrproc09)(unsigned,unsigned);

extern teglgrfunc01 getpixs;
extern teglgrfunc02 extractpixs;
extern teglgrfunc03 bigimagesize;
extern teglgrproc01 fastline;
extern teglgrproc02 putpixs;
extern teglgrproc03 putbiti;
extern teglgrproc04 getbiti;
extern teglgrproc05 extractimg;
extern teglgrproc06 overlayimg;
extern teglgrproc07 teglwrtchar;
extern teglgrproc08 mcursoroff;
extern teglgrproc09 mcursoron;
extern teglgrproc09 msetpos;

/*
extern unsigned getpixs(unsigned x, unsigned y);
extern unsigned extractpixs(unsigned x, unsigned y, void * buffer);
extern unsigned long bigimagesize(unsigned x,unsigned y,unsigned x1,unsigned y1);
extern void fastline(unsigned x, unsigned y, unsigned x1, unsigned y2, unsigned n);
extern void putpixs(unsigned x, unsigned y, unsigned n);
extern void putbiti(unsigned x, unsigned y, void * buffer, unsigned rmwbits);
extern void getbiti(unsigned x, unsigned y, unsigned x1, unsigned y1, void * buffer);
extern void extractimg(unsigned x, unsigned y, unsigned x1, unsigned y1, void * buff1, void * buff2);
extern void overlayimg(unsigned x, unsigned y, void * buff1, void * buff2);
extern void teglwrtchar(int c,int x,int y,int color);
extern void mcursoroff(void);
extern void mcursoron(unsigned xpos,unsigned ypos);
extern void msetpos(unsigned xpos,unsigned ypos);
*/

extern void putpict(unsigned x, unsigned y, unsigned char *buf, unsigned n);

extern void pictsize(unsigned * w, unsigned * h, unsigned char *buf);

extern void swapbytes(void * buff1, void * buff2, long bytestoswap);

extern int teglcharwidth(int  c);

extern int teglcharheight(void);

extern void videoid(vidid far * v);


extern int tegltextwidth(char * mystr);

extern void outtegltextxy(int x,int y,char *mystr);

extern void fmttegltextxy(int x, int y, char *format,...);

#define setproportional(onoff) proportionalfont = onoff

#define setteglfont(f) fonttable = f


extern void xorcornerbox(int x, int y, int x1, int y1, int color);

extern void xorbox(int x, int y, int x1, int y1, int color);

extern void flipapage(void);

extern void flipvpage(void);

extern void setapage(unsigned pagenum);

extern void setvpage(unsigned pagenum);

extern unsigned videopage(void);

extern void abort_msg(char * msg);


extern void ega640x350x16(void);

extern void vga640x480x16(void);

extern void herc720x348x2(void);

extern void cga640x200x2(void);

extern void videoautodetect(void);

extern char * videomodestring(char vtype, char dtype);

extern void setvideochoices(unsigned v, char accept);


extern fontptr fonttable;

extern unsigned evgagetpixs(unsigned x,unsigned y);
extern unsigned evgaextractpixs(unsigned x,unsigned y,void * buffer);
extern unsigned long evgaimagesize(unsigned x,unsigned y,unsigned x1,unsigned y1);
extern void evgafastline(unsigned x,unsigned y,unsigned x1,unsigned y2,unsigned n);
extern void evgaputpixs(unsigned x,unsigned y,unsigned n);
extern void evgaputbiti(unsigned x,unsigned y,void * buffer,unsigned rmwbits);
extern void evgagetbiti(unsigned x,unsigned y,unsigned x1,unsigned y1,void * buffer);
extern void evgaextractimg(unsigned x,unsigned y,unsigned x1,unsigned y1,void * buff1,void * buff2);
extern void evgaoverlayimg(unsigned x,unsigned y,void * buff1,void * buff2);
extern void evgawrtchar(unsigned c,unsigned x,unsigned y,unsigned color);
extern void evgamcursoroff(void);
extern void evgamcursoron(unsigned xpos,unsigned ypos);
extern void evgamsetpos(unsigned xpos,unsigned ypos);

extern unsigned hercgetpixs(unsigned x,unsigned y);
extern unsigned hercextractpixs(unsigned x,unsigned y,void * buffer);
extern unsigned long hercimagesize(unsigned x,unsigned y,unsigned x1,unsigned y1);
extern void hercfastline(unsigned x,unsigned y,unsigned x1,unsigned y2,unsigned n);
extern void hercputpixs(unsigned x,unsigned y,unsigned n);
extern void hercputbiti(unsigned x,unsigned y,void * buffer,unsigned rmwbits);
extern void hercgetbiti(unsigned x,unsigned y,unsigned x1,unsigned y1,void * buffer);
extern void hercextractimg(unsigned x,unsigned y,unsigned x1,unsigned y1,void * buff1,void * buff2);
extern void hercoverlayimg(unsigned x,unsigned y,void * buff1,void * buff2);
extern void hercwrtchar(unsigned c,unsigned x,unsigned y,unsigned color);
extern void hercmcursoroff(void);
extern void hercmcursoron(unsigned xpos,unsigned ypos);
extern void hercmsetpos(unsigned xpos,unsigned ypos);

extern unsigned cgagetpixs(unsigned x,unsigned y);
extern unsigned cgaextractpixs(unsigned x,unsigned y,void * buffer);
extern unsigned long cgaimagesize(unsigned x,unsigned y,unsigned x1,unsigned y1);
extern void cgafastline(unsigned x,unsigned y,unsigned x1,unsigned y2,unsigned n);
extern void cgaputpixs(unsigned x,unsigned y,unsigned n);
extern void cgaputbiti(unsigned x,unsigned y,void * buffer,unsigned rmwbits);
extern void cgagetbiti(unsigned x,unsigned y,unsigned x1,unsigned y1,void * buffer);
extern void cgaextractimg(unsigned x,unsigned y,unsigned x1,unsigned y1,void * buff1,void * buff2);
extern void cgaoverlayimg(unsigned x,unsigned y,void * buff1,void * buff2);
extern void cgawrtchar(unsigned c,unsigned x,unsigned y,unsigned color);
extern void cgamcursoroff(void);
extern void cgamcursoron(unsigned xpos,unsigned ypos);
extern void cgamsetpos(unsigned xpos,unsigned ypos);

extern void  font09(void);
extern void  font07(void);
extern void  font14(void);
extern void  oenglish(void);
extern void  pc24(void);
extern void  future(void);
extern void  pc9(void);

#ifndef TEGLDEMO
extern void  countdwn(void);
extern void  script(void);
extern void  ocr(void);
extern void  fraktur(void);
extern void  italic(void);
extern void  georgian(void);
extern void  apls7(void);
extern void  gaelic(void);
extern void  litalic(void);
extern void  pc3270(void);
extern void  m3270(void);
extern void  ega09(void);
extern void  broadway(void);
extern void  script2(void);
extern void  lcdfont(void);
extern void  light14(void);
extern void  brdwx19(void);
extern void  sansx19(void);
extern void  wndwx19(void);
extern void  light9(void);
#endif

/* virtmem.c */

#define MK_FP(seg,ofs)	((void far *) \
			   (((unsigned long)(seg) << 16) | (unsigned)(ofs)))

typedef int	(*allocerror) (unsigned long heapsize);

typedef struct freelistrec *freelistptr;
typedef struct freelistrec {
	void far       *orgptr;
	void far       *endptr;
}		freelistrec;

#define ORGPTR_FP(fp) ((freelistptr) (fp))->orgptr

#define ENDPTR_FP(fp) ((freelistptr) (fp))->endptr


typedef struct ofsseg *segofs;
typedef struct ofsseg {
	unsigned	offset;
	unsigned	segment;
}		ofsseg;

#define OFFSET_FP(fp) ((segofs) &(fp))->offset

#define SEGMENT_FP(fp) ((segofs) &(fp))->segment

#define NORM_FP(fp)  MK_FP(SEGMENT_FP(fp)+(OFFSET_FP(fp) >> 4),(OFFSET_FP(fp) & 0x000F))

#define LINEAR_FP(fp) ((unsigned long) SEGMENT_FP(fp)<<4) + ((unsigned long) OFFSET_FP(fp))

#define POINTER_FP(fp) MK_FP( (unsigned)((fp) >> 4),(unsigned)((fp) & 0x000F))

#define PTRDIFF_FP(fp1,fp2) ((unsigned long) LINEAR_FP(fp1)) - ((unsigned long) LINEAR_FP(fp2))

extern void far       *freeptr;
extern void far       *heaporg;
extern void far       *heapptr;
extern unsigned        freemin;
extern unsigned long   hugemin;
extern allocerror      hugeheaperror;
extern unsigned long   heapmemmax;
extern char	       heapmeminit;

#define reservehugeminimum(minsize) hugemin = minsize

#define setheapmemmaxsize(maxsize) heapmemmax = maxsize

extern char initheap(void);

extern void far * cgetmem(unsigned long heapsize);

extern unsigned long reservedmemavail(void);

extern unsigned long reservedmaxavail(void);

extern unsigned long cmaxavail(void);

extern unsigned long cmemavail(void);

extern void far * fgetmem(unsigned long heapsize);

extern void cfreemem(void far * freeorgptr,unsigned long heapsize);


typedef struct emsblock *emsblockptr;
typedef struct emsfilerec *emsfile;

typedef struct emsblock {
	emsblockptr	nextblockptr;
	unsigned	handle; /* Multiple handles */
	unsigned	emspage;/* Pages allocated */
}		emsblock;

typedef struct emsfilerec {
	unsigned	pageoffset;	/* current offset within page */
	unsigned	baseaddress;
	unsigned long	emsposition;
	unsigned	totalpages;	/* Total number of 16k pages */
	emsblockptr	rootblkptr;
}		emsfilerec;

#ifndef NOVIRT

extern unsigned ems_status;

#define virtsound(yesno) virtualsound = yesno

#define useharddisk(yesno) triedems = yesno

#define setvirtdskemsmax(maxsize) virtdskemsinitpages = maxsize

typedef void	(*errorproc) (int errcode);

typedef char	signate[5];

typedef struct vdskfreerecord *vdskfreeptr;
typedef struct vdskfilerecord *vdskfile;

typedef struct vdskfreerecord {
	vdskfreeptr	nextvdskfree;
	unsigned long	startblock;
	unsigned long	endblock;
	signate 	signature;
	char		blockfree;
}		vdskfreerecord;

typedef struct vdskblocksizerecord {
	unsigned long	bsize;
	unsigned long	realsize;
	signate 	signature;
	char		blockfree;
	unsigned	chksum;
}		vdskblocksizerecord;


typedef struct vdskfilerecord {
	vdskfreeptr	vdskfreeptrchain;
	unsigned long	vdsktopoffile;
	unsigned	vdskattribute;
	unsigned long	vdskpacketsave;
	char	       *vdskfilename;
	char		emstype;/* Selector */
	union v {
		int		vdskheapfile;
		emsfile 	vemsheapfile;
	}		v;
}		vdskfilerecord;

/*$$$*/
/*
enum { vdskreadwrite = 1};
enum { vdsktemporary = 2};
*/
#define vdskreadwrite  1
#define vdsktemporary  2

extern unsigned vdskstatus;
extern errorproc vdskerror;
extern char virtualsound;


extern char emminstalled(void);

extern unsigned emspagesavailable(unsigned * total_ems_pages,unsigned * pages_available);

extern unsigned allocateexpandedmemorypages(unsigned pages_needed,unsigned * handle);

extern unsigned mapexpandedmemorypages(unsigned handle,unsigned logical_page,unsigned physical_page);

extern unsigned getpageframebaseaddress(unsigned * page_frame_address);

extern unsigned deallocateexpandedmemorypages(unsigned handle);

extern unsigned getversionnumber(char * version_string);

extern unsigned gethandlecountused(unsigned * numberofhandles);

extern unsigned getpagesownedbyhandle(unsigned handle,unsigned * pagesowned);

extern unsigned virtdskemsinitpages;

extern char triedems;

extern emsfile emsopen(unsigned minimumpages);

extern void emsseek(emsfile emsramfile,unsigned long position);

extern void emsblockwrite(emsfile emsramfile,char *buffer,unsigned long bytestowrite);

extern void emsblockread(emsfile emsramfile,char *buffer,unsigned long bytestoread);

extern void emsclose(emsfile emsramfile);

extern errorproc virtualerror;

extern void movefromvirtual(char far * dataptr,unsigned long virtualheapptr);

extern unsigned long movetovirtual(char far * dataptr,unsigned long heapsize);

extern void freevirtual(unsigned long virtualheapptr);

extern unsigned long vdskgetmem(vdskfile vdskpacket,unsigned long heapsize,char *signature);

extern void vdskfreemem(vdskfile vdskpacket,unsigned long vdskheapptr);

extern void vdskwriteheapdata(vdskfile vdskpacket,char far * dataptr,unsigned long vdskheapptr);

extern void vdskreadheapdata(vdskfile vdskpacket,char far * dataptr,unsigned long vdskheapptr);

extern void vdskcloseheapfile(vdskfile vdskpacket);

extern vdskfile vdskopenheapfile(char *vdskfilename,unsigned vdskattribute);

extern vdskfile vemsopenheapfile(int initialalloc);

extern unsigned long virtualmemused(void);

#endif	/* NOVIRT */
/*  teglintr.c */

typedef char (far *keybrdcallproc)(void);

typedef struct keyflags *keyrecptr;
typedef struct keyflags {
	 keyrecptr    nextkeyflag;
	 char	      repeatkey;
	 unsigned     keycode;
	 keybrdcallproc keycall;
} keyflags;

typedef struct timeflags *timerecptr;
typedef struct timeflags {
	  timerecptr  nexttimeflag;
	  unsigned    timercount;
	  unsigned    timerstart;
	  char	      timerflag;
} timeflags;

#define sk_rightshift  0x01
#define sk_leftshift   0x02
#define sk_ctrlshift   0x04
#define sk_altshift    0x08
#define sk_scrolllock  0x10
#define sk_numlock     0x20
#define sk_capslock    0x40
#define sk_inslock     0x80
#define bios_data      0x40

extern	char scancodetable[127];
extern	char controlbreakflag;
extern	char kbmousebusy;
extern	unsigned char far *kb_flag;
extern	unsigned mouse_event;
extern	int mouse_xcoord;
extern	int mouse_ycoord;
extern	char mouse_installed;
extern	char mouseshow;
extern	unsigned mouse_buttons;
extern	masktype mousemask;

extern	unsigned leftbuttonpress;
extern	unsigned leftpressxcoord;
extern	unsigned leftpressycoord;
extern	unsigned leftbuttonrelease;
extern	unsigned leftreleasexcoord;
extern	unsigned leftreleaseycoord;

extern	unsigned rightbuttonpress;
extern	unsigned rightpressxcoord;
extern	unsigned rightpressycoord;

extern	unsigned rightbuttonrelease;
extern	unsigned rightreleasexcoord;
extern	unsigned rightreleaseycoord;

extern masktype pointinghand;
extern masktype hourglass;
extern masktype standard;
extern masktype diagcross;
extern masktype checkmark;

/*------------------------------------------------------------------------*
 |  Mouse Cursor Routines						  |
 *------------------------------------------------------------------------*/

extern void resetkeyboard(void);

extern void setmousesensitivity(unsigned x_sense,unsigned y_sense,unsigned threshold);

extern void getmousesensitivity(unsigned *x_sense,unsigned *y_sense,unsigned *threshold);

extern void showmouse(void);

extern void hidemouse(void);

extern void setmouseposition(unsigned mousex,unsigned mousey);

extern void setmousepos(unsigned xpos,unsigned ypos);

extern void cursorshape(masktype shape);

extern unsigned mouseposition(unsigned *mousex,unsigned *mousey);

extern void setmousehotspot(unsigned x,unsigned y);

extern void setmousecolor(unsigned color);

extern void setkeyboardmouse(char on_off);

extern void setkbsteps(unsigned xsteps,unsigned ysteps,unsigned sfxsteps,unsigned sfysteps);

extern void getkbsteps(unsigned *xsteps,unsigned *ysteps,unsigned *sfxsteps,unsigned *sfysteps);

extern void getbuttonreleaseinfo(unsigned button,unsigned *buttonstat,
		  unsigned *buttonrelease,unsigned *xpos,unsigned *ypos);

extern void getbuttonpressinfo(unsigned button,unsigned *buttonstat,
		  unsigned *buttonpresses,unsigned *xpos,unsigned *ypos);

extern void clearbuttoninfo(void);

extern void swaptimerout(void);

extern void swaptimerin(void);

extern void settimerstart(timerecptr *timepiece,unsigned timeset);

extern void resettimerflag(timerecptr timepiece);

extern void droptimercount(timerecptr timepiece);

extern void timerswitch(char onoff);

extern void swapteglintroff(void);

extern void swapteglintron(void);

extern void setmouseminmax(unsigned minx,unsigned miny,unsigned maxx,unsigned maxy);

extern unsigned teglreadkey(void);

extern char teglkeypressed(void);

extern void addcapturekey(unsigned keycode,char repeatkey,keybrdcallproc keycall);

extern void deletecapturekey(unsigned keycode);

extern unsigned key(unsigned char shiftbits,unsigned char keycode);

extern char nilkeycallproc(void);

extern void setshiftkeys(unsigned char shiftflag,char onoff);

extern void frozenmouse(void);

extern char freezemouse(unsigned x,unsigned y,unsigned x1,unsigned y1);

extern void unfreezemouse(char mshow);

extern void init_teglintr(void);

extern unsigned initmouse(void);

extern void mousereset(void);

/*  teglunit.c */

#define MSSENSE   TRUE
#define MSCLICK   FALSE

typedef struct timetickstk far *timetickptr;
typedef struct keyclickstk far *keyclickptr;
typedef struct msclickstk far  *msclickptr;
typedef struct imagestack far *imagestkptr;

typedef unsigned far (*callproc)(imagestkptr,msclickptr);

typedef struct xyx1y1rec {
		  unsigned x,y,x1,y1;
	     } xyx1y1rec;

typedef struct timetickstk {
		  timetickptr  nexttimetick;
		  timerecptr   timepiece;
		  callproc     entrycallproc;
		  imagestkptr  fs;
		  msclickptr   ms;
	     } timetickstk;

typedef struct keyclickstk {
		  keyclickptr  nextkeyclick;
		  unsigned     keycode;
		  callproc     entrycallproc;
		  imagestkptr  fs;
		  msclickptr   ms;
	     } keyclickstk;

typedef struct msclickstk {
		  msclickptr   nextmsclick;
		  unsigned     clicknumber;
		  xyx1y1rec    ms;
		  char	       msactive;
		  callproc     entrycallproc;
		  char	       senseactivate;
	     } msclickstk;

typedef struct imagestack {
		  imagestkptr  nxtptr;
		  imagestkptr  lstptr;
		  unsigned     signature;
		  char	       prepareupdate;
		  unsigned     preparecount;
		  char	       mouseshow;
		  unsigned     frameactive;
		  unsigned     x,y,x1,y1;
		  long	       imagesize;
		  void *       imagesave;
		  char	       imagelock;
		  char	       imageinuse;
		  char	       imagepageout;
		  long	       imagepageptr;
		  char	       movable;
		  callproc     movecallproc;
		  xyx1y1rec    restrictmovef;
		  xyx1y1rec    minmaxstretch;
		  callproc     resizecallproc;
		  imagestkptr  partialstack;
		  char	       imageactive;
		  imagestkptr  relatedstack;
		  msclickptr   relatedmsclick;
		  keyclickptr  keyptr;
		  msclickptr   msptr;
		  unsigned     msclickcount;
	     } imagestack;


extern	imagestkptr  stackptr;
extern	keyclickptr  keystackptr;
extern	timetickptr  timestackptr;

extern	int	     activeevents;
extern	unsigned     functionkeycode;
extern	char	     autorotateup;
extern	callproc     ctrlbreakproc;

extern char far keybrdnextclick(void);

extern char far crclickpress(void);

extern char far crclickrelease(void);

extern void toggleoptionbar(imagestkptr fs,msclickptr opt,msclickptr lastopt);

extern char frameexist(imagestkptr fs);

extern unsigned countframes(void);

extern void pushimage(unsigned x,unsigned y,unsigned x1,unsigned y1);

extern void popimage(void);

extern void prepareforpartialupdate(imagestkptr frame,unsigned x,unsigned y,unsigned x1,unsigned y1);

#define prepareforupdate(fs) prepareforpartialupdate(fs,fs->x,fs->y,fs->x1,fs->y1);

extern imagestkptr preparepartialimage(imagestkptr frame,imagestkptr tempimagebuff,
				unsigned x,unsigned y,unsigned x1,unsigned y1);

#define prepareimageupdate(f,g) preparepartialimage(f,g,f->x,f->y,f->x1,f->y1)

extern void commitupdate(void);

extern void rotatestackimage(imagestkptr frame1,imagestkptr frame2);

extern void rotateunderstackimage(imagestkptr frame1,imagestkptr frame2);

extern void moveframe(int *fx,int *fy,int *fx1,int *fy1,int rx,int ry,int rx1,int ry1,int color);

extern imagestkptr frameselectandmove(unsigned mxpos,unsigned mypos);

#define setmoverestrictions(f,x_,y_,x1_,y1_) f->restrictmovef.x=x_;f->restrictmovef.y=y_;f->restrictmovef.x1=x1_;f->restrictmovef.y1=y1_

#define setframemobility(fs,mv) fs->movable=mv

#define setmoveframecallproc(fs,ecp) fs->movecallproc=ecp

extern void linkfs(imagestkptr nfs,imagestkptr cfs);

extern void linkunderfs(imagestkptr nfs,imagestkptr cfs);

extern void unlinkfs(imagestkptr cfs);

extern void hideimage(imagestkptr frame);

extern void showimage(imagestkptr frame,unsigned x,unsigned y);

extern void movestackimage(imagestkptr frame,unsigned x,unsigned y);

extern void dropstackimage(imagestkptr frame);

extern void createimagebuffer(imagestkptr *imagebuffer,unsigned x,unsigned y,unsigned x1,unsigned y1);

extern void dropimagebuffer(imagestkptr imagebuffer);

extern void freeimagebuffer(imagestkptr fs);

extern imagestkptr getpartialfrontimage(imagestkptr frame,unsigned x,unsigned y,unsigned x1,unsigned y1);

#define getfrontimage(f) getpartialfrontimage(f,f->x,f->y,f->x1,f->y1)

extern void getfsimage(unsigned x,unsigned y,imagestkptr fs);

extern void putfsimage(unsigned x,unsigned y,imagestkptr fs,unsigned rmwbits);

#define setimagecoordinates(fs,a,b,c,d) fs->x=a; fs->y=b; fs->x1=c; fs->y1=d

#define clearkeyboardbuf() while (kbhit()) getch()

#define clearteglkeyboardbuf() while (teglkeypressed()) teglreadkey()

#define setautorotate(onoff) autorotateup = onoff

extern imagestkptr findframe(unsigned mxpos,unsigned mypos);

extern void resetframeactive(imagestkptr fs, char active);

extern msclickptr findmouseclickptr(imagestkptr frame,unsigned clicknumber);

extern void resetmouseclicks(imagestkptr frame,msclickptr clickptr);

extern void resetmsclicksense(imagestkptr frame,char newsense);

extern void resetmsclickcallproc(imagestkptr frame,unsigned mouseclicknumber,callproc entrycallproc);

extern void resetmsclickactive(imagestkptr frame,unsigned mouseclicknumber,char active);

extern void definemouseclickarea(imagestkptr frame,unsigned x,unsigned y,unsigned x1,
				 unsigned y1,char active,callproc entrycallproc,char sense);

extern msclickptr checkmouseclickpos(imagestkptr frame,unsigned mxpos,unsigned mypos);

extern void defineglobalkeyclickarea(imagestkptr fs,msclickptr ms,unsigned keycode,char repeatkey,callproc entrycallproc);

extern void definelocalkeyclickarea(imagestkptr fs,msclickptr ms,unsigned keycode,char repeatkey,callproc entrycallproc);

extern keyclickptr findkeyclickptr(imagestkptr frame,unsigned keycode);

extern void dropkeyclick(imagestkptr frame,unsigned keycode,callproc entrycallproc);

extern void resetkeyclickcallproc(imagestkptr frame,unsigned keycode,callproc entrycallproc);

extern void pressbutton(imagestkptr fs,msclickptr mouseopt);

extern char visualbuttonpress(imagestkptr fs,msclickptr mouseopt);

extern msclickptr checkformouseselect(imagestkptr frame);

extern unsigned selectmenu(imagestkptr frame,msclickptr mouseclickpos);

#ifndef NOVIRT
extern char pageoutimagestack(unsigned long memrequest);

extern void pageoutfs(imagestkptr fs);

extern void pageinfs(imagestkptr fs);
#endif

#ifdef NOVIRT
#define useimage(fs)
#else
#define useimage(fs) pageinfs(fs); fs->imageinuse=TRUE
#endif

#define unuseimage(fs) fs->imageinuse=FALSE

#ifdef NOVIRT
#define lockimage(fs)
#else
#define lockimage(fs) pageinfs(fs); fs->imagelock = TRUE
#endif

#define unlockimage(fs) fs->imagelock = FALSE


extern void teglsupervisor(void);

extern void checkctrlbreak(void);

#define setctrlbreakfs(cbp) ctrlbreakproc = cbp

extern void settimertick(unsigned timerinterrupt,callproc entrycallproc,imagestkptr fs,msclickptr ms);

extern void droptimertick(unsigned timerinterrupt,callproc entrycallproc);

/* $$$ duplicate  definintion
extern char crclickpress(void);
extern char crclickrelease(void);
*/

extern char overlap(unsigned ax1,unsigned ax2,unsigned bx1,unsigned bx2,unsigned *nx1,unsigned *nx2);

extern char overlaparea(unsigned ax,unsigned ay,unsigned ax1,unsigned ay1,
			unsigned bx,unsigned by,unsigned bx1,unsigned by1,
			unsigned *cx,unsigned *cy,unsigned *cx1,unsigned *cy1);

extern void teglinit(vmode videomode,unsigned long hugeminimum);


/* teglgrph.c */

typedef struct teglconstants {
		     unsigned	   teglbackcolor;
		     unsigned	   teglbordercolor;
		     unsigned char teglbackpattern[8];
		     char	   teglbordershow;
		     char	   tegluserpattern;
		     unsigned	   teglfillstyle;

		     unsigned	   shadowcolor;
		     unsigned	   shadowbordercolor;
		     unsigned char shadowfillpattern[8];
		     char	   shadowuserpattern;
		     unsigned	   shadowfillstyle;

		     fontptr	   shadowtexttype;
		     char	   defaulttexthighlight;
		     unsigned	   defaulttexthcolor;
		     unsigned	   defaulttextscolor;

		     unsigned	   extendtexthcolor;
		     unsigned	   extendtextscolor;
		     unsigned	   extendtextcolor;

		     unsigned	   shifttextcolor;
		     unsigned	   shifttextscolor;

		     unsigned	   zipduration;
	     } teglconstants;

extern teglconstants tg;
extern teglconstants herc_tg;

extern void drawlongbutton(unsigned x,unsigned y,unsigned ln);

#define setshadowcolor(b) tg.shadowcolor = b

#define setshadowbordercolor(b) tg.shadowbordercolor = b

#define setshadowfillpattern(bp) memcpy(tg.shadowfillpattern,bp,sizeof(tg.shadowfillpattern)); tg.shadowuserpattern=TRUE

#define settgconstants(bp) memcpy(tg,bp,sizeof(tg))

#define setshadowfillstyle(p) tg.shadowuserpattern=FALSE; tg.shadowfillstyle=p

extern void shadowbox(unsigned x,unsigned y,unsigned x1,unsigned y1);

extern void shadowtext(unsigned x,unsigned y,unsigned color,char * textstr);

#define setshadowtexttype(tt) tg.shadowtexttype = tt

#define setshadowtextshadow(c) tg.defaulttextscolor = c

#define setshadowtexthighlight(c) tg.defaulttexthighlight=TRUE; tg.defaulttexthcolor=c

#define shadowtexthighlightoff() tg.defaulttexthighlight=FALSE

extern void shadowboxtext(unsigned x,unsigned y,unsigned txtlen,char *textstr);

extern void extendtextxy(unsigned x, unsigned y, char *msg);

extern void shifttextxy(unsigned x, unsigned y, char *msg);

#define setteglbordershow(bs) tg.teglbordershow = bs

#define setteglbackcolor(b) tg.teglbackcolor = b

#define setteglbordercolor(b) tg.teglbordercolor = b

#define setteglfillpattern(bp) memcpy(tg.teglbackpattern,bp,sizeof(tg.teglbackpattern)); tg.tegluserpattern = TRUE

#define setteglfillstyle(p) tg.tegluserpattern = FALSE; tg.teglfillstyle = p

extern void clearteglscreen(void);

extern void movebox(int ax,int ay,int x,int y,int x1,int y1);

extern void ziptobox(int ax, int ay,int ax1,int ay1,int x,int y,int x1,int y1);

extern void zipfrombox(int ax,int ay,int ax1,int ay1,int x,int y,int x1,int y1);

extern unsigned collapsetoiconshow(imagestkptr fs, msclickptr mouseclickpos);

extern unsigned collapsetomsclick(imagestkptr fs, msclickptr mouseclickpos);

extern void explodefrommsclick(imagestkptr frame, msclickptr mouseclickpos, unsigned x, unsigned y, unsigned x1, unsigned y1);

extern void explodefromiconhide(imagestkptr frame, msclickptr mouseclickpos, unsigned x, unsigned y, unsigned x1, unsigned y1);

extern void putuserbuttonclick(imagestkptr fs, unsigned x, unsigned y, char *msg);

extern void defineuserbuttonclick(imagestkptr fs, unsigned x, unsigned y, char *msg,callproc entrycallproc);

extern void definebuttonclick(imagestkptr fs, unsigned x, unsigned y, char * button, callproc entrycallproc);

extern void definelongbuttonclick(imagestkptr fs, unsigned x, unsigned y, unsigned ln, char *msg, callproc entrycallproc);


/* teglmenu.c */

typedef struct optionentry *optioneptr;
typedef struct optionmenu *optionmptr;
typedef struct omevents *omeventptr;

typedef struct omevents {
		  omeventptr	 nextomevent;
		  msclickptr	 optionms;
		  imagestkptr	 optionfs;
		  optionmptr	 optionmn;
		  unsigned char  optiontype;
	     } omevents;

typedef struct optionmenu {
		  optionmptr	 nextom;
		  unsigned	 numofentries;
		  unsigned	 maxwidth;
		  unsigned	 padding;
		  fontptr	 fonttype;
		  optioneptr	 firstentry;
		  optioneptr	 currententry;
	     } optionmenu;

typedef struct optionentry {
		  optioneptr	 nextoe;
		  char		 entryline[41];
		  char		 entryactive;
		  int		 entrycolor;
		  callproc	 entrycallproc;
	     } optionentry;


typedef struct menuconstants {
		  unsigned	 barmenumargin;
		  unsigned	 barmenucolor;
		  unsigned	 bartextcolor;
		  unsigned	 barbordercolor;
		  char		 barbordershow;
		  unsigned	 barfillstyle;
		  char		 barshadowtext;
		  unsigned	 ominactivecolor;
		  unsigned	 omactivecolor;
		  unsigned	 ombordercolor;
		  char		 hidesubmenu;
	     } menuconstants;

/*$$$*/
/*
enum { upperright   = 0 };
enum { upperleft    = 1 };
enum { lowerright   = 2 };
enum { lowerleft    = 3 };
enum { notoggleentry = 4 };
enum { notoggleexit = 8 };
*/
#define upperright     0
#define upperleft      1
#define lowerright     2
#define lowerleft      3
#define notoggleentry  4
#define notoggleexit   8


extern menuconstants mc;

extern menuconstants herc_mc;

#define setmcconstants(bp) memcpy(&mc,bp,sizeof(mc))

extern void togglecheckmark(unsigned omnum,unsigned oenum,char status);

extern void toggleentrystatus(unsigned omnum,unsigned oenum,char status);

extern optionmptr createoptionmenu(fontptr fonttype);

extern void replaceoptiontext(unsigned omnum,unsigned oenum,char *entrystr);

extern void defineoptions(optionmptr om,char *entrystr,char active,callproc entrycallproc);

extern void resizeoptionmenu(optionmptr om,fontptr fonttype);

extern optionmptr createshadowom(optionmptr om,fontptr fonttype);

extern void resetoptionmenuevents(void);

extern void defineoptionclickarea(imagestkptr fs,unsigned x,unsigned y,
	unsigned x1,unsigned y1,optionmptr om,char sense,unsigned char omtype);

extern void createbarmenu(unsigned x,unsigned y,unsigned ln);

extern void outbaroption(char *entrystr,optionmptr om);



#define setoptionmenucolors(a,i) mc.omactivecolor=a; mc.ominactivecolor=i

#define setoptionmenubordercolor(c) mc.ombordercolor = c

#define setbarmenumargin(m) mc.barmenumargin = m

#define setbarmenucolor(c) mc.barmenucolor = c

#define setbartextcolor(c) mc.bartextcolor = c

#define setbarbordercolor(c) mc.barbordershow=TRUE; mc.barbordercolor=c

#define setbarborderoff() mc.barbordershow = FALSE

#define setbarfillstyle(p) mc.barfillstyle = p

#define setbarshadowtext(onoff) mc.barshadowtext = onoff

#define sethidesubmenu(onoff) mc.hidesubmenu = onoff




/* teglicon.c */

extern unsigned char         imageCREDITS[1613];
extern unsigned char         imageTRASH[846];
extern unsigned char         imageOK[413];
extern unsigned char         imageCANCEL[640];
extern unsigned char         imageBLANKBUT[162];
extern unsigned char         imageLBUT[101];
extern unsigned char         imageMBUT[35];
extern unsigned char         imageRBUT[79];
extern unsigned char         imageDOWN[89];
extern unsigned char         imageUP[93];
extern unsigned char         imageRIGHT[75];
extern unsigned char         imageLEFT[80];
extern unsigned char         imageR[54];
extern unsigned char         imageC[48];
extern unsigned char         imageTIGER[130];
extern unsigned char         imageLAST[472];
extern unsigned char         imageNEXT[511];
extern unsigned char         imageQUESTION[387];
extern unsigned char         imageVS[212];
extern unsigned char         imageMC[340];
extern unsigned char         imageTINYTEGL[129];
extern unsigned char         gridfill[8];


/* teglfsio.c */

typedef struct frameiorec *frameioptr;
typedef struct frameiorec {
		 frameioptr   nextframeio;
		 imagestkptr  fs;
		 unsigned         x, y;
		 unsigned         minx, maxx;
		 unsigned         miny, maxy;
	      } frameiorec;

extern frameioptr findfsio(imagestkptr  frame);

extern void openfsio(imagestkptr frame, unsigned x, unsigned y, unsigned x1, unsigned y1);

extern void closefsio(imagestkptr frame);

extern void writefs(imagestkptr fs, char * textstr);

extern void getmargins(imagestkptr frame, unsigned * x, unsigned * y, unsigned * x1, unsigned * y1);

extern void setmargins(imagestkptr frame, unsigned x, unsigned y, unsigned x1, unsigned y1);

extern void gotofsxy(imagestkptr frame, unsigned x, unsigned y);

extern unsigned fsiowherey(imagestkptr frame);

extern unsigned fsiowherex(imagestkptr frame);

extern void scrollup(imagestkptr fs);

extern void scrolldown(imagestkptr fs);


/* debugunt.c */

extern unsigned showcoordinates(imagestkptr frame,msclickptr mouseclickpos);

extern unsigned showmousexycoords(imagestkptr fs, msclickptr mouseclickpos);

extern unsigned showbuttonstatus(imagestkptr frame,msclickptr mouseclickpos);


/* fonttest.c */

#ifdef TEGLDEMO
#define MAXFONTS 7
#else
#define MAXFONTS 27
#endif

unsigned closefontwindow(imagestkptr frame,msclickptr mouseclickpos);

char *fontname(unsigned fontnum);

void createfontwindow(unsigned fontnum);

unsigned showonefont(imagestkptr frame,msclickptr mouseclickpos);

unsigned showfonts(imagestkptr frame,msclickptr mouseclickpos);


/* sensems.c */

extern void setmousesense(int x, int y);

/* soundunt.c */

extern  char       beepstatus;

extern  unsigned   beepdivisor;

extern unsigned asksoundsense(imagestkptr frame, msclickptr mouseclickpos);

extern void beep(unsigned tone, unsigned n, unsigned duration);

extern void slidebeep(unsigned tone1, unsigned tone2, unsigned n);

extern void soundswitch(char onoff);


/* selectfl.c */

extern char selectafile(int x,int y,char *path,char *fileselected);

extern void editstring(imagestkptr fs,int x,int y,int maxlen,char *textstr);


/* animate.c */

typedef struct coordinates {
    int x, y;
} coordinates;

typedef struct animateframe *aframeptr;
typedef struct animateframe {
    aframeptr    nextframe;        /* next char *, can be circular buffer */
    char        *imagepic;         /* image for display */
    unsigned     tonehz;           /* 0 turns off tone */
    unsigned     tonedelay;
    coordinates  movement;         /* next increment */
    unsigned     imgdelay;         /* delay before next image is placed */
    unsigned     imagesz;          /* size of image */
    unsigned     height, width;    /* length and width of image */
    unsigned     color;            /* color for putpict */
} animateframe;

typedef struct sequenceset *sequenceptr;
typedef struct sequenceset {
    sequenceptr  nextsequence;
    unsigned     sequencenum;
    aframeptr    sequenceframe;
} sequenceset;

typedef struct animateobject {
    aframeptr    currentframe;     /* char * to current picture frame */
    aframeptr    firstframe;       /* first image char * */
    sequenceptr  sequenceframe;
    unsigned     framenumber;
    coordinates  cc;
} animateobject;


extern void init(animateobject * ao);

extern void origin(animateobject * ao, unsigned ox, unsigned oy);

extern void getorigin(animateobject * ao, int *lastox, int *lastoy);

extern void resetframe(animateobject * ao, unsigned startframe);

extern unsigned currentframenumber(animateobject * ao);

extern unsigned destination(animateobject * ao, int dx, int dy);

extern void addframe(animateobject * ao, char *pp, int mx, int my, unsigned ht, unsigned wd, unsigned dy, unsigned hz, unsigned hzdy, unsigned co);

extern void sequence(animateobject * ao, unsigned seqnum);

extern void resetsequence(animateobject * ao);

extern void animateinit(void);

extern void animate(animateobject * ao, unsigned numframe);

extern void animatecomplete(animateobject * ao);

extern void anim_init(int argc, char **argv);


/* tegleasy.c */

#ifndef NULL
#define NULL  0L
#endif

extern int displayadaptor;

extern unsigned long reservemem;

extern char enablecontrolbreak;

extern fontptr easyfont, fontstore;


extern void activebutton(unsigned x,unsigned y,char * s,callproc p);

extern int coltox(int col);

extern void errmess(unsigned x,unsigned y,char * s);

extern void fitframe(unsigned * x,unsigned * y,unsigned * width,unsigned * height);

extern void framefromicon(imagestkptr ifs,msclickptr ms,unsigned x,unsigned y,unsigned x1,unsigned y1);

extern void frametext(imagestkptr ifs,int row,int col,char * s);

extern unsigned getmousey(imagestkptr ifs);

extern char getyesno(unsigned x,unsigned y,char * s);

extern void easytegl(void);

extern int lastcol(imagestkptr ifs);

extern int lastrow(imagestkptr ifs);

extern unsigned quit(imagestkptr frame,msclickptr mouseclickpos);

extern void quickframe(imagestkptr * ifs,unsigned *x,unsigned *y,unsigned *width,unsigned *height);

#define outframetextxy(f,x_,y_,s) outtegltextxy(f->x+x_,f->y+y_,s)

#define restoretext() fonttable = fontstore

extern int rowtoy(int row);

#define seteasyfont(p) easyfont = p

#define selecteasytext() fontstore=fonttable; fonttable=easyfont

