/*
 *                              SCREEN.H
 *
 *                         Screen i/o Handler
 *
 *                           Written for the
 *
 *                              Datalight
 *                           Microsoft V 5.x
 *                                TurboC
 *                                  &
 *                               Zortech
 *
 *                             C Compilers
 *
 *            Copyright (c) John Birchfield 1987, 1988, 1989
 */

extern int  Scr_Cols;
extern int  Scr_Rows;
extern char Scr_Window_Top;
extern char Scr_Page;
extern char Scr_ATTR;

/*
 *	The screen attributes can be
 *
 *	       UnderLine OR Reverse OR Normal
 *
 *	BRIGHT - BLINK are additional attributes applied to the above
 */

#if (!defined (SCREEN_ATTRIB))
#	define SCR_ATTRIB    1
#	define SECURE     0x77
#	define REVERSE    0x70
#	define NORMAL        7
#	define UNDERLINE     1
#	define BLINK      0x80
#	define BRIGHT        9
#	define INVERSE_UL (UNDERLINE | INVERSE)
#endif

# ifdef LINT
extern int _kb (void);
extern int screen_init (void);
extern int screen_smode (char);
extern int rowcol (int, int);
extern int g_rowcol (void);
extern int clrscrn (void);
extern int cleol (void);
extern int cleop (void);
extern int scroll_up (int, int, int, int, int);
extern int scroll_dn (int, int, int, int, int);
extern int screen_co (char);
extern int sinp (void);
extern int cursor_off (void);
extern int cursor_on (void);
extern int aputs (int, char *);
extern int aput (int, char);
# endif
