/*
 *                               QUEUE.C
 *
 *                        Queue Handling Module
 *
 *                           Written for the
 *
 *                              Datalight
 *                           Microsoft V 5.x
 *                                TurboC
 *                                  &
 *                               Zortech
 *
 *                             C Compilers
 *
 *            Copyright (c) John Birchfield 1987, 1988, 1989
 */

#include "queue.h"

/*
 *	QUEUE routines to allocate - enqueue - dequeue elements to a queue
 */

QUEUE  *
alloc_queue (int size)
{
    QUEUE  *tmp;
    if ((tmp = (QUEUE *) malloc (sizeof (QUEUE) + size)) != (QUEUE *) 0)
    {
        tmp->size = size;
        tmp->head = 0;
        tmp->tail = 0;
        tmp->avail = size;
        tmp->buf = ((char *) tmp) + sizeof (QUEUE);
    }
    return (tmp);
}



int 
en_queue (QUEUE *qp, char ch)
{
    int     head = qp->head;

    if (qp->avail == 0)
        return (-1);
    *(qp->buf + head) = ch;
    if (++head == qp->size)
        head = 0;
    qp->head = head;
    --(qp->avail);
    return (qp->avail);
}

int 
de_queue (QUEUE *qp)
{
    int     tail = qp->tail, ch;

    if (qp->avail == qp->size)
        return (-1);
    ch = *(qp->buf + tail);
    if (++tail == qp->size)
        tail = 0;
    qp->tail = tail;
    qp->avail++;
    return (ch);
}
