/*
 *                               _KB.C
 *
 *                        Keyboard i/o Handler
 *
 *                           Written for the
 *
 *                              Datalight
 *                           Microsoft V 5.x
 *                                TurboC
 *                                  &
 *                               Zortech
 *
 *                             C Compilers
 *
 *            Copyright (c) John Birchfield 1987, 1988, 1989
 */
/*
 * If we use the Microsoft Compiler, we need to bind in MSC.OBJ
 * which contains the function _kbhit ().
 */

#include <dos.h>

/*
 *	defines for the bits returned in regs.x.cflag and by int86 () ...
 */

#define ZERO_BIT       0x040
#define CARRY_BIT          1
#define SIGN_BIT       0x080
#define DIRECTION_FLAG 0x400
#define OVERFLOW_BIT   0x800

static union REGS regs;


/*
 *	The following Translate Table is used to convert the PC scan
 *	codes into something of use.  The translated values are defined in
 *	the file "scr_iokb.h".
 */

#include "_kb.h"
static struct xlate_tbl
{
    int     in, out;
}       cvt[] =

{
    {
                72, up_char
    }      ,
    {
                80, down_char
    }      ,
    {
                75, left_char
    }      ,
    {
                77, right_char
    }      ,
    {
                115, ctl_lft_char
    }      ,
    {
                116, ctl_rt_char
    }      ,
    {
                71, home_char
    }      ,
    {
                79, end_char
    }      ,
    {
                119, ctl_home_char
    }      ,
    {
                117, ctl_end_char
    }      ,
    {
                73, pageup_char
    }      ,
    {
                81, pagedown_char
    }      ,
    {
                132, ctl_pu_char
    }      ,
    {
                118, ctl_pd_char
    }      ,
    {
                82, Ins_char
    }      ,
    {
                83, Del_char
    }      ,

    /* Straight Ahead Function Keys */
    {
                59, M1
    }      ,
    {
                60, M2
    }      ,
    {
                61, M3
    }      ,
    {
                62, M4
    }      ,
    {
                63, M5
    }      ,
    {
                64, M6
    }      ,
    {
                65, M7
    }      ,
    {
                66, M8
    }      ,
    {
                67, M9
    }      ,
    {
                68, M10
    }      ,

    /* Shifted Function Keys */
    {
                104, M11
    }      ,
    {
                105, M12
    }      ,
    {
                106, M13
    }      ,
    {
                107, M14
    }      ,
    {
                108, M15
    }      ,
    {
                109, M16
    }      ,
    {
                110, M17
    }      ,
    {
                111, M18
    }      ,
    {
                112, M19
    }      ,
    {
                113, M20
    }      ,

    /* Alt Function Keys */
    {
                84, M21
    }      ,
    {
                85, M22
    }      ,
    {
                86, M23
    }      ,
    {
                87, M24
    }      ,
    {
                88, M25
    }      ,
    {
                89, M26
    }      ,
    {
                90, M27
    }      ,
    {
                91, M28
    }      ,
    {
                92, M29
    }      ,
    {
                93, M30
    }      ,

    /* Ctrl Function Keys */
    {
                94, M31
    }      ,
    {
                95, M32
    }      ,
    {
                96, M33
    }      ,
    {
                97, M34
    }      ,
    {
                98, M35
    }      ,
    {
                99, M36
    }      ,
    {
                100, M37
    }      ,
    {
                101, M38
    }      ,
    {
                102, M39
    }      ,
    {
                103, M40
    }      ,

    {
                0, 255
    }
};




/*
 *	_KB can tell if the Keyboard has been touched.  If it has, he returns
 *	    the value of the key pressed.  If the Control Key or one of the
 *	    Numeric or Function Keys is pressed that value is returned
 *	    from a look-up table.
 *
 *	Usage: if ((ch=_kb ())!=-1) we_have_a_char=TRUE;
 */


int 
_kb ()
{
    int     ix, flag;
#if (defined (DLC))
# if (defined (__ZTC__))
    if (kbhit ())
# else
    regs.h.ah = 1;
    if ((int86 (0x16, &regs, &regs) & ZERO_BIT) == 0)
# endif 
    {
#else
# if (defined (__TURBOC__))
    regs.h.ah = 1;
    int86 (0x16, &regs, &regs);
    if ((regs.x.flags & ZERO_BIT) == 0)
    {
# else
    if (_kbhit ())
    {
# endif
#endif
        regs.h.ah = 0;
        int86 (0x16, &regs, &regs);
        if (regs.h.al == 0)
        {
            for (ix = 0; cvt[ix].in; ix++)
                if (cvt[ix].in == regs.h.ah)
                    break;
            return (cvt[ix].out);
        }
        return ((int) regs.h.al);
    }
    return (-1);
}
