/**********************************************************/
/* File Id.                  Menudemo.C                   */
/* Author.                   Stan Milam.                  */
/* Date Written.             05/30/89.                    */
/*                                                        */
/* Comments:  A little demonstration of PC Windows, and   */
/* more specifically the menus.                           */
/*                                                        */
/* Be sure to link with PDEMO.C & LDEMO.C.                */
/* Examples:                                              */
/*   mslink menudemo.c ldemo.c pdemo.c (Microsoft C)      */
/*   tclink menudemo ldemo pdemo       (Turbo C)          */
/*   pc /e  menudemo                   (Power C .prj file)*/
/**********************************************************/

#include <stdio.h>
#include "pcwproto.h"
#include "menu.h"

extern int CheckSnow;

/* First lets do a few window messages.... */

static char *intromsg[] = {
   "PC Windows!  PCW is a windowing package written in C for C",
   "using the IBM family of personal  computers and  100% true",
   "compatibles.  PCW supports Microsoft C 5.0+, Turbo C 1.5+,",
   "and MIX POWER C 1.1.6+. PCW not only supports windows.....",
   "it features automatic sensing of the adapter & monitor  in",
   "use.  It also does  QUICK  screen  writes (NO SNOW ON CGA)",
   "with functions like qprintf() & qputs(). Also featured are",
   "popup menus & a variation of the famous  Lotus  menu  with",
   "MOUSE support.  In short, PCW gives  you  control  and all",
   "the video power you can use.  Best of all, PCW is targeted",
   "as SHAREWARE software!  Press a key and let's take a look.",
   NULL
};

static char *menumsg[] = {
   "I've prepared a little demo for you.  Let's take a look at",
   "the menus.  I feature the menus because  they  demonstrate",
   "many of the capabilities of PCW.  In fact, the menu  func-",
   "tions were built using  functions already  in  PCW. So, if",
   "you are ready make a selection from the pick list and lets",
   "Take a look                                               ",
   " ",
   "P.S.  I scrolled the window VERY SLOWLY so you could see it",
   "happen!                                                    ",
   NULL
};

static char *goodby[] = {
   "Well, I have labored long and hard to bring you PC Windows",
   "and I hope you enjoy it.  After much thought and consider-",
   "ation I have decided to let PCW be FREEWARE so enjoy!!!!  ",
   NULL
};

static char *copyright[] = {
   "PC Windows",
   "(c) Copyright 1989, 1990",
   "by",
   "Stan Milam",
   NULL
};

static char *selections[] = {
   "Pop Up Menu",
   "Light Bar Menu",
   "Pick List Menu",
   "Exit",
   NULL
};

static PICKLIST pl_menu = {
    NULL,
    18,30,23,50,
    BLUE, LIGHTGRAY,
    DOUBLEALL, RED, LIGHTGRAY,
    " Pick Menu ",
    TOP, MIDDLE, BLACK, LIGHTGRAY,
    WHITE, BLUE,
    selections, 0, 0
};

/* Some function Prototypes. */

int  lmenu_demo(void);
int  pmenu_demo(void);
int  pl_menu_demo (void);
void scrollit(WNDPTR *wnd, int count);

int (*option[3])(void) = {
    pmenu_demo,
    lmenu_demo,
    pl_menu_demo
};


/*******************************/
/*             MAIN            */
/*******************************/
int main(void) {

   int mtype, select;
   int mxr, mxc, tl, bl;               /* Max rows & cols */
   WNDPTR *savewnd, *msgwnd, *pwnd;     /* Save screen & message window */

   if (!chk_video_state(&mxr, &mxc)) return(3);/* Check-get max rows & cols */
   get_cursor_size(&tl,&bl);
   set_cursor_size(0,0);
   savewnd = wpush(1,1,mxr,mxc);               /* Save entire screen */
   if (!savewnd) return(3);                    /* Exit if we cannot */
   qfill(1,1,mxr,mxc,LIGHTGRAY,BLUE,176);      /* Fill scrn with funy chars */
   bordercolor(BLACK,LIGHTGRAY);               /* Set border color */
   titlecolor(RED,LIGHTGRAY);                  /* Set the title */
   msgwnd = wexplode(2,8,16,72,BLUE,LIGHTGRAY);/* Frame the message window */
   if (!msgwnd) {                              /* And bug out if failed */
      savewnd = wpop(savewnd);
      scroll(1,1,mxr,mxc,7,0,10);
      qputs(mxr,CENTER,RED,BLACK,"Not enough memory for PCW!");
      swait(10);
      return(3);
    }
    wtitle(msgwnd,TOP,MIDDLE," PC Windows Menu Demo "); /* Do the title */
    w_block_write(msgwnd,2,CENTER,intromsg);            /* Put the 1st msg */
    keywait(60);
    scrollit(msgwnd, 13);                               /* Scroll it down */
    set_wnd_attr(msgwnd, BLACK,LIGHTGRAY);              /* Chg wnd colors */
    w_block_write(msgwnd,2,CENTER,menumsg);             /* Put 2nd message */
    init_mouse();                                       /* Initialize mouse */
    if (mpresent) {                                     /* Is rat home? */
       hide_mouse();                                    /* Out of sight */
       mtype = MK_ATTR(YELLOW+BLINK,BLACK) | 4;         /* Mouse cursor */
       set_mtype(0,0,mtype);                            /* Set rat cursor */
    }
    pwnd = make_pick_list( &pl_menu );
    for (select = 0;select > -1 && select < 3;) {
        select = get_pick_list( &pl_menu );
        if ( select == -1 || select == 3 ) continue;
        if (mpresent) hide_mouse();
        whide(msgwnd);
        whide(pwnd);
        if ((*option[select])()) {
           msgwnd = wpop(msgwnd);                  /* Bug out if error */
           savewnd= wpop(savewnd);
           vcls();
           puts("Error while performing menu demo");
           swait(10);
           return(3);
        }
        wshow(pwnd);
        wshow(msgwnd);
    }
    if (mpresent) hide_mouse();                /* If rat is home hide it */
    wpop( pwnd ); swait(1);
    scrollit(msgwnd,13);                       /* Scroll it down 5 lines */
    set_wnd_attr(msgwnd,YELLOW,LIGHTGRAY);     /* Change the window color */
    w_block_write(msgwnd,2,CENTER,goodby);     /* Say good-bye sweetheart! */
    keywait(10);                               /* Wait 10 seconds */
    savewnd = wpop(savewnd);                   /* Remove background chars */
    set_wnd_attr(msgwnd,BLUE,LIGHTGRAY);       /* Change its color to blue */
    w_block_write(msgwnd,7, CENTER, copyright);/* Write Copyright */
    keywait(5);                                /* Let them see it */
    msgwnd  = wpop(msgwnd);                    /* Remove the window */
    set_cursor_size(tl, bl);                   /* Restore the cursor */
    return(0);                                 /* Good-night Irene! */
}

void scrollit(WNDPTR *wnd, int count) {

   int lcv;

   for (lcv = 0; lcv < count; lcv++) {
      wscroll(wnd,1,1);                        /* Scroll wnd down 1 line */
      if (_adaptor != CGA) rest(1);            /* Slow down fast monitors */
   }
}
