/***************************************************************/
/* File Id.                     Paldemo.C                      */
/* Author.                      Stan Milam.                    */
/* Date Written.                28 Nov 89.                     */
/*                                                             */
/*           (c) Copywrite 1989, 1990 by Stan Milam            */
/*                                                             */
/* Demo of changing the palette color on EGA/VGA.              */
/***************************************************************/

#include <stdio.h>
#include <pcwproto.h>

void main(void) {

   int i,j;
   WNDPTR *wnd, *savewnd;

   chk_video_state(&i,&j);
   if (_adaptor < EGA || _monitor != COLOR) {
      puts("\nYou must have an EGA or VGA adapter with color monitor to ");
      puts("run this demo.");
      return;
   }
   savewnd = wpush(1,1,i,j);
   get_ega_palette( DFLT_PALETTE );
   for (i = 0; i < 16; i++) qputs(i+4,CENTER,i,BLACK,"Hello World!");
   keywait(10);

   for(i = 32, j = 0; i < 48; i++, j++) set_load_palette(j, i);
   keywait(10); get_ega_palette(22); load_ega_palette();
   bordercolor(BLUE,LIGHTGRAY);
   titlecolor(RED,LIGHTGRAY);
   wnd = wframe(6,20,18,60,BLACK,LIGHTGRAY);
   wtitle(wnd,TOP,MIDDLE," Changing Palette Colors ");
   keywait(10);
   set_palette(BLUE,RED);
   set_palette(RED,BLUE);
   load_ega_palette();
   wputs(wnd,1,CENTER,"Red is now blue and blue is red!");
   keywait(10);
   set_palette(LIGHTGRAY, GREEN); load_ega_palette();
   wputs(wnd,2,CENTER,"Lightgray becomes green!");
   keywait(10);
   get_ega_palette(22); load_ega_palette();
   wputs(wnd,5,CENTER,"**** Back to normal ****");
   keywait(10);
   wnd = wpop(wnd);
   bordercolor(RED,RED);
   wnd = wframe(6, 20, 18, 60, RED, RED);
   wtitle(wnd, TOP, MIDDLE, " Now all 64 colors ");
   wtitle(wnd,BOTTOM,RITE, " Press a key to stop ");
   for (i = 0; i < 64; i++) {
       set_load_palette(RED,i);
       swait(1);
       if (keypressed()) {
          getch();
          break;
       }
   }
   set_load_palette(RED,RED);
}
