/***************************************************************************
 * KATEST.C - Test for the key access System
 *
 * THIS PROGRAM REQUIRES THE USE OF THE SORT MODULE.
 * ALL KAFS (KEYED ACCESS FILE SYSTEM) LINES ARE DENOTED BY
 *   A COMMENT BEGINNING WITH: $$KAFS$$
 *
 ***************************************************************************/
#include <stdio.h>
#include <string.h>
#include <alloc.h>
#include <stdlib.h>

#include "KATEST.H"

#define SOF -1

extern long rec;
extern char key[];


struct courserec course;  /* Define the Course File Structure */

char password[]="password";

void main();
void pgmxit();
void mcourse();
int rf_course();
void courselist();
void w_putp(int row, int col, char *str);
void w_pc(int row, int col);
int w_penter(int row, int col, char *str, int len);
int w_enter(char str[], int len);
void error(char *es);

void main()
{
   int sel;
   int recsize;

   recsize = sizeof(course);   /* $$KAFS$$ Find out Record Sizes */

   if(ka_open(COURSEFILE,"COURSE")!=OK)  /* $$KAFS$$ Open the course file */
      {
      putchar(7); 
      printf("\n$$$ CANNOT OPEN COURSE FILE $$$\n");
      getch();
      return;
      }

   
while(TRUE)
   {
 clrscr();

  printf("                           KAFS - Keyed Access File System\n\n");
  printf("                                    TEST APPLICATION\n\n\n\n\n");
  printf("                                1 - (C)ourse Maintenance\n\n");
  printf("                                2 - (L)ist Courses\n\n");
  printf("                                3 - (Q)uit to DOS\n");

  w_pc(24,2);
  printf("Course Record Size is %d\n",recsize);

   sel=toupper(getch());
   switch(sel)
      {
      case '1':
      case 'C':
        mcourse();
        break;
      case '2':
      case 'L':
         courselist();
         break;
      case '3':
      case 'Q':
      case 27:
         pgmxit();
         break;
      }
   }
}
/*********************************
 * PGMXIT - End Progrm
 *********************************/
void pgmxit()
{
   ka_close_all();  /* $$KAFS$$ Close all Open KAFS Files */
   clrscr();
   exit(0);
}

/****************************************************
 * MCOURSE
 ******************************************************/
void mcourse()
{
   int wcc, eflag;
   char resp[250];
   char ans;
   float tf;   /* Temp float */


while(TRUE)
{
cedit:
clrscr();
memset(&course, 0, sizeof(course));
gotoxy(1,2);
puts(" Course Number:\n");
puts("   Course Name:");
puts("    Instructor:");
puts("         Units:");
puts(" Per Unit Cost:");
puts("         Notes:");
puts("    Commission:\n");
puts("   Total Course Cost:            $$ to MJM:");
puts(" Worksheet Only Cost:            $$ to MJM:");


strcpy(course.cnum,"");
if(w_penter(2,17,course.cnum,9)==ESC) break;

if(rf_course())  /* Read for Course, if found display Values */
   {
   w_putp(4,17,course.cname);
   w_putp(5,17,course.inst);
   w_putp(8,17,course.note);
   sprintf(resp,"%5d",course.units);
   w_putp(6,17,resp);
   sprintf(resp,"%4.2f",course.pucost);
   w_putp(7,17,resp);
   w_pc(9,17);
   putch(course.comm);

   sprintf(resp,"%5.2f",course.pucost * course.units);
   w_putp(11,23,resp);
   sprintf(resp,"%5.2f",course.mjmamt);
   w_putp(11,45,resp);

   sprintf(resp,"%5.2f",course.wsonly);
   w_putp(12,23,resp);
   sprintf(resp,"%5.2f",course.mjmwso);
   w_putp(12,45,resp);

   eflag=TRUE;
   }
else
  {
   if(strlen(course.cnum)==0) goto cedit;
   putchar(7);
   w_putp(15,4,"COURSE Not Found, Create COURSE (Y/N)?");
   do{ans=tolower(getch());} while(ans != 'y' && ans !='n' && ans !=ESC);
   w_pc(15,1);
   printf("                                           ");
   if(ans != 'y') goto cedit;
   eflag = FALSE;
   }

w_pc(4,17);
if(w_enter(course.cname,30)==ESC) goto cedit;
if(eflag && !strcmpi(course.cname,"delete"))
  {
   putchar(7);
   w_putp(15,4,"ENTER PASSWORD TO DELETE:");
   strcpy(resp,"");
   w_enter(resp,10);
   w_pc(15,1);
   printf("                                      ");
   if(strcmpi(resp,password))
      {
      error("INVALID PASSWORD");
      goto cedit;
      }
   rdelete(COURSEFILE, rec); /* $$KAFS$$ DELETE This Record */
   error("RECORD DELETED");
   goto cedit;
  }


w_pc(5,17);
if(w_enter(course.inst,20)==ESC) goto cedit;

sprintf(resp,"%5d",course.units);
w_pc(6,17);
if(w_enter(resp,33)==ESC) goto cedit;
course.units = atoi(resp);

sprintf(resp,"%4.2f",course.pucost);
w_pc(7,17);
if(w_enter(resp,4)==ESC) goto cedit;
course.pucost = atof(resp);

w_pc(8,17);
if(w_enter(course.note,35)==ESC) goto cedit;

gcflg:
if(!eflag) course.comm='N';
sprintf(resp,"%c",course.comm);
w_pc(9,17);
printf("     ");
if(w_enter(resp,1)==ESC) goto cedit;
if(resp[0]!='Y' && resp[0]!='N')
{
   error(" Y or N only");
   goto gcflg;
}
course.comm = resp[0];

sprintf(resp,"%5.2f",course.pucost * course.units);
w_putp(11,23,resp);

/* Allow Editing the Course Amounts to MJM */
w_pc(11,45);
sprintf(resp,"%5.2f",course.mjmamt);
if(w_enter(resp, 6)==ESC) goto cedit;  /* Edit the mjm Amt */
course.mjmamt = atof(resp);

w_pc(12,23);
if(!eflag) course.wsonly = (course.pucost * course.units) - 25;
sprintf(resp,"%5.2f",course.wsonly);
if(w_enter(resp,6)==ESC) goto cedit;
course.wsonly = atof(resp);

w_pc(12,45);
sprintf(resp,"%5.2f",course.mjmwso);
if(w_enter(resp, 6)==ESC) goto cedit; /* Edit mjm wso amt */
course.mjmwso = atof(resp);


if(eflag)
 {
  if(write_upd(COURSEFILE, &course)!=OK)  /* $$KAFS$$ Update the Record */
      error("ERROR UPDATING RECORD");  /* UPDATE */
 }
 else
   {
   if(write_key(COURSEFILE, course.cnum, &course)!=OK) /* $$KAFS$$ Create NEW Record */
       error("ERROR WRITING RECORD"); /* NEW REC */
   }
}
}

/*******************************************************************
 * rf_course - record find a course
 *    returns TRUE if found else FALSE
 **************************************************************************/
int rf_course()
{
  rec = SOF;  /* $$KAFS$$ Set for read to begin at beginning of file */
  if(read_key(COURSEFILE, course.cnum, &course)==OK) /* $$KAFS$$ Read by key */
       return(TRUE);

  else return(FALSE);
}
/***********************************************************************
 * COURSELIST - Course List Sorted by coursenumber
 ***********************************************************************/
void courselist()
{
    int ccode, sortsize, sortcount;
    int noteflag, invflag;
    int soption;
    char ans;
    char ts[20]; /* Temp String */
    char rptline[133];
    float value;

      clrscr();
    invflag=FALSE;
    w_putp(5,2,"DO YOU WANT INVOICING INFORMATION (Y/N)? ");
    do{ans=tolower(getch());} while(ans != 'y' && ans !='n' && ans !=ESC);
    if(ans==ESC) goto crxit;
    if(ans=='y') invflag = TRUE;
    putch(toupper(ans));

    noteflag=FALSE;
    if(invflag==FALSE)
       {
       w_putp(7,2,"DO YOU WANT COURSE NOTES PRINTED (Y/N)? ");
       do{ans=tolower(getch());} while(ans != 'y' && ans !='n' && ans !=ESC);
       if(ans==ESC) goto crxit;
       if(ans=='y') noteflag = TRUE;
       putch(toupper(ans));
       }

     sortsize = sizeof(course.cnum);

     if(initsort(sortsize) != OK)
       {
       error("NO SORT SPACE");
       goto crxit;
       }
 
    w_putp(9,25,"SORT IN PROGRESS\n");

 
 
  rec=SOF;  /* $$KAFS$$ Set for read to begin at beginning of file */
  while(read_seq(COURSEFILE, &course)==OK)  /* $$KAFS$$ Read Sequentially */
    {
       sort(course.cnum,rec);
      }

   if(sortcount < 1)
    {
    error("NO RECORDS TO SORT");
    goto crxit;
     }
 
   if(merge()!=OK)
    {
    error("MERGE ERROR");
    goto crxit;
    }
 
    clrscr();
    printf("COURSE LIST\n\n");
    if(invflag)
     printf("COURSE #   COURSE NAME                    UNITS COST   WSONLY  MJMAMT  WSOAMT\n");
    else
     printf("COURSE #   COURSE NAME                     INSTRUCTOR            UNITS  COST\n");
    printf("-----------------------------------------------------------------------------\n");

      while(TRUE)
       {
       rec = fetch();  /* $$KAFS$$ Set Rec to value from fetch */
       if(rec == SORTERR || rec == FETCHEND) break; /* $$KAFS$$ check rec value */
       read_rec(COURSEFILE, &course);  /* $$KAFS$$ Read by value in rec */
       if(invflag)
	sprintf(rptline,"%-9s  %-31s%3d  %6.2f  %6.2f  %6.2f  %6.2f\n",
	       course.cnum,course.cname,course.units,course.pucost * course.units,
             course.wsonly, course.mjmamt, course.mjmwso);
       else
         sprintf(rptline,"%-9s  %-31s %-21s %3d   %6.2f\n",
 	       course.cnum,course.cname,course.inst,course.units,
 	          course.pucost * course.units);
       printf("%s",rptline);
       if(noteflag)
 	    {
 	    if(strlen(course.note)> 0)
 	     {
	     sprintf(rptline,"          NOTES: %s\n",course.note);
	     printf("%s",rptline);
	     }
	printf("\n");
	    }
     }
   printf("************* REPORT END ************");
   getch();

 crxit:
 endsort();   /* Free the Sort buffer */
}

/***************************************************************************
 * Screen Postioning and keyboard entry routines
 ***************************************************************************/
void w_putp(int row, int col, char *str)
{
   gotoxy(col, row);
   printf("%s",str);
}

void w_pc(int row, int col)
{
   gotoxy(col, row);
}

int w_penter(int row, int col, char *str, int len)
{
   w_pc(row, col);
  return(w_enter(str, len));
}

int w_enter(char str[], int count)
{
   int c, pos, x;

   if(str[0]!=0) pos = strlen(str);
     else pos = 0;
   str[pos] = '\0';  /* Terminate the string just in case */

   if(pos>0)
      {
      printf("%s",str);  /* we're in edit mode */
      x=1;        /* Set Xout mode */
      }
    else x=0;   /* NO Xout if not editing */

   do {
      c = getch();   /* get a character from stdin */

      if (c ==0)   /* Got a Screen Control indicator */
	 {
	  c = getch();	/* waste the control code */
	  if (c == DELETE)
	   {
		while(pos) {putch(BKSP);putch(SPACE);putch(BKSP);pos--;} /* Delete The Field */
		 }
	      c=255;  /* Invalidate, it was a control code */
	 }

      if (c == ESC || c == ENTER) break;   /* We're done !! */

     if(x)
      {
      if(c>=SPACE) while(pos)
	 {
	 putch(BKSP);
	 putch(SPACE);
	 putch(BKSP);
	 pos--;
	 }
      x=0; /* Cancel it now that we've done it */
      }
 /** See if the character is a backspace **/
      if (c == BKSP)
	 {
	 if(pos == 0)
		putch(BELL);  /* If nothing entered, can't backspace */
	    else
	       {
	       putch(BKSP);    /* Do a Backspace */
	       putch(SPACE);
	       putch(BKSP);
	       pos--;
	       }
	    }
	 else
 /** See if we are at the end of the buffer.  If so, only accept an end **/
      if (pos <= count-1)
	 {
	    if (c >= SPACE && c < ASCIITOP)
	       {
		c=toupper(c);
		str[pos] = c;   /* add the character to buffer */
		putch(c);     /* display it */
		pos++;          /* advance the buffer pointer */
		}
		     else putch(BELL);
	     }
		  else putch(BELL);
	 } while ( c != ESC && c != ENTER);
    str[pos] = '\0';   /* Terminate the input string */
    return(c);
}

void error(char *es)
{
   putch(BELL);
   gotoxy(2,24);
   printf("%s",es);
   getch();
   gotoxy(2,24);
   printf("                                                      ");
}
