/*********************************************************************
* HRTIMER1.C - This program uses the function HRTimer1() as shown in *
*   Figure D of the article "Designing a high-resolution timer" in   *
*   the May 1991 issue of Inside Microsoft C. It demonstrates some   *
*   of the problems associated with this function.                   *
*********************************************************************/

#include <stdio.h>      /* puts()                                   */
#include <conio.h>      /* outp(), inp(), kbhit()                   */
#include <dos.h>        /* disable(), enable()                      */

#define COUNTS_PER_uSEC (double)1.19318

void HRMode2( void );
void HRMode3( void );
unsigned long HRTimer1( void );

/*********************************************************************
* HRMode2 - Switch counter 0 to mode 2 and load initial value 65536  *
*********************************************************************/
void HRMode2( void )
    {
    _disable();                   /* Disable interrupts             */
    outp(0x43, 0x34);             /* Counter 0, Mode 2, LSB/MSB     */
    outp(0x40, 0x00);             /* Load low word of valu          */
    outp(0x40, 0x00);             /* Load high word of value        */
    _enable();                    /* Re-enable interrupts           */
    }

/*********************************************************************
* HRMode3 - Switch counter 0 to mode 3 and load initial value 65536  *
*********************************************************************/
void HRMode3( void )
    {
    _disable();                   /* Disable interrupts             */
    outp(0x43, 0x36);             /* Counter 0, Mode 3, LSB/MSB     */
    outp(0x40, 0x00);             /* Load low word of value         */
    outp(0x40, 0x00);             /* Load high word of value        */
    _enable();                    /* Re-enable interrupts           */
    }

/*********************************************************************
* HRTimer1 - as shown in Figure D.                                   *
*********************************************************************/
unsigned long HRTimer1( void )
    {
    unsigned int far * BiosTicker =
        (unsigned int far *)0x0040006cL;
    union {
        unsigned long l;
        struct { unsigned int l, h; } i;
        struct { unsigned char l, h; } c;
        } C0;

    _disable();                   /* Turn off interrupts            */
    outp(0x43, 0x00);             /* Latch PIT counter 0            */
    C0.c.l = inp(0x40);           /* Read low byte of counter 0     */
    C0.c.h = inp(0x40);           /* Read high byte of counter 0    */
    C0.i.h = *BiosTicker;         /* Get BIOS's master clock count  */
    _enable();                    /* Turn interrupts back on        */
    C0.i.l = 65535 - (--C0.i.l);  /* Invert counter 0 value         */

    return( C0.l );
    }

/*********************************************************************
* main - Test loop for HRTimer1().                                   *
*********************************************************************/
void main( void )
    {
    unsigned long time1, time2;

    HRMode2();

    puts( "Testing HRTimer1().  Press any key to quit ... " );

    while ( !kbhit() )
        {
        time1 = HRTimer1();
        time2 = HRTimer1();
        if ( time2 < time1 )
            puts( "HRTimer1 error" );
        }

    HRMode3();
    }
