/*********************************************************************
* HRTIMER.C - This program times the execution of two functions that *
* reside in the file TESTFUNC.C. You compile TESTFUNC.C using the    *
* type of optimization you wish to test. However, the switches you   *
* use to compile this file, TIMER.C, and the high-resolution timer   *
* functions in STOPWATC.C should remain constant for all tests.      *
*                                                                    *
* Without opt: cl /Ox TIMER.C STOPWATC.C /Od TESTFUNC.C              *
* With opt   : cl /Ox TIMER.C STOPWATC.C /Ozax TESTFUNC.C            *
*                                                                    *
*********************************************************************/

#include <stdio.h>      /* printf(), puts()                         */
#include "stopwatc.h"

#define FALSE 0
#define TRUE  0
#define DEF_ITERATIONS   1000L
#define MICROSECONDS     (double)1000000L

/*----This macro performs the standard timing loop for all tests----*/
#define TIME_IT( funcname, total )                     \
    for(iterations=setting ; iterations; iterations--) \
        {                                              \
        start = StartTimer();                          \
        funcname;                                      \
        end = StopTimer();                             \
        total += end - start;                          \
        }

int  testfunc1(void);
int  testfunc2(void);
void emptyfunc(void);
void cdecl main(int argc, char **argv);

/*********************************************************************
* main() - Main body of program HRTIMER.C                            *
*********************************************************************/
void cdecl main(int argc, char **argv)
    {
    ULONG start=0, end=0, control_start=0, control_end=0;
    ULONG iterations, setting=DEF_ITERATIONS;
    UINT def = FALSE;
    double test1=0, test2=0, empty=0, op1, op2;

    HRInit( CODETIME );         /* Initialize StopWatch functions   */

    /*-------- Get iterations from command line, if given ----------*/
    if (argc < 2)
        def = TRUE;
    else
        {
        if(!atol(argv[1]))
            def = TRUE;
        else
            setting = atol(argv[1]);
        }

    /*-------- Show number of iterations on screen -----------------*/
    if(def)
        printf("Testing with default iterations: %lu\n",setting);
    else
        printf("Testing with %lu iterations\n",setting);

    /*-------- Determine time required for empty function ----------*/
    puts("Timing empty function...");
    TIME_IT( emptyfunc(), empty );

    /*-------- Time the first test function ------------------------*/
    puts("Testing testfunc1...");
    TIME_IT( testfunc1(), test1 );
    op1 = test1 - empty;

    /*-------- Time the second test function -----------------------*/
    puts("Testing testfunc2...");
    TIME_IT( testfunc2(), test2 );
    op2 = test2 - empty;

    /*-------- Show results ----------------------------------------*/
    printf("Test end:\n");
    printf("Empty function : %04.5f Sec.", empty/COUNTS_PER_SEC);
    printf("  %f uSec. each\n", empty/setting/COUNTS_PER_uSEC );
    printf("testfunc1 Gross: %04.5f Sec.\n", test1/COUNTS_PER_SEC);
    printf("testfunc1 Net  : %04.5f Sec.", op1/COUNTS_PER_SEC);
    printf(", %f uSec. each\n", op1/setting/COUNTS_PER_uSEC);
    printf("testfunc2 Gross: %04.5f Sec.\n", test2/COUNTS_PER_SEC);
    printf("testfunc2 Net  : %04.5f Sec.", op2/COUNTS_PER_SEC);
    printf(", %f uSec. each\n", op2/setting/COUNTS_PER_uSEC);

    HRTerm();                     /* Set PIT counter 0 to mode 3    */
    }
