/*********************************************************************
* STOPWATC.H - This file contains the typedef's, extern's, #define's *
*     and prototypes needed to interface with the high-resolution    *
*     timer functions.                                               *
*********************************************************************/

typedef unsigned char UCHAR;      /* Remove if you include OS2DEF.H */
typedef unsigned int  UINT;       /* Remove if you include OS2DEF.H */
typedef unsigned long ULONG;      /* Remove if you include OS2DEF.H */

typedef struct {
    UINT  TimerOverhead;          /* Avg. HRTimer overhead          */
    UINT  TickerOverhead;         /* Avg. BIOS ticker overhead      */
    UINT  StartCounter;           /* Starting value of PIT counter 0*/
    UINT  StopCounter;            /* Ending value of PIT counter 0  */
    ULONG StartTicker;            /* Start val of master clock count*/
    ULONG StopTicker;             /* End value of master clock count*/
    ULONG StartTime;              /* Relative starting time         */
    ULONG StopTime;               /* Relative ending time           */
    ULONG Interval;               /* Interval calc'd by StopWatch() */
    ULONG NumTicks;               /* Number of ticks during interval*/
    } HRstruct;

extern HRstruct HR;               /* Global struct with timer data  */

/*-------- Manifest constants used in StopWatch() processing--------*/
#define COUNTS_PER_SEC  (double)1193180
#define COUNTS_PER_mSEC (double)1193.18
#define COUNTS_PER_uSEC (double)1.19318
#define START 1                   /* Argument for StopWatch()       */
#define STOP  2                   /* Argument for StopWatch()       */
#define StartTimer() StopWatch( START )
#define StopTimer()  StopWatch( STOP )
#define CODETIME 1                /* Argument for HRInit()          */
#define REALTIME 2                /* Argument for HRInit()          */

/*-------- Function prototypes -------------------------------------*/
void HRInit( int Mode );
void HRTerm( void );
ULONG StopWatch( int Flag );
