/* 
 * Program Name: Ckdir.c
 * Author: Bob Smith
 * Revision Date: 12/24/88
 *
 * Purpose of Module:  To show the total size of a directory.
 * Compiler: TurboC Ver. 2.0
 *
 * Revision History:
 *
 *  12/25/88  -  J. Velte  
 */

#include <stdio.h>
#include <dir.h>

main(int argc, char *argv[])
{
	struct ffblk ffblk;
	float dir_size;

	if (-1 == findfirst(argv[1], &ffblk, 0)) {
		puts("no files found.\n");
		exit(0);
	}
	
	dir_size = ffblk.ff_fsize;
	printf(" %-15s %8d\n", ffblk.ff_name, ffblk.ff_fsize);
	
	while(-1 != findnext(&ffblk)) {
		dir_size += ffblk.ff_fsize;
		printf(" %-15s %8ld\n", ffblk.ff_name, ffblk.ff_fsize);
		/* 	         ^ this should be a *long* */
	}

	printf("\nTotal Size is : %8.0f Bytes\n", dir_size);
}
                                                                                      
