@echo off
REM *********************************************************************
REM *** MultiDir.bat - Display directories allowing for multiple file ***
REM ***                specifications.                                ***
REM ***                Example: MultiDir *.txt *.doc read*.*          ***
REM *********************************************************************

REM *************************************************************************
REM *** The Cmm code uses a temporary file to store temporary DIR output. ***
REM *** Define that name here.  The file will be removed at the end of    ***
REM *** this batch file.  If you want to alter the location of this       ***
REM *** temp file, perhaps to be on a ramdisk, then alter it here.        ***
REM *************************************************************************

SET MULTIDIR_FILENAME=%TEMP%\MultiDir.tmp
if exist %MULTIDIR_FILENAME% del %MULTIDIR_FILENAME%


REM *****************************
REM *** Let CEnvi do the rest ***
REM *****************************
CEnvi %0.bat %1 %2 %3 %4 %5 %6 %7 %8 %9
GOTO CENVI_EXIT

main(argc,argv)
{
   // check if help is being requested
   if ( 2 == argc
     && ( !stricmp(argv[1],"/?") || !stricmp(argv[1],"/help") ) ) {
      Instructions();
   } else {
      // collect all flags, which will be passed on to dir
      FlagCount = 0;
      for ( flags = "", arg = 1; arg < argc; arg++ ) {
         if ( '/' == argv[arg][0] ) {
            strcat(strcat(flags,argv[arg])," ");
            FlagCount++;
         }
      }
      if ( FlagCount == (argc-1) ) {
         // no filespec parameters were specified, and so simply to the dir call
         system("dir %s",flags);
      } else {
         // for each filespec in input parameters, pipe output of the dir command
         // to the temporary file
         for ( arg = 1; arg < argc; arg++ ) {
            if ( '/' != argv[arg][0] ) {
               system("dir %s %s >> %s",argv[arg],flags,MULTIDIR_FILENAME);
            }
         }
         // Read in each line from the Temporary filename and print it with
         // the single exception that if the line has already been printed then
         // don't print it.  This removes the problem of multiple printing of
         // filespecs when the filename matches more than one of the input
         // specs, and also keeps us from writing the volume labels and other
         // stuff more than once.
         fp = fopen(MULTIDIR_FILENAME,"r");
         assert( NULL != fp );
         Total = 0;
         while ( NULL != (line = fgets(fp))) {
            // don't print the bytes used or the bytes free
            if ( NULL == strstr(line,"bytes free") && NULL == strstr(line,"bytes used") ) {
               // don't print if already printed
               for ( i = 0; i < Total; i++ ) {
                  if ( !strcmp(line,DirList[i]) )
                     break;
               }
               if ( i == Total ) {
                  printf("%s",line);
                  DirList[Total++] = line;
               }
            }
         }
         fclose(fp);
      }
   }
}

Instructions()
{
   printf("\n")
   printf("MultiDir - Execute the system DIR command on multiple file-specs.\n")
   printf("\n")
   printf("SYNTAX: MultiDir [flags] [FileSpec1 [FileSpec2 [...]]]\n")
   printf("\n")
   printf("Where:  flags    - options passed on to the DIR command\n")
   printf("        FileSpec - FileSpec defines set of drive:filename files to list\n")
   printf("\n")
   printf("Example: MULTIDIR *.doc *.txt /b\n")
   printf("\n")
}

:CENVI_EXIT
REM *************************************************************
REM *** The CEnvi portion is finished.  Remove the temp file. ***
REM *************************************************************
if exist %MULTIDIR_FILENAME% del %MULTIDIR_FILENAME% > NUL
set MULTIDIR_FILENAME=
