/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <dos.h>
#include <strings.h>
#include <direct.h>
#include <stdlib.h>
#include <ctype.h>

       
/*
 *  Function :   geterrorlevel
 *
 *  Topic    :   Return errorlevel code from previous command executed
 *               by top COMMAND.COM (or equivalent)
 *
 *  Warning  :   This function is only valid with
 *               MS-DOS 3.20, 3.21, 3.30, 4.0, 4.01, 5.0 & NDOS 6.0.
 *               If MS-DOS version not supported returns -1
 *
 */

int geterrorlevel( void )

{ unsigned psp, far *tmp;
  int offset;
  char shell[255], buffer[255], *prgname;
          


        /* _psp is our PSP.  Follow the "parent" links back
           until we find a PSP for COMMAND.COM, which has
           a parent link that points at itself. */

  for ( psp = _psp; psp != *(tmp = MK_FP(psp,0x16)); psp = *tmp );


        /* locate environment */
  prgname = MK_FP( *(unsigned far *)MK_FP(psp,0x2C), 0 );
  while ( *prgname ) while ( *prgname++ );  /* locate end of environment */
  prgname += 3;

  fnsplit( prgname, buffer, buffer, shell, buffer );

  switch( *shell )
        {
          case 'N' :    /***   NDOS 6.0   ***/

                     offset  = 0x3FAB;
                     break;

          case '4' :    /***   4DOS   ***/

                     return -1;

          default  :    /***   COMMAND.COM :   offset depends of MS-DOS version   ***/

                     switch( _osmajor * 100 + _osminor )
                           {
                             case 320:
                             case 321: offset  = 0x0AFA /* or 3D31 */; break;
                             case 330: offset  = 0x0BEA; break;
                             case 400: offset  = 0x0F2B; break;
                             case 401: offset  = 0x0F2C; break;
                             case 500: offset  = 0x02A3; break;
                             default : return -1;
                           }

                     break;

        }

/*  DR-DOS 5.0: 44C1 or 0AE8 (version = 3.31)  */
/*  DR-DOS 6.0: 474D (version = 3.31)  */

  return *(unsigned far *)MK_FP( psp, offset );
}
