	title	IACAFILL - insert string in Inter-Application Comm. Area

; Copyright (c) 1991 by
;	Robert W. Babcock
;	WSS Division of DDC
;	4 Reeves Road
;	Bedford, MA  01730
;	USA
;	617-275-1183

; Unlimited non-commercial use authorized.

; This is an MS-DOS device driver which inserts its argument into the
; 16-byte Inter-application communication area at 40:f0 and then exits
; without installing.  The purpose it to enable passing information from
; CONFIG.SYS to AUTOEXEC.BAT.  A companion routine IACAREAD uses the value
; found at 40:f0 to set an environment variable.  Sample usage might be

; in CONFIG.SYS
;    device=c:\dos\drivers\iacafill.sys TD-386

; in AUTOEXEC.BAT
;    iacaread systype
;    if /%SYSTYPE% == /TD-386 goto td386_specific_code
;    if /%SYSTYPE% == /VANILLA goto vanilla_code

; Note that DOS 5 upcases the argument before this routine sees it.  On the
; other hand, the Quarterdeck DEVICE command for loading device drivers in a
; window does not upcase the argument.  I have not tested how previous DOS
; versions behave.

CR	equ	13		; carriage return
LF	equ	10		; line feed

; MS-DOS Request header definition
Request	struc
Rlength	db	?
Unit	db	?
Command	db	?
Status	dw	?
Reserve	db	8 dup(?)
Media	db	?
Addroff	dw	?
Addrseg	dw	?
Nameoff	dw	?	; also count
Nameseg	dw	?	; also sector
Request	ends

iaca	segment word

header	label word
	dd	-1
	dw	8000h		; character driver
	dw	offset init	; strategy=init for this driver which does
				; not install anything

	dw	offset interrupt
	db	'DRIVER  '

; I'm not sure why, but this entry point does get called
; even though the driver does not install itself.

interrupt proc	far
	xor	ax,ax
	ret
interrupt	endp

init_msg:
	db	CR, LF, 'IACAFILL version 1.0', CR, LF
	db	'  Copyright (c) 1991 by Robert W. Babcock'
	db	' and WSS Divison of DDC', CR, LF, '$'

; Execution starts here
; es:bx points to request header

init	proc	far
	assume	cs:iaca, ds:iaca

	mov	dx, offset init_msg
	mov	ah, 9
	int	21h

	mov	di, bx
	push	di
	push	es

	mov	si, es:[di.Nameoff]	; offset of device name in config.sys
	mov	ds, es:[di.Nameseg]	; segment of device name in config.sys

; skip over any spaces before driver name

trim_beginning:
	lodsb
	cmp	al, ' '
	jbe	trim_beginning

; skip over driver name (which could have been changed)

find_driver:
	lodsb
	cmp	al, ' '
	ja	find_driver

; skip over any trailing spaces

trim_end:
	lodsb
	cmp	al, ' '
	jbe	trim_end

	dec	si		; si has been incremented past first char

; ds:si now points to arg or CR if none

	mov	cx, 16		; max number of chars to move
	mov	ax, 40h
	mov	es, ax		; bios segment
	mov	di, 0f0h	; destination
store_loop:
	lodsb
	cmp	al, CR
	je	done
	stosb
	loop	store_loop
done:
	pop	es
	pop	di
	mov	byte ptr es:[di.Unit], 0	; zero units installed
	mov	word ptr es:[di.Addroff], 0	; free memory offset = 0
	mov	es:[di.Addrseg], cs		; free memory segment
	mov	word ptr es:[di.Status], 100h	; return code = done
	ret
init	endp
iaca	ends
	end
