/*	iacaread - looks for a string in memory at 40:f0 and sets an environment
	variable to the value found there.  Name of variable to set is entered
	on the command line.  Purpose of this routine is to pass information
	from CONFIG.SYS to AUTOEXEC.BAT.  A companion device driver IACAFILL.ASM
	sets the value at 40:f0.

	This routine uses a collection of environment-handling routines which were
	written by John Lowenthal (BIX: jlowenthal) and donated by OPENetwork to
	the public domain.  The code to find the master enviroment traces back to
	a message posted on BIX by P. Maupin.

	This main program and the companion IACAFILL.ASM are Copyright 1991 by
	Robert W. Babcock and WSS Division of DDC
	4 Reeves Road
	Bedford, MA  01730
	USA
	617-495-7107

	Unlimited non-commercial use is authorized.

	Compiled with Turbo C, large model.  MK_FP may be a problem with
	other compilers.

	Additional routines needed:
		ENVUTIL.C
		MASTENV.ASM
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include "envutil.h"

/* This define makes the executable smaller
 */
#define fputs(x,y) bdosptr(9, x "$", 0)

int main(int argc, char **argv)
	{
	unsigned envseg;
	char envstring[200];
	char *iaca_ptr=MK_FP(0x40, 0xf0);

	if(argc < 2)
		{
		fputs("iacaread requires name of environment variable to set\n", stderr);
		exit(1);
		}

	strcpy(envstring, argv[1]);
	strupr(envstring);					/* Otherwise will put lower case in env. */
	strcat(envstring, "=");
	strncat(envstring, iaca_ptr, 16);

	if(NULL == (envseg = findenv()))
		{
		fputs("iacaread can't find environment!\n", stderr);
		exit(1);
		}

	envseg++;

	if (! envadd(envseg, envstring))
		{
		fputs("iacaread unable to add string to environment\n", stderr);
		exit(1);
		}

	return(0);
	}
