/*
 *  Activate.c (v1.01)
 *
 *  NON-DOS routines for reading / writing 1st sector of hard drives
 *
 *  Developed under Coherent v4.0.0 - you may need to change the device
 *  names of the hard drive(s) to suit your own system
 *
 */


/*
 *  Reads in the first 512 bytes of the given device into the
 *  buffer (global variable) and extracts partition table info from the
 *  sector (partn tbl starts at 0x1BE, 4 entries of 0x10 bytes plus a 2
 *  byte signature at end. Returns 0 if read OK, non-zero otherwise.
 *
 */

int read_partition_table(partn, drive)
partition_table *partn;
char *drive;
{
  int status;
  FILE *dr;

  dr = fopen(drive, "rb"); 
  if(dr == NULL)
  {
    printf("\nerror opening drive %s", drive);
    exit(1);
  }
  status = fread(buffer, sizeof(byte), 512, dr);
  memmove(partn, (buffer + 0x1BE), sizeof(partition_table));

  return status;
}


/*
 *  Does the reverse of read_partition_table() - writes a new partition
 *  table into the relevent bit of buffer (the last 74 bytes) and writes
 *  the whole 512 bytes to the 1st sector of the specified Hard Drive
 *
 */


int write_partition_table(partn, drive)
partition_table partn;
char *drive;
{
  int status;
  FILE *dr;

  memmove((buffer + 0x1BE), &partn, sizeof(partition_table));
  
  dr = fopen(drive, "wb");
  if(dr == NULL)
  {
    printf("\nError opening drive %s for writing\n", drive);
    exit(1);
  }     
  status = fwrite(buffer, sizeof(byte), 512, dr);

  return status;
}


/*
 * Determines how many Hard drives the BIOS is aware of by trying to read
 * the Master Boot sector of each Hard drive starting from 0x80 (1st disk)
 * contines to read drives (0x81, 0x82, etc) until it receives an error,
 * after which it assumes that all physical drives have been read.
 *
 * Returns number of drives which it has detected.
 *
 */

int determine_number_of_drives()
{
  /* I don't know how to implement the proper calls (yet!) (Turbo C
     makes things so easy! <g>), so the quick and dirty way of doing 
     this is just to return a predefined constant */

  return(NUM_DRIVES);
}
