#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*    several utilities including    */
/*    low-level stuff for MS-DOS     */
/*                                   */
/*          MICROSOFT C 6.00         */
/*           QuickC/WIN 1.0          */
/*             ULTRIX cc             */
/*              GNU gcc              */
/*                                   */
/*   (include here compilers that    */
/*   compiled GEPASI successfully)   */
/*                                   */
/*************************************/


#ifndef MSDOS
#define COMMON
#endif

#ifdef _WINDOWS
#define COMMON
#endif

#include <stdio.h>
#include <string.h>
#include <time.h>

#ifndef COMMON                          /* is this MS-DOS ?    */
 #include <dos.h>
 #include <conio.h>
 #if (_MSC_VER >= 610)				    /* QuickC/WIN and C/C++ 7.0 */
  #define REGS _REGS
  #define getch _getch
  #define kbhit _kbhit
  #define int86 _int86
 #endif
#endif

/* stops processing for a specified number of seconds */
void sdelay(unsigned int seconds)
{
   time_t dtime;

   dtime = time(NULL) + seconds;
   while (dtime != time(NULL));
}

/* sets an extension for a pathname string.   */
/* can also be used on other types of strings */
/* appends *ext to *ss at the last look_for   */

void fixext(char *ss, char look_for, char *ext)
{
 char *p;

 if ( p = strrchr( ss, look_for ) ) strcpy( p, ext );
 else strcat(ss,ext);
}


/* sends a BELL to stderr */

void beep( void )
{
 fprintf( stderr, "\07" );
}


#ifdef COMMON  /* non MS-DOS */

/*
  we don't know how to clear the screen,
  so let's just send a carriage-return
*/
void cls( void )
{
 printf( "\n" );
}

/*
  for the following two we just return
*/

void set_cursor(int x, int y){ }
void get_cursor(int *x, int *y){ }

#else    /* good old MS-DOS! */

/*
  with a few low-level tricks we clear the screen !
*/
void cls(void)
{
   union REGS inregs;
   union REGS outregs;

   inregs.h.ah = 15;                    /* get active display page */
   int86(0x10,&inregs,&outregs);
   inregs.h.bh = outregs.h.bh;
   inregs.h.dl = 0;
   inregs.h.dh = 0;
   inregs.h.ah = 2;                     /* set cursor position */
   int86(0x10,&inregs,&outregs);
   inregs.h.bh = 0x07;
   inregs.h.cl = 0;
   inregs.h.ch = 0;
   inregs.h.dl = 79;
   inregs.h.dh = 24;
   inregs.h.al = 0;
   inregs.h.ah = 7;                     /* do the backscroll */
   int86(0x10,&inregs,&outregs);
}

/*
  more low-level to set the cursor position...
*/
void set_cursor(int x, int y)
{
 union REGS regs;

 regs.h.ah  =  2;
 regs.h.dh  =  (unsigned char) y;
 regs.h.dl  =  (unsigned char) x;
 regs.h.bh  =  0;
 int86(0x10,&regs,&regs);
}

/*
  and get the cursor position.
*/
void get_cursor(int *x, int *y)
{
 union REGS inregs;
 union REGS outregs;

 inregs.h.ah  =  3;
 inregs.h.bh  =  0;
 int86(0x10,&inregs,&outregs);
 *y = outregs.h.dh;
 *x = outregs.h.dl;
}

#endif

