#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*          GWTOP - Topology         */
/*        MS-WINDOWS front end       */
/*                                   */
/*       Initialization and some     */
/*           data structures         */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include "globals.h"
#include "topgvar.h"
#include "strtbl.h"
#include "gwtop.h"
#include "iotop.h"

struct kint {
		  		unsigned char nsub;
				unsigned char npro;
				unsigned char nmodf;
				unsigned char revers;
				int idx;
				LPSTR descr;
	   	    };

struct nodet{
             char item;
             unsigned char val;
             unsigned char left;
             unsigned char right;
            } ;

struct treet{
             struct nodet node[256];
             char id[64][10];
             float constant[32];
             int nnode,
                 nnum,
                 nid,
                 nsub,
                 npro,
                 nmodf,
                 nconst,
                 revers;
             char descr[64];
            } ;


GLOBALHANDLE hMetname;								/* handle to memory block w/ metname	*/
GLOBALHANDLE hStepname;								/* handle to memory block w/ stepname	*/
GLOBALHANDLE hStoiu;								/* handle to memory block w/ stoiu		*/
GLOBALHANDLE hLoop;									/* handle to memory block w/ loop		*/
GLOBALHANDLE hKtype;								/* handle to memory block w/ ktype		*/
GLOBALHANDLE hRstr;									/* handle to memory block w/ rstr		*/
GLOBALHANDLE hTree;									/* handle to memory block w/ tree		*/

char	(huge *metname)[NAME_L];					/* pointer to work with metname array	*/
char	(huge *stepname)[NAME_L];					/* metabolite names						*/
int		huge *stoiu;								/* pointer to work with metname array	*/
unsigned char (huge *loop)[MAX_STEP][MAX_MET];		/* def. of modification loops			*/
int     (huge *rstr)[MAX_STEP][MAX_MOL];			/* reaction structure					*/
char	topname[256];								/* title for the topology				*/
double	xu[MAX_MET];								/* concentrations at time t user		*/
int		intmet[MAX_MET];							/* 1 if internal metabolite				*/
unsigned char	revers[MAX_STEP];					/* 1 if reaction is reversible			*/
int		kinetu[MAX_STEP];							/* type of kinetics (user numb.)		*/
int		kfl[MAX_STEP];								/* flags for input of user-def.kinetics */
unsigned char	nmod[MAX_STEP];						/* number of assigned modfs of a react.	*/
struct	kint huge *ktype;							/* ptr array of kinetic types & proprt	*/
double	endtime;									/* time value for last iteration		*/
double	hrcz;										/* highest rate considered zero			*/
double	dft_endtime;								/* time value for last iteration		*/
double	dft_hrcz;									/* highest rate considered zero			*/
float	ver_no;										/* .top and .sim version number			*/
int		totmet;										/* number of total metabolites			*/
int		nmetab;										/* number of internal metabolites		*/
int		nsteps;										/* number of steps                		*/
int		nloops;										/* number of modifier loops             */
int		nrateq;										/* number of kinetic types in the datab */
int		newtree;									/* 1 if user added kinetic new types	*/
int		nudf;										/* number of user-defined kin. types	*/
int		debugval;									/* debug mode							*/
int		dft_debugval;								/* debug mode							*/
int		options;									/* various options						*/
struct	treet huge *tree;							/* function tree for rate equations		*/
struct	treet tr;									/* tree for the input					*/

/* Initialization of GEPASI's variables */

int InitGepasiVar( void )
{
 int i, j;

 hMetname = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, (DWORD) MAX_MET * NAME_L * sizeof( char ) );
 if( hMetname == NULL ) return -1;

 hStepname = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, (DWORD) MAX_STEP * NAME_L * sizeof( char ) );
 if( hStepname == NULL )
 {
  GlobalFree( hMetname );
  return -1;
 }

 hStoiu = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, (DWORD) MAX_MET * MAX_STEP * sizeof( int ) );
 if( hStoiu == NULL )
 {
  GlobalFree( hMetname );
  GlobalFree( hStepname );
  return -1;
 }

 hLoop = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, (DWORD) MAX_STEP * MAX_MET * sizeof( unsigned char ) );
 if( hLoop == NULL )
 {
  GlobalFree( hMetname );
  GlobalFree( hStepname );
  GlobalFree( hStoiu );
  return -1;
 }

 hKtype = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, (DWORD) MAX_TYP * sizeof( struct kint ) );
 if( hKtype == NULL )
 {
  GlobalFree( hMetname );
  GlobalFree( hStepname );
  GlobalFree( hStoiu );
  GlobalFree( hLoop );
  return -1;
 }

 hRstr = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, (DWORD) MAX_MOL * MAX_STEP * sizeof( int ) );
 if( hRstr == NULL )
 {
  GlobalFree( hMetname );
  GlobalFree( hStepname );
  GlobalFree( hStoiu );
  GlobalFree( hLoop );
  GlobalFree( hKtype );
  return -1;
 }

 nudf = 0;
 hTree = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, (DWORD) sizeof( struct treet ) );
 if( hTree == NULL )
 {
  GlobalFree( hMetname );
  GlobalFree( hStepname );
  GlobalFree( hStoiu );
  GlobalFree( hLoop );
  GlobalFree( hKtype );
  GlobalFree( hRstr );
  return -1;
 }

 metname	= ( char (huge *)[NAME_L] ) GlobalLock( hMetname );
 stepname	= ( char (huge *)[NAME_L] ) GlobalLock( hStepname );
 stoiu		= ( int huge * ) GlobalLock( hStoiu );
 loop		= ( unsigned char (huge *)[MAX_STEP][MAX_MET] ) GlobalLock( hLoop );
 ktype		= ( struct kint huge * ) GlobalLock( hKtype );
 rstr		= ( int (huge *)[MAX_STEP][MAX_MOL] ) GlobalLock( hRstr );
 tree		= ( struct treet huge * ) GlobalLock( hTree );

 newtree = 0;

 for( i=0; i<MAX_MET; i++ ) intmet[i] = 1;			/* set all metb. to be internal	*/
 totmet = nmetab = nsteps = 0;						/* clear no. of metb. and steps	*/

 nrateq = MAX_TYP;                                  /* set the no. of kinetic types */
 ktype[NOT].nsub = 0;								/* init info of kinetic types	*/
 ktype[NOT].npro = 0;
 ktype[NOT].revers = -1;
 ktype[NOT].nmodf = 0;
 ktype[NOT].descr = (LPSTR) "<not defined>";
 ktype[I01].nsub = 0;
 ktype[I01].npro = 0;
 ktype[I01].revers = 0;
 ktype[I01].nmodf = 0;
 ktype[I01].descr = (LPSTR) "constant rate";
 ktype[I10].nsub = 20;
 ktype[I10].npro = 20;
 ktype[I10].revers = 0;
 ktype[I10].nmodf = 0;
 ktype[I10].descr = (LPSTR) "no type";
 ktype[I11].nsub = 1;
 ktype[I11].npro = 1;
 ktype[I11].revers = 0;
 ktype[I11].nmodf = 0;
 ktype[I11].descr = (LPSTR) "mass action";
 ktype[R11].nsub = 1;
 ktype[R11].npro = 1;
 ktype[R11].revers = 1;
 ktype[R11].nmodf = 0;
 ktype[R11].descr = (LPSTR) ktype[I11].descr;
 ktype[I21].nsub = 2;
 ktype[I21].npro = 1;
 ktype[I21].revers = 0;
 ktype[I21].nmodf = 0;
 ktype[I21].descr = (LPSTR) ktype[I11].descr;
 ktype[R21].nsub = 2;
 ktype[R21].npro = 1;
 ktype[R21].revers = 1;
 ktype[R21].nmodf = 0;
 ktype[R21].descr = (LPSTR) ktype[I11].descr;
 ktype[I12].nsub = 1;
 ktype[I12].npro = 2;
 ktype[I12].revers = 0;
 ktype[I12].nmodf = 0;
 ktype[I12].descr = (LPSTR) ktype[I11].descr;
 ktype[R12].nsub = 1;
 ktype[R12].npro = 2;
 ktype[R12].revers = 1;
 ktype[R12].nmodf = 0;
 ktype[R12].descr = (LPSTR) ktype[I11].descr;
 ktype[I31].nsub = 3;
 ktype[I31].npro = 1;
 ktype[I31].revers = 0;
 ktype[I31].nmodf = 0;
 ktype[I31].descr = (LPSTR) ktype[I11].descr;
 ktype[R31].nsub = 3;
 ktype[R31].npro = 1;
 ktype[R31].revers = 1;
 ktype[R31].nmodf = 0;
 ktype[R31].descr = (LPSTR) ktype[I11].descr;
 ktype[I13].nsub = 1;
 ktype[I13].npro = 3;
 ktype[I13].revers = 0;
 ktype[I13].nmodf = 0;
 ktype[I13].descr = (LPSTR) ktype[I11].descr;
 ktype[R13].nsub = 1;
 ktype[R13].npro = 3;
 ktype[R13].revers = 1;
 ktype[R13].nmodf = 0;
 ktype[R13].descr = (LPSTR) ktype[I11].descr;
 ktype[I22].nsub = 2;
 ktype[I22].npro = 2;
 ktype[I22].revers = 0;
 ktype[I22].nmodf = 0;
 ktype[I22].descr = (LPSTR) ktype[I11].descr;
 ktype[R22].nsub = 2;
 ktype[R22].npro = 2;
 ktype[R22].revers = 1;
 ktype[R22].nmodf = 0;
 ktype[R22].descr = (LPSTR) ktype[I11].descr;
 ktype[I32].nsub = 3;
 ktype[I32].npro = 2;
 ktype[I32].revers = 0;
 ktype[I32].nmodf = 0;
 ktype[I32].descr = (LPSTR) ktype[I11].descr;
 ktype[R32].nsub = 3;
 ktype[R32].npro = 2;
 ktype[R32].revers = 1;
 ktype[R32].nmodf = 0;
 ktype[R32].descr = (LPSTR) ktype[I11].descr;
 ktype[I23].nsub = 2;
 ktype[I23].npro = 3;
 ktype[I23].revers = 0;
 ktype[I23].nmodf = 0;
 ktype[I23].descr = (LPSTR) ktype[I11].descr;
 ktype[R23].nsub = 2;
 ktype[R23].npro = 3;
 ktype[R23].revers = 1;
 ktype[R23].nmodf = 0;
 ktype[R23].descr = (LPSTR) ktype[I11].descr;
 ktype[I33].nsub = 3;
 ktype[I33].npro = 3;
 ktype[I33].revers = 0;
 ktype[I33].nmodf = 0;
 ktype[I33].descr = (LPSTR) ktype[I11].descr;
 ktype[R33].nsub = 3;
 ktype[R33].npro = 3;
 ktype[R33].revers = 1;
 ktype[R33].nmodf = 0;
 ktype[R33].descr = (LPSTR) ktype[I11].descr;
 ktype[IMM].nsub = 1;
 ktype[IMM].npro = 1;
 ktype[IMM].revers = 0;
 ktype[IMM].nmodf = 0;
 ktype[IMM].descr = (LPSTR) "Michaelis-Menten";
 ktype[RMM].nsub = 1;
 ktype[RMM].npro = 1;
 ktype[RMM].revers = 1;
 ktype[RMM].nmodf = 0;
 ktype[RMM].descr = (LPSTR) "reversible Michaelis-Menten";
 ktype[PSI].nsub = 1;
 ktype[PSI].npro = 1;
 ktype[PSI].revers = 1;
 ktype[PSI].nmodf = 1;
 ktype[PSI].descr = (LPSTR) "specific inhibition";
 ktype[PCI].nsub = 1;
 ktype[PCI].npro = 1;
 ktype[PCI].revers = 1;
 ktype[PCI].nmodf = 1;
 ktype[PCI].descr = (LPSTR) "catalytic inhibition";
 ktype[MXI].nsub = 1;
 ktype[MXI].npro = 1;
 ktype[MXI].revers = 1;
 ktype[MXI].nmodf = 1;
 ktype[MXI].descr = (LPSTR) "mixed inhibition";
 ktype[PSA].nsub = 1;
 ktype[PSA].npro = 1;
 ktype[PSA].revers = 1;
 ktype[PSA].nmodf = 1;
 ktype[PSA].descr = (LPSTR) "specific activation";
 ktype[PCA].nsub = 1;
 ktype[PCA].npro = 1;
 ktype[PCA].revers = 1;
 ktype[PCA].nmodf = 1;
 ktype[PCA].descr = (LPSTR) "catalytic activation";
 ktype[MXA].nsub = 1;
 ktype[MXA].npro = 1;
 ktype[MXA].revers = 1;
 ktype[MXA].nmodf = 1;
 ktype[MXA].descr = (LPSTR) "mixed activation";
 ktype[GOM].nsub = 20;
 ktype[GOM].npro = 20;
 ktype[GOM].revers = 1;
 ktype[GOM].nmodf = 1;
 ktype[GOM].descr = (LPSTR) "Botts-Morales";
 ktype[HIL].nsub = 1;
 ktype[HIL].npro = 1;
 ktype[HIL].revers = 0;
 ktype[HIL].nmodf = 0;
 ktype[HIL].descr = (LPSTR) "Hill";
 ktype[RHL].nsub = 20;
 ktype[RHL].npro = 20;
 ktype[RHL].revers = 1;
 ktype[RHL].nmodf = 0;
 ktype[RHL].descr = (LPSTR) "reversible Hill";
 ktype[UBS].nsub = 1;
 ktype[UBS].npro = 2;
 ktype[UBS].revers = 1;
 ktype[UBS].nmodf = 0;
 ktype[UBS].descr = (LPSTR) "Ordered Uni Bi (A=P+Q)";
 ktype[UBM].nsub = 1;
 ktype[UBM].npro = 1;
 ktype[UBM].revers = 1;
 ktype[UBM].nmodf = 0;
 ktype[UBM].descr = (LPSTR) "Ordered Uni Bi (A=2*P)";
 ktype[ALI].nsub = 1;
 ktype[ALI].npro = 1;
 ktype[ALI].revers = 1;
 ktype[ALI].nmodf = 1;
 ktype[ALI].descr = (LPSTR) "allosteric inhibition";

 if( (i = in_kinet()) )
 {
  LoadString( hInst, i, szString, sizeof(szString) );
  MessageBeep( MB_ICONQUESTION );
  MessageBox( NULL, szString, (LPSTR) "user-def.kin", MB_ICONINFORMATION );
 }
 return 0;
}

/*
   output error message from the lexical analyser
*/

int lexyy_fatal( char *m )
{
 MessageBeep( MB_OK );
 MessageBox( NULL, (LPSTR) m, (LPSTR) "Lexical Analyser Error", MB_ICONINFORMATION );
 return 0;
}

/*
   create a new function tree object
*/

int new_tree( int idx )
{
 if( !eqefl )
 {
  nudf++;
  GlobalUnlock( hTree );
  hTree = GlobalReAlloc( hTree, (DWORD) nudf * sizeof( struct treet ), GMEM_ZEROINIT | GMEM_MOVEABLE );
  if( hTree == NULL )
   return IDS_ERR_NOEXEC;
  tree = ( struct treet huge * ) GlobalLock( hTree );
 }
 _fmemcpy( (void __far *) &tree[idx], (void __far *) &tr, sizeof( struct treet ) );
 newtree = 1;
 return 0;
}

/*
  count the number of substrates, etc. in the function tree
  and allocate memory for the string with the title
*/

void tidy_tree( void )
{
 int i, l;

 for( tr.nsub =
      tr.npro =
      tr.nmodf =
      tr.nconst =
      i = 0; i<tr.nid; i++ )
  switch( (int) tr.id[i][9] )
  {
   case 0: tr.nconst++; break;
   case 1: tr.nsub++; break;
   case 2: tr.npro++; break;
   case 3: tr.nmodf++; break;
  }
}


/*
   read the user-defined kinetic types in the database
*/

int in_kinet( void )
{
 GLOBALHANDLE hTemp;
 HANDLE hBuff;
 OFSTRUCT OfStruct;
 struct stat fst;
 unsigned int bufsize;
 char *Buff;
 char fn[128], *ptr;
 int ch1;
 int nRc;

 /* make the complete pathname of user-def.kin			*/
 GetModuleFileName( hInst, (LPSTR) fn, sizeof( fn ) );
 ptr = strrchr( fn, '\\' );
 *(ptr+1) = '\0';
 lstrcat( (LPSTR) fn, (LPSTR) "user-def.kin" );

 /* open the file													*/
 ch1 = OpenFile( fn, &OfStruct, OF_READ );
 if( ch1 != -1 )
 {
  /* get the file statistics										*/
  fstat( ch1, &fst );

  /* set the buffer to the size of the file plus one				*/
  bufsize = (unsigned int) fst.st_size;

  /* allocate space for the read buffer and lock it					*/
  hBuff = LocalAlloc( GMEM_MOVEABLE | GMEM_DISCARDABLE, (WORD) (bufsize+1) );
  if( hBuff == NULL ) return IDS_ERR_NOEXEC;
  Buff = (char *) LocalLock( hBuff );

  /*read the file and close it										*/
  if( read( ch1, Buff, bufsize ) == -1 )
  {
   LocalUnlock( hBuff );
   LocalFree( hBuff );
   return IDS_ERR_LOAD;
  }
  close( ch1 );

  for( ; ; )
  {
   /* look for a form-feed											*/
   Buff = strchr( Buff, '\f' );
   if( Buff==NULL )
   {
    LocalUnlock( hBuff );
    LocalFree( hBuff );
    return 0;
   }
   Buff++;
   /* create a new tree structure to hold this kinetic type			*/
   eqefl = 0;
   new_tree( nudf );
   /* get another tree from the buffer								*/
   if( (Buff = BufToTree( Buff ) ) == NULL )
   {
    LocalUnlock( hBuff );
    LocalFree( hBuff );
    return IDS_ERR_DATAB_CORRUPT;
   }
   /* copy the tree structure to the permanent storage				*/
   _fmemcpy( (void __far *) &tree[nudf-1], (void __far *) &tr, sizeof( struct treet ) );
   /* store the new type in ktype									*/
   GlobalUnlock( hKtype );
   hTemp = GlobalReAlloc( hKtype, (DWORD) (nrateq+1) * sizeof( struct kint ), GMEM_ZEROINIT | GMEM_MOVEABLE );
   if( hTemp != NULL )
   {
    hKtype = hTemp;
    ktype = ( struct kint huge * ) GlobalLock( hKtype );
    ktype[nrateq].nsub = (unsigned char) tree[nudf-1].nsub;
    ktype[nrateq].npro = (unsigned char) tree[nudf-1].npro;
    ktype[nrateq].revers = (unsigned char) tree[nudf-1].revers;
    ktype[nrateq].nmodf = (unsigned char) tree[nudf-1].nmodf;
    ktype[nrateq].descr = (LPSTR) tree[nudf-1].descr;
    nrateq++;
   }
   else
   {
    ktype = ( struct kint huge * ) GlobalLock( hKtype );
    LocalUnlock( hBuff );
    LocalFree( hBuff );
    return IDS_ERR_NOEXEC;
   }
  }
 }
 else return 0; /*IDS_ERR_LOAD;*/
}

/*
   write the user-defined kinetic types in the database
*/

int out_tree( void )
{
 char Buff[5500];
 int ch1;
 OFSTRUCT OfStruct;
 char fn[128], *ptr;
 int i;

 /* make the complete pathname of user-def.kin			*/
 GetModuleFileName( hInst, (LPSTR) fn, sizeof( fn ) );
 ptr = strrchr( fn, '\\' );
 *(ptr+1) = '\0';
 lstrcat( (LPSTR) fn, (LPSTR) "user-def.kin" );

 /* first create the file												*/
 if( (ch1 = OpenFile( fn, &OfStruct, OF_CREATE | OF_WRITE )) == -1 )
  return IDS_ERR_SAVE;
 close( ch1 );

 /* for all user-defined kinetic types									*/
 for( i=0; i<nudf; i++ )
 {
  /* write the tree function to the buffer								*/
  TreeToBuf( i, (LPSTR) Buff );
  /* reopen the file and write this tree to it							*/
  if( (ch1 = OpenFile( (LPSTR) NULL, &OfStruct, OF_REOPEN | OF_WRITE )) != -1 )
  {
   /* write the buffer to the file and close it							*/
   _lseek( ch1, (LONG) 0, 2 );
   _lwrite( ch1, (LPSTR) Buff, (WORD) strlen( Buff ) );
   _lclose( ch1 );
  }
  if( ch1 == -1 ) return IDS_ERR_SAVE;
 }
 return 0;
}


/*
  add a user-defined rate equation to the database
*/

int new_rateq( int idx )
{
 GLOBALHANDLE hTemp;

 /* unlock the memory handle	*/
 GlobalUnlock( hKtype );
 hTemp = GlobalReAlloc( hKtype, (DWORD) (nrateq+1) * sizeof( struct kint ), GMEM_ZEROINIT | GMEM_MOVEABLE );
 if( hTemp != NULL )
 {
  hKtype = hTemp;
  ktype = ( struct kint huge * ) GlobalLock( hKtype );
  ktype[MAX_TYP+idx].nsub = (unsigned char) tree[idx].nsub;
  ktype[MAX_TYP+idx].npro = (unsigned char) tree[idx].npro;
  ktype[MAX_TYP+idx].revers = (unsigned char) tree[idx].revers;
  ktype[MAX_TYP+idx].nmodf = (unsigned char) tree[idx].nmodf;
  ktype[MAX_TYP+idx].descr = (LPSTR) tree[idx].descr;
  if( !eqefl ) nrateq++;
  return 0;
 }
 else
 {
  ktype = ( struct kint huge * ) GlobalLock( hKtype );
  return IDS_ERR_NOEXEC;
 }
}


/*
  free global heap space allocated
*/

void TidyGepasiVar( void )
{
 GlobalUnlock( hMetname );							/* unlock all global handles	*/
 GlobalUnlock( hStepname );
 GlobalUnlock( hStoiu );
 GlobalUnlock( hLoop );
 GlobalUnlock( hRstr );
 GlobalUnlock( hKtype );
 GlobalUnlock( hTree );

 GlobalFree( hMetname );							/* free all global mem blocks	*/
 GlobalFree( hStepname );
 GlobalFree( hStoiu );
 GlobalFree( hLoop );
 GlobalFree( hRstr );
 GlobalFree( hKtype );
 GlobalFree( hTree );
}


