#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*         GWSIM - Simulation        */
/*        MS-WINDOWS front end       */
/*                                   */
/*               Tasks               */
/*            dialog box             */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwsim.h"						/* macros, function prototypes, etc.	*/
#include "gep2.h"						/* gepasi's variables					*/
#include "simgvar.h"					/* global variables						*/
#include "strtbl.h"						/* symbols for the string table			*/

#pragma alloc_text( CODE3, EdOTask)

BOOL FAR PASCAL EdOTask(HWND hDlg, WORD message, WORD wParam, LONG lParam)
{
 static	HWND	hEndTime,
 				hPoints,
 				hStat1,
 				hStat2,
 				hDyn,
 				hSS,
 				hRep,
 				hDat,
 				hLog;
 char buff[32];
 char *dummy;
 int len;

 switch( message )
 {
  case WM_INITDIALOG:
   /* get handles to controls										*/
   hEndTime = GetDlgItem( hDlg, IDE_M0 );
   hPoints = GetDlgItem( hDlg, IDE_M1 );
   hStat1 = GetDlgItem( hDlg, IDSTAT_1 );
   hStat2 = GetDlgItem( hDlg, IDSTAT_4 );
   hDyn = GetDlgItem( hDlg, IDC_DYNAMICS );
   hSS = GetDlgItem( hDlg, IDC_SS );
   hRep = GetDlgItem( hDlg, IDC_TXT );
   hDat = GetDlgItem( hDlg, IDC_DAT );
   hLog = GetDlgItem( hDlg, IDC_LOG );

   /* fill in the current set of options							*/
   gcvt( options.endtime, 8, buff );
   SendMessage( hEndTime, WM_SETTEXT, 0, (DWORD)(LPSTR)  buff );
   itoa( (int) options.pfo, buff, 10 );
   SendMessage( hPoints, WM_SETTEXT, 0, (DWORD)(LPSTR)  buff );
   SendMessage( hDyn, BM_SETCHECK, (WORD) options.dyn, 0 );
   SendMessage( hDlg, WM_COMMAND, IDC_DYNAMICS, 0 );
   SendMessage( hSS, BM_SETCHECK, (WORD) options.ss, 0 );
   SendMessage( hRep, BM_SETCHECK, (WORD) options.txt, 0 );
   SendMessage( hDat, BM_SETCHECK,  (WORD) options.dat, 0 );
   SendMessage( hLog, BM_SETCHECK,  (WORD) options.debug, 0 );

   return TRUE;

  case WM_COMMAND:
   switch( wParam )
   {
    case IDC_DYNAMICS:
     if( SendMessage( hDyn, BM_GETCHECK, 0, 0 ) )
     {
      EnableWindow( hEndTime, TRUE );
      EnableWindow( hStat1, TRUE );
      EnableWindow( hPoints, TRUE );
      EnableWindow( hStat2, TRUE );
     }
     else
     {
      EnableWindow( hEndTime, FALSE );
      EnableWindow( hStat1, FALSE);
      EnableWindow( hPoints, FALSE );
      EnableWindow( hStat2, FALSE );
     }
     return TRUE;

    case IDC_HELP:                        /* Help for this Dialog Box			 */
  	 WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Execution tasks" );
     return TRUE;

    case IDOK:
     /* read all variables from the controls		*/
     options.debug = (int) SendMessage( hLog, BM_GETCHECK, 0, 0 );
     options.dyn   = (int) SendMessage( hDyn, BM_GETCHECK, 0, 0 );
     options.ss    = (int) SendMessage( hSS, BM_GETCHECK, 0, 0 );
     options.dat   = (int) SendMessage( hDat, BM_GETCHECK, 0, 0 );
     options.txt   = (int) SendMessage( hRep, BM_GETCHECK, 0, 0 );
     if( options.dyn )
     {
      len = (int) SendMessage( hEndTime, WM_GETTEXT, (WORD) sizeof( buff ), (DWORD)(LPSTR) buff );
      if( len==0) options.endtime = dft_endtime;
      else options.endtime = strtod( buff, &dummy );
      if( (options.endtime==HUGE_VAL) || (options.endtime==-HUGE_VAL) )
      {
       LoadString(hInst, IDS_ERR_OVERFLOW, szString, sizeof(szString));
       MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
       SetFocus( hEndTime );
       return TRUE;
      }
      len = (int) SendMessage( hPoints, WM_GETTEXT, (WORD) sizeof( buff ), (DWORD)(LPSTR) buff );
      if( len==0) options.pfo = dft_pfo;
      else
      {
       len = atoi( buff );
       if( (len<=0) )
       {
        LoadString(hInst, IDS_ERR_ZEROBAD, szString, sizeof(szString));
        MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
        SetFocus( hPoints );
        return TRUE;
       }
       options.pfo = len;

      }
     }

     /* signal that changes were made				*/
     notsaved = 1;
     /* close the dialog box and return				*/
     EndDialog( hDlg, IDOK );
     return TRUE;

    case IDCANCEL:
     /* close the dialog box and return			*/
     EndDialog( hDlg, IDCANCEL );
     return TRUE;
   }

  default: return FALSE;
 }
}